/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetColumnTypeToDb
extends AbstractToDbToken.Entity {
    private DbAttribute columnOriginal;
    private DbAttribute columnNew;

    public SetColumnTypeToDb(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        super(entity);
        this.columnOriginal = columnOriginal;
        this.columnNew = columnNew;
    }

    protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quoteFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ALTER ");
        sqlBuffer.append(context.quoteString(this.columnNew.getName()));
        sqlBuffer.append(" TYPE ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
        this.appendPrefix(sqlBuffer, context);
        String[] types = adapter.externalTypesForJdbcType(this.columnNew.getType());
        if (types == null || types.length == 0) {
            String entityName = this.columnNew.getEntity() != null ? ((DbEntity)this.columnNew.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + this.columnNew.getName() + "': " + this.columnNew.getType(), new Object[0]);
        }
        String type = types[0];
        sqlBuffer.append(type);
        if (TypesMapping.supportsLength(this.columnNew.getType())) {
            int scale;
            int len = this.columnNew.getMaxLength();
            int n = scale = TypesMapping.isDecimal(this.columnNew.getType()) ? this.columnNew.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Set Column Type";
    }

    @Override
    public String getTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntity().getName());
        sb.append(".");
        sb.append(this.columnNew.getName());
        if (this.columnOriginal.getType() != this.columnNew.getType()) {
            sb.append(" type: ");
            sb.append(TypesMapping.getSqlNameByType(this.columnOriginal.getType()));
            sb.append(" -> ");
            sb.append(TypesMapping.getSqlNameByType(this.columnNew.getType()));
        }
        if (this.columnOriginal.getMaxLength() != this.columnNew.getMaxLength()) {
            sb.append(" maxLength: ");
            sb.append(this.columnOriginal.getMaxLength());
            sb.append(" -> ");
            sb.append(this.columnNew.getMaxLength());
        }
        if (this.columnOriginal.getAttributePrecision() != this.columnNew.getAttributePrecision()) {
            sb.append(" precision: ");
            sb.append(this.columnOriginal.getAttributePrecision());
            sb.append(" -> ");
            sb.append(this.columnNew.getAttributePrecision());
        }
        if (this.columnOriginal.getScale() != this.columnNew.getScale()) {
            sb.append(" scale: ");
            sb.append(this.columnOriginal.getScale());
            sb.append(" -> ");
            sb.append(this.columnNew.getScale());
        }
        return sb.toString();
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetColumnTypeToModel(this.getEntity(), this.columnNew, this.columnOriginal);
    }

    public DbAttribute getColumnOriginal() {
        return this.columnOriginal;
    }

    public DbAttribute getColumnNew() {
        return this.columnNew;
    }
}

