/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.TableTreeNode;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTPath;

class TableTreeQualifierStage
implements TranslationStage {
    TableTreeQualifierStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        context.getTableTree().visit(node -> {
            TableTreeQualifierStage.appendQualifier(context, node, node.getEntity().getQualifier());
            TableTreeQualifierStage.appendQualifier(context, node, node.getAdditionalQualifier());
        });
        if (context.getQualifierNode() != null) {
            context.getSelectBuilder().where(context.getQualifierNode());
        }
    }

    private static void appendQualifier(TranslatorContext context, TableTreeNode node, Expression dbQualifier) {
        if (dbQualifier == null) {
            return;
        }
        String pathToRoot = node.getAttributePath().getPath();
        dbQualifier = dbQualifier.transform(input -> {
            if (input instanceof ASTPath) {
                String path = ((ASTPath)input).getPath();
                if (!pathToRoot.isEmpty()) {
                    path = pathToRoot + '.' + path;
                }
                return new ASTDbPath(path);
            }
            return input;
        });
        Node translatedQualifier = context.getQualifierTranslator().translate(dbQualifier);
        context.appendQualifierNode(translatedQualifier);
    }
}

