/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EmbeddableAttributeHandler
extends NamespaceAwareNestedTagHandler {
    private static final String EMBEDDED_ATTRIBUTE_TAG = "embedded-attribute";
    private static final String EMBEDDABLE_ATTRIBUTE_OVERRIDE_TAG = "embeddable-attribute-override";
    private ObjEntity entity;
    private EmbeddedAttribute embeddedAttribute;

    public EmbeddableAttributeHandler(NamespaceAwareNestedTagHandler parentHandler, ObjEntity entity) {
        super(parentHandler);
        this.entity = entity;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "embedded-attribute": {
                this.createEmbeddableAttribute(attributes);
                return true;
            }
            case "embeddable-attribute-override": {
                this.createEmbeddableAttributeOverride(attributes);
                return true;
            }
        }
        return false;
    }

    private void createEmbeddableAttribute(Attributes attributes) {
        this.embeddedAttribute = new EmbeddedAttribute(attributes.getValue("name"));
        this.embeddedAttribute.setType(attributes.getValue("type"));
        this.entity.addAttribute(this.embeddedAttribute);
    }

    private void createEmbeddableAttributeOverride(Attributes attributes) {
        this.embeddedAttribute.addAttributeOverride(attributes.getValue("name"), attributes.getValue("db-attribute-path"));
    }
}

