/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private Map authenticationData = new TreeMap();

    public void setData(Type type, char[] data) {
        this.authenticationData.put(type, data);
    }

    public char[] getData(Type type) {
        return (char[])this.authenticationData.get(type);
    }

    public void cleanup() {
        Iterator iterAuthenticationData = this.authenticationData.values().iterator();
        while (iterAuthenticationData.hasNext()) {
            char[] data = (char[])iterAuthenticationData.next();
            if (data == null || data.length < 0) continue;
            for (int i = 0; i < data.length; ++i) {
                data[i] = '\u0000';
            }
        }
        this.authenticationData.clear();
    }

    public static class Type
    implements Comparable {
        private final String type;

        public Type(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type1 = (Type)o;
            return !(this.type != null ? !this.type.equals(type1.type) : type1.type != null);
        }

        public int compareTo(Object o) {
            Type t = (Type)o;
            return this.type.compareTo(t.type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

