/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.HostFileNameParser;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class FtpFileNameParser
extends HostFileNameParser {
    private static final FtpFileNameParser INSTANCE = new FtpFileNameParser();
    private static final int PORT = 21;

    public FtpFileNameParser() {
        super(21);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String fileName) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        HostFileNameParser.Authority auth = this.extractToPath(fileName, name);
        String queuString = UriParser.extractQueryString(name);
        if (queuString == null && base instanceof URLFileName) {
            queuString = ((URLFileName)base).getQueryString();
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new URLFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), this.getDefaultPort(), auth.getUserName(), auth.getPassword(), path, fileType, queuString);
    }
}

