/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.net.BindException;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class BaseClassForTests {
    protected TestingServer server;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int RETRY_WAIT_MS = 5000;
    private static final String INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES;
    private static final String INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND;
    private static final String INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY;

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        if (!this.enabledSessionExpiredStateAware()) {
            IInvokedMethodListener listener = new IInvokedMethodListener(){

                public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
                    int invocationCount = method.getTestMethod().getCurrentInvocationCount();
                    System.setProperty("curator-use-classic-connection-handling", Boolean.toString(invocationCount == 1));
                    BaseClassForTests.this.log.info("curator-use-classic-connection-handling: " + Boolean.toString(invocationCount == 1));
                }

                public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
                    System.clearProperty("curator-use-classic-connection-handling");
                }
            };
            context.getSuite().addListener((ITestNGListener)listener);
        }
        for (ITestNGMethod method : context.getAllTestMethods()) {
            method.setInvocationCount(this.enabledSessionExpiredStateAware() ? 1 : 2);
        }
    }

    @BeforeMethod
    public void setup() throws Exception {
        if (INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES != null) {
            System.setProperty(INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES, "true");
        }
        System.setProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND, "true");
        System.setProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY, "true");
        while (this.server == null) {
            try {
                this.server = new TestingServer();
            }
            catch (BindException e) {
                System.err.println("Getting bind exception - retrying to allocate server");
                this.server = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void teardown() throws Exception {
        System.clearProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY);
        System.clearProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND);
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.server = null;
            }
        }
    }

    protected boolean enabledSessionExpiredStateAware() {
        return false;
    }

    static {
        String logConnectionIssues = null;
        try {
            Class<?> debugUtilsClazz = Class.forName("org.apache.curator.utils.DebugUtils");
            logConnectionIssues = (String)debugUtilsClazz.getField("PROPERTY_DONT_LOG_CONNECTION_ISSUES").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES = logConnectionIssues;
        String s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND = s;
        s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY = s;
    }
}

