/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import org.apache.curator.test.Timing;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingZooKeeperMain
implements ZooKeeperMainFace {
    private static final Logger log = LoggerFactory.getLogger(TestingZooKeeperMain.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Exception> startingException = new AtomicReference<Object>(null);
    private volatile ServerCnxnFactory cnxnFactory;
    private volatile TestZooKeeperServer zkServer;
    private volatile ContainerManager containerManager;
    private static final Timing timing = new Timing();
    static final int MAX_WAIT_MS;

    @Override
    public void kill() {
        try {
            if (this.cnxnFactory != null) {
                this.cnxnFactory.closeAll();
                Field ssField = this.cnxnFactory.getClass().getDeclaredField("ss");
                ssField.setAccessible(true);
                ServerSocketChannel ss = (ServerSocketChannel)ssField.get(this.cnxnFactory);
                ss.close();
            }
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runFromConfig(QuorumPeerConfig config) throws Exception {
        try {
            Field instance = MBeanRegistry.class.getDeclaredField("instance");
            instance.setAccessible(true);
            MBeanRegistry nopMBeanRegistry = new MBeanRegistry(){

                public void register(ZKMBeanInfo bean, ZKMBeanInfo parent) throws JMException {
                }

                public void unregister(ZKMBeanInfo bean) {
                }
            };
            instance.set(null, nopMBeanRegistry);
        }
        catch (Exception e) {
            log.error("Could not fix MBeanRegistry");
        }
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(config);
        try {
            this.internalRunFromConfig(serverConfig);
        }
        catch (IOException e) {
            this.startingException.set(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockUntilStarted() throws Exception {
        if (!timing.awaitLatch(this.latch)) {
            throw new IllegalStateException("Timed out waiting for watch removal");
        }
        if (this.zkServer != null) {
            TestZooKeeperServer testZooKeeperServer = this.zkServer;
            synchronized (testZooKeeperServer) {
                while (!this.zkServer.isRunning()) {
                    ((Object)((Object)this.zkServer)).wait();
                }
            }
        } else {
            throw new Exception("No zkServer.");
        }
        Exception exception = this.startingException.get();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.cnxnFactory.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.cnxnFactory = null;
        }
        if (this.containerManager != null) {
            this.containerManager.stop();
            this.containerManager = null;
        }
        try {
            if (this.zkServer != null) {
                this.zkServer.shutdown();
                ZKDatabase zkDb = this.zkServer.getZKDatabase();
                if (zkDb != null) {
                    zkDb.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.zkServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunFromConfig(ServerConfig config) throws IOException {
        log.info("Starting server");
        try (FileTxnSnapLog txnLog = null;){
            txnLog = new FileTxnSnapLog(config.getDataLogDir(), config.getDataDir());
            this.zkServer = new TestZooKeeperServer(txnLog, config);
            try {
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            }
            catch (IOException e) {
                log.info("Could not start server. Waiting and trying one more time.", (Throwable)e);
                timing.sleepABit();
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            }
            this.cnxnFactory.startup((ZooKeeperServer)this.zkServer);
            this.containerManager = new ContainerManager(this.zkServer.getZKDatabase(), this.zkServer.getFirstProcessor(), Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)).intValue(), Integer.getInteger("znode.container.maxPerMinute", 10000).intValue());
            this.containerManager.start();
            this.latch.countDown();
            this.cnxnFactory.join();
            if (this.zkServer != null && this.zkServer.isRunning()) {
                this.zkServer.shutdown();
            }
        }
    }

    static {
        long startMs = System.currentTimeMillis();
        try {
            InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        long elapsed = System.currentTimeMillis() - startMs;
        MAX_WAIT_MS = Math.max((int)elapsed * 2, 1000);
    }

    public static class TestZooKeeperServer
    extends ZooKeeperServer {
        private final AtomicBoolean isRunning = new AtomicBoolean(false);

        public TestZooKeeperServer(FileTxnSnapLog txnLog, ServerConfig config) {
            super(txnLog, config.getTickTime(), config.getMinSessionTimeout(), config.getMaxSessionTimeout(), null);
        }

        public RequestProcessor getFirstProcessor() {
            return this.firstProcessor;
        }

        protected void setState(ZooKeeperServer.State state) {
            this.state = state;
        }

        protected void registerJMX() {
        }

        protected void unregisterJMX() {
        }

        public boolean isRunning() {
            return this.isRunning.get() || super.isRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteStartup() {
            TestZooKeeperServer testZooKeeperServer = this;
            synchronized (testZooKeeperServer) {
                this.isRunning.set(true);
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

