/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.net.BindException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.TestingCluster;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener2;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class BaseClassForTests {
    protected volatile TestingServer server;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean isRetrying = new AtomicBoolean(false);
    private static final String INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES;
    private static final String INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND;
    private static final String INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY;

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        IInvokedMethodListener2 methodListener2 = new IInvokedMethodListener2(){

            public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
                method.getTestMethod().setRetryAnalyzer(x$0 -> BaseClassForTests.this.retry(x$0));
            }

            public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
                this.beforeInvocation(method, testResult);
            }

            public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
            }

            public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
            }
        };
        context.getSuite().addListener((ITestNGListener)methodListener2);
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        if (INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES != null) {
            System.setProperty(INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES, "true");
        }
        System.setProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND, "true");
        System.setProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY, "true");
        try {
            this.createServer();
        }
        catch (FailedServerStartException ignore) {
            this.log.warn("Failed to start server - retrying 1 more time");
            this.closeServer();
            this.createServer();
        }
    }

    public TestingCluster createAndStartCluster(int qty) throws Exception {
        TestingCluster cluster = new TestingCluster(qty);
        try {
            cluster.start();
        }
        catch (FailedServerStartException e) {
            this.log.warn("Failed to start cluster - retrying 1 more time");
            try {
                cluster.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cluster = new TestingCluster(qty);
            cluster.start();
        }
        return cluster;
    }

    protected void createServer() throws Exception {
        while (this.server == null) {
            try {
                this.server = new TestingServer();
            }
            catch (BindException e) {
                this.server = null;
                throw new FailedServerStartException("Getting bind exception - retrying to allocate server");
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        System.clearProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY);
        System.clearProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND);
        this.closeServer();
    }

    private void closeServer() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.server = null;
            }
        }
    }

    private boolean retry(ITestResult result) {
        if (result.isSuccess() || this.isRetrying.get()) {
            this.isRetrying.set(false);
            return false;
        }
        result.setStatus(3);
        if (result.getThrowable() != null) {
            this.log.error("Retrying 1 time", result.getThrowable());
        } else {
            this.log.error("Retrying 1 time");
        }
        this.isRetrying.set(true);
        return true;
    }

    static {
        String logConnectionIssues = null;
        try {
            Class<?> debugUtilsClazz = Class.forName("org.apache.curator.utils.DebugUtils");
            logConnectionIssues = (String)debugUtilsClazz.getField("PROPERTY_DONT_LOG_CONNECTION_ISSUES").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES = logConnectionIssues;
        String s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND = s;
        s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY = s;
    }
}

