/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.curator-test.shaded.com.google.common.base.Throwables;
import org.apache.curator-test.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator-test.shaded.com.google.common.io.Files;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.QuorumPeerConfigBuilder;
import org.apache.curator.test.compatibility.Timing2;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class QuorumConfigBuilder
implements Closeable {
    private final ImmutableList<InstanceSpec> instanceSpecs;
    private final boolean fromRandom;
    private final File fakeConfigFile;

    public QuorumConfigBuilder(Collection<InstanceSpec> specs) {
        this(specs.toArray(new InstanceSpec[0]));
    }

    public QuorumConfigBuilder(InstanceSpec ... specs) {
        this.fromRandom = specs == null || specs.length == 0;
        this.instanceSpecs = this.fromRandom ? ImmutableList.of(InstanceSpec.newInstanceSpec()) : ImmutableList.copyOf(specs);
        File fakeConfigFile = null;
        try {
            fakeConfigFile = File.createTempFile("temp", "temp");
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        this.fakeConfigFile = fakeConfigFile;
    }

    public boolean isFromRandom() {
        return this.fromRandom;
    }

    public QuorumPeerConfig buildConfig() throws Exception {
        return this.buildConfig(0);
    }

    public InstanceSpec getInstanceSpec(int index) {
        return (InstanceSpec)this.instanceSpecs.get(index);
    }

    public List<InstanceSpec> getInstanceSpecs() {
        return this.instanceSpecs;
    }

    public int size() {
        return this.instanceSpecs.size();
    }

    @Override
    public void close() {
        if (this.fakeConfigFile != null) {
            this.fakeConfigFile.delete();
        }
    }

    public QuorumPeerConfig buildConfig(int instanceIndex) throws Exception {
        InstanceSpec spec = (InstanceSpec)this.instanceSpecs.get(instanceIndex);
        return this.buildConfig(instanceIndex, spec.getPort());
    }

    public QuorumPeerConfig buildConfig(int instanceIndex, int instancePort) throws Exception {
        Properties properties = this.buildConfigProperties(instanceIndex, instancePort);
        QuorumPeerConfig config = new QuorumPeerConfig(){
            {
                if (QuorumConfigBuilder.this.fakeConfigFile != null) {
                    this.configFileStr = QuorumConfigBuilder.this.fakeConfigFile.getPath();
                }
            }
        };
        config.parseProperties(properties);
        return config;
    }

    public Properties buildConfigProperties(int instanceIndex) throws Exception {
        InstanceSpec spec = (InstanceSpec)this.instanceSpecs.get(instanceIndex);
        return this.buildConfigProperties(instanceIndex, spec.getPort());
    }

    public Properties buildConfigProperties(int instanceIndex, int instancePort) throws Exception {
        Map<String, Object> customProperties;
        boolean isCluster = this.instanceSpecs.size() > 1;
        InstanceSpec spec = (InstanceSpec)this.instanceSpecs.get(instanceIndex);
        if (isCluster) {
            Files.write(Integer.toString(spec.getServerId()).getBytes(), new File(spec.getDataDirectory(), "myid"));
        }
        Properties properties = new Properties();
        String localSessionsEnabled = System.getProperty("readonlymode.enabled", "false");
        properties.setProperty("localSessionsEnabled", localSessionsEnabled);
        properties.setProperty("localSessionsUpgradingEnabled", localSessionsEnabled);
        properties.setProperty("initLimit", "10");
        properties.setProperty("syncLimit", "5");
        properties.setProperty("dataDir", spec.getDataDirectory().getCanonicalPath());
        properties.setProperty("clientPort", Integer.toString(instancePort));
        String tickTime = Integer.toString(spec.getTickTime() >= 0 ? spec.getTickTime() : new Timing2().tickTime());
        properties.setProperty("tickTime", tickTime);
        properties.setProperty("minSessionTimeout", tickTime);
        int maxClientCnxns = spec.getMaxClientCnxns();
        if (maxClientCnxns >= 0) {
            properties.setProperty("maxClientCnxns", Integer.toString(maxClientCnxns));
        }
        if (isCluster) {
            for (InstanceSpec thisSpec : this.instanceSpecs) {
                int clientPort = thisSpec == spec ? instancePort : thisSpec.getPort();
                properties.setProperty("server." + thisSpec.getServerId(), String.format("%s:%d:%d;%s:%d", thisSpec.getHostname(), thisSpec.getQuorumPort(), thisSpec.getElectionPort(), thisSpec.getHostname(), clientPort));
            }
        }
        if ((customProperties = spec.getCustomProperties()) != null) {
            properties.putAll(customProperties);
        }
        return properties;
    }

    public QuorumPeerConfigBuilder bindInstance(int instanceIndex, int instancePort) {
        return new QuorumPeerConfigBuilder(this, instanceIndex, instancePort);
    }
}

