/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.test.DirectoryUtils;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.TestingQuorumPeerMain;
import org.apache.curator.test.TestingZooKeeperMain;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.curator.test.ZooKeeperServerEmbeddedAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingZooKeeperServer
implements Closeable {
    private static final Logger log;
    static boolean hasZooKeeperServerEmbedded;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final QuorumConfigBuilder configBuilder;
    private final int thisInstanceIndex;
    private int thisInstancePort;
    private volatile ZooKeeperMainFace main;

    ZooKeeperMainFace getMain() {
        return this.main;
    }

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder) {
        this(configBuilder, 0);
    }

    public TestingZooKeeperServer(QuorumConfigBuilder configBuilder, int thisInstanceIndex) {
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        this.configBuilder = configBuilder;
        this.thisInstanceIndex = thisInstanceIndex;
        this.thisInstancePort = configBuilder.getInstanceSpec(thisInstanceIndex).getPort();
        this.main = this.createServerMain();
    }

    private ZooKeeperMainFace createServerMain() {
        if (hasZooKeeperServerEmbedded) {
            return new ZooKeeperServerEmbeddedAdapter();
        }
        if (this.isCluster()) {
            return new TestingQuorumPeerMain();
        }
        return new TestingZooKeeperMain();
    }

    private boolean isCluster() {
        return this.configBuilder.size() > 1;
    }

    public Collection<InstanceSpec> getInstanceSpecs() {
        return this.configBuilder.getInstanceSpecs();
    }

    public void kill() {
        this.main.kill();
        this.state.set(State.STOPPED);
    }

    public void restart() throws Exception {
        if (this.state.get() == State.CLOSED) {
            throw new IllegalStateException("Cannot restart a closed instance");
        }
        if (this.state.get() == State.STARTED) {
            this.stop();
        }
        this.state.set(State.LATENT);
        this.main = this.createServerMain();
        this.start();
    }

    public void stop() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            this.main.close();
        }
    }

    public InstanceSpec getInstanceSpec() {
        return this.configBuilder.getInstanceSpec(this.thisInstanceIndex);
    }

    @Override
    public void close() throws IOException {
        this.stop();
        if (this.state.compareAndSet(State.STOPPED, State.CLOSED)) {
            this.configBuilder.close();
            InstanceSpec spec = this.getInstanceSpec();
            if (spec.deleteDataDirectoryOnClose()) {
                DirectoryUtils.deleteRecursively(spec.getDataDirectory());
            }
        }
    }

    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            return;
        }
        this.main.start(this.configBuilder.bindInstance(this.thisInstanceIndex, this.thisInstancePort));
        this.thisInstancePort = this.main.getClientPort();
    }

    public int getLocalPort() {
        if (this.thisInstancePort == 0) {
            throw new IllegalStateException("server is configured to bind to port 0 but not started");
        }
        return this.thisInstancePort;
    }

    static {
        boolean localHasZooKeeperServerEmbedded;
        log = LoggerFactory.getLogger(TestingZooKeeperServer.class);
        try {
            Class.forName("org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded");
            localHasZooKeeperServerEmbedded = true;
        }
        catch (Throwable t) {
            localHasZooKeeperServerEmbedded = false;
            log.info("ZooKeeperServerEmbedded is not available in the version of the ZooKeeper library being used");
        }
        hasZooKeeperServerEmbedded = localHasZooKeeperServerEmbedded;
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED,
        CLOSED;

    }
}

