/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.json.utils.JSONUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.SimpleConverter;
import org.codehaus.jettison.mapped.TypeConverter;
import org.codehaus.jettison.util.StringIndenter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider<T>
extends AbstractJAXBProvider<T> {
    private static final String MAPPED_CONVENTION = "mapped";
    private static final String BADGER_FISH_CONVENTION = "badgerfish";
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private List<String> primitiveArrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private Map<String, String> wrapperMap;
    private boolean dropRootElement;
    private boolean dropElementsInXmlStream = true;
    private boolean dropCollectionWrapperElement;
    private boolean ignoreMixedContent;
    private boolean ignoreEmptyArrayValues;
    private boolean writeXsiType = true;
    private boolean readXsiType = true;
    private boolean ignoreNamespaces;
    private String convention = "mapped";
    private TypeConverter typeConverter;
    private boolean attributesToElements;
    private boolean writeNullAsString = true;

    @Override
    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setConvention(String value) {
        if (!MAPPED_CONVENTION.equals(value) && !BADGER_FISH_CONVENTION.equals(value)) {
            throw new IllegalArgumentException("Unsupported convention \"" + value);
        }
        this.convention = value;
    }

    public void setConvertTypesToStrings(boolean convert) {
        if (convert) {
            this.setTypeConverter((TypeConverter)new SimpleConverter());
        }
    }

    public void setTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
    }

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setDropRootElement(boolean drop) {
        this.dropRootElement = drop;
    }

    public void setDropCollectionWrapperElement(boolean drop) {
        this.dropCollectionWrapperElement = drop;
    }

    public void setIgnoreMixedContent(boolean ignore) {
        this.ignoreMixedContent = ignore;
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap.putAll(namespaceMap);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isReadable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    /*
     * Exception decompiling
     */
    public T readFrom(Class<T> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is, boolean isCollection) throws Exception {
        XMLStreamReader reader = this.createReader(type, is);
        return isCollection ? new AbstractJAXBProvider.JAXBCollectionWrapperReader(reader) : reader;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is) throws Exception {
        XMLStreamReader reader = null;
        reader = BADGER_FISH_CONVENTION.equals(this.convention) ? JSONUtils.createBadgerFishReader(is) : JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap, this.primitiveArrayKeys, this.getDepthProperties());
        reader = this.createTransformReaderIfNeeded(reader, is);
        return reader;
    }

    protected InputStream getInputStream(Class<T> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            String after = "}";
            ByteArrayInputStream isAfter = new ByteArrayInputStream(after.getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<T> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw new WebApplicationException(500);
        }
        return "{\"" + name + "\":";
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isWriteable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    /*
     * Exception decompiling
     */
    public void writeTo(T obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void copyReaderToWriter(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument();
        StaxUtils.copy(reader, writer);
        writer.writeEndDocument();
    }

    protected void marshalCollection(Class<?> originalCls, Object collection, Type genericType, String encoding, OutputStream os, MediaType m, Annotation[] anns) throws Exception {
        Class actualClass = InjectionUtils.getActualType(genericType);
        actualClass = this.getActualType(actualClass, genericType, anns);
        List<Object> c = originalCls.isArray() ? Arrays.asList((Object[])collection) : (List<Object>)collection;
        Iterator it = c.iterator();
        Object firstObj = it.hasNext() ? (Object)it.next() : null;
        String startTag = null;
        String endTag = null;
        if (!this.dropCollectionWrapperElement) {
            QName qname = null;
            if (firstObj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)firstObj;
                qname = el.getName();
                actualClass = el.getDeclaredType();
            } else {
                qname = this.getCollectionWrapperQName(actualClass, genericType, firstObj, false);
            }
            String prefix = "";
            if (!this.ignoreNamespaces) {
                prefix = this.namespaceMap.get(qname.getNamespaceURI());
                if (prefix != null) {
                    if (prefix.length() > 0) {
                        prefix = prefix + ".";
                    }
                } else if (qname.getNamespaceURI().length() > 0) {
                    prefix = "ns1.";
                }
            }
            prefix = prefix == null ? "" : prefix;
            startTag = "{\"" + prefix + qname.getLocalPart() + "\":[";
            endTag = "]}";
        } else if (this.serializeAsArray) {
            startTag = "[";
            endTag = "]";
        } else {
            startTag = "{";
            endTag = "}";
        }
        os.write(startTag.getBytes());
        if (firstObj != null) {
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(firstObj.getClass(), anns);
            this.marshalCollectionMember(JAXBUtils.useAdapter(firstObj, adapter, true), actualClass, genericType, encoding, os);
            while (it.hasNext()) {
                os.write(",".getBytes());
                this.marshalCollectionMember(JAXBUtils.useAdapter(it.next(), adapter, true), actualClass, genericType, encoding, os);
            }
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os) throws Exception {
        if ((obj = obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        this.marshal(ms, obj, cls, genericType, enc, os, true);
    }

    protected void marshal(Marshaller ms, Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        OutputStream actualOs = os;
        MessageContext mc = this.getContext();
        if (mc != null && MessageUtils.isTrue(mc.get("jaxb.formatted.output"))) {
            actualOs = new CachedOutputStream();
        }
        XMLStreamWriter writer = this.createWriter(actualObject, actualClass, genericType, enc, actualOs, isCollection);
        ms.marshal(actualObject, writer);
        writer.close();
        if (os != actualOs) {
            StringIndenter formatter = new StringIndenter(IOUtils.newStringFromBytes(((CachedOutputStream)actualOs).getBytes()));
            OutputStreamWriter outWriter = new OutputStreamWriter(os, enc);
            IOUtils.copy(new StringReader(formatter.result()), outWriter, 2048);
            ((Writer)outWriter).close();
        }
    }

    protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        boolean dropRootInJsonStream;
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishWriter(os);
        }
        boolean dropRootNeeded = this.isDropRootNeeded();
        QName qname = this.getQName(actualClass, genericType, actualObject);
        if (qname != null && this.ignoreNamespaces && (isCollection || dropRootNeeded)) {
            qname = new QName(qname.getLocalPart());
        }
        Configuration config = JSONUtils.createConfiguration(this.namespaceMap, this.writeXsiType && !this.ignoreNamespaces, this.attributesToElements, this.typeConverter);
        if (!this.dropElementsInXmlStream && this.outDropElements != null) {
            config.setIgnoredElements(this.outDropElements);
        }
        if (!this.writeNullAsString) {
            config.setWriteNullAsString(this.writeNullAsString);
        }
        if (this.ignoreEmptyArrayValues) {
            config.setIgnoreEmptyArrayValues(this.ignoreEmptyArrayValues);
        }
        boolean bl = dropRootInJsonStream = this.dropRootElement && !this.dropElementsInXmlStream;
        if (dropRootInJsonStream) {
            config.setDropRootElement(true);
        }
        if (this.ignoreNamespaces && this.serializeAsArray && (this.arrayKeys == null || dropRootInJsonStream)) {
            if (this.arrayKeys == null) {
                this.arrayKeys = new LinkedList<String>();
            } else if (dropRootInJsonStream) {
                this.arrayKeys = new LinkedList<String>(this.arrayKeys);
            }
            this.arrayKeys.add(qname.getLocalPart());
        }
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, qname, this.writeXsiType && !this.ignoreNamespaces, config, this.serializeAsArray, this.arrayKeys, isCollection || dropRootNeeded);
        writer = JSONUtils.createIgnoreMixedContentWriterIfNeeded(writer, this.ignoreMixedContent);
        writer = JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces);
        return this.createTransformWriterIfNeeded(writer, os, this.dropElementsInXmlStream);
    }

    protected boolean isDropRootNeeded() {
        return this.dropRootElement && this.dropElementsInXmlStream;
    }

    protected void marshal(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os) throws Exception {
        if ((actualObject = this.convertToJaxbElementIfNeeded(actualObject, actualClass, genericType)) instanceof JAXBElement && actualClass != JAXBElement.class) {
            actualClass = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, enc);
        if (!this.namespaceMap.isEmpty()) {
            this.setNamespaceMapper(ms, this.namespaceMap);
        }
        this.marshal(ms, actualObject, actualClass, genericType, enc, os, false);
    }

    private QName getQName(Class<?> cls, Type type, Object object) throws Exception {
        QName qname = this.getJaxbQName(cls, type, object, false);
        if (qname != null) {
            String prefix = this.getPrefix(qname.getNamespaceURI());
            return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        }
        return null;
    }

    private String getPrefix(String namespace) {
        String prefix = this.namespaceMap.get(namespace);
        return prefix == null ? "" : prefix;
    }

    public void setWriteXsiType(boolean writeXsiType) {
        this.writeXsiType = writeXsiType;
    }

    public void setReadXsiType(boolean readXsiType) {
        this.readXsiType = readXsiType;
    }

    public void setPrimitiveArrayKeys(List<String> primitiveArrayKeys) {
        this.primitiveArrayKeys = primitiveArrayKeys;
    }

    public void setDropElementsInXmlStream(boolean drop) {
        this.dropElementsInXmlStream = drop;
    }

    public void setWriteNullAsString(boolean writeNullAsString) {
        this.writeNullAsString = writeNullAsString;
    }

    public void setIgnoreEmptyArrayValues(boolean ignoreEmptyArrayElements) {
        this.ignoreEmptyArrayValues = ignoreEmptyArrayElements;
    }

    static {
        new SimpleConverter();
    }
}

