/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceGenerator {
    public static final String CODE_TYPE_GRAMMAR = "grammar";
    public static final String CODE_TYPE_PROXY = "proxy";
    public static final String CODE_TYPE_WEB = "web";
    public static final String LINE_SEP_PROPERTY = "line.separator";
    public static final String FILE_SEP_PROPERTY = "file.separator";
    private static final Logger LOG = LogUtils.getL7dLogger(SourceGenerator.class);
    private static final String DEFAULT_PACKAGE_NAME = "application";
    private static final String DEFAULT_RESOURCE_NAME = "Resource";
    private static final String TAB = "    ";
    private static final Map<String, Class<?>> HTTP_METHOD_ANNOTATIONS = new HashMap();
    private static final Map<String, Class<?>> PARAM_ANNOTATIONS;
    private Comparator<String> importsComparator;
    private boolean generateInterfaces = true;
    private boolean generateImpl;
    private String resourcePackageName;
    private String resourceName;
    private String wadlPath;
    private Map<String, String> properties;
    private List<String> generatedServiceClasses = new ArrayList<String>();
    private List<String> generatedTypeClasses = new ArrayList<String>();
    private List<InputSource> bindingFiles = Collections.emptyList();
    private List<InputSource> schemaPackageFiles = Collections.emptyList();
    private Map<String, String> schemaPackageMap = Collections.emptyMap();
    private Bus bus;

    public SourceGenerator() {
        this(Collections.emptyMap());
    }

    public SourceGenerator(Map<String, String> properties) {
        this.properties = properties;
    }

    private String getClassPackageName(String wadlPackageName) {
        if (this.resourcePackageName != null) {
            return this.resourcePackageName;
        }
        if (wadlPackageName != null && wadlPackageName.length() > 0) {
            return wadlPackageName;
        }
        return DEFAULT_PACKAGE_NAME;
    }

    private String getLineSep() {
        String value = this.properties.get(LINE_SEP_PROPERTY);
        return value == null ? System.getProperty(LINE_SEP_PROPERTY) : value;
    }

    private String getFileSep() {
        String value = this.properties.get(FILE_SEP_PROPERTY);
        return value == null ? System.getProperty(FILE_SEP_PROPERTY) : value;
    }

    public void generateSource(String wadl, File srcDir, String codeType) {
        Application app = this.readWadl(wadl, this.wadlPath);
        HashSet<String> typeClassNames = new HashSet<String>();
        GrammarInfo gInfo = this.generateSchemaCodeAndInfo(app, typeClassNames, srcDir);
        if (!CODE_TYPE_GRAMMAR.equals(codeType)) {
            this.generateResourceClasses(app, gInfo, typeClassNames, srcDir);
        }
    }

    private GrammarInfo generateSchemaCodeAndInfo(Application app, Set<String> typeClassNames, File srcDir) {
        JAXBUtils.JCodeModel codeModel;
        List<SchemaInfo> schemaElements = this.getSchemaElements(app);
        if (schemaElements != null && !schemaElements.isEmpty() && (codeModel = this.createCodeModel(schemaElements, typeClassNames)) != null) {
            this.generateClassesFromSchema(codeModel, srcDir);
        }
        return this.getGrammarInfo(app.getAppElement(), schemaElements);
    }

    private void generateResourceClasses(Application app, GrammarInfo gInfo, Set<String> typeClassNames, File src) {
        Element appElement = app.getAppElement();
        List<Element> resourcesEls = DOMUtils.getChildrenWithName(appElement, "http://wadl.dev.java.net/2009/02", "resources");
        if (resourcesEls.size() != 1) {
            throw new IllegalStateException("WADL resources element is missing");
        }
        List<Element> resourceEls = DOMUtils.getChildrenWithName(resourcesEls.get(0), "http://wadl.dev.java.net/2009/02", "resource");
        if (resourceEls.size() == 0) {
            throw new IllegalStateException("WADL has no resource elements");
        }
        for (int i = 0; i < resourceEls.size(); ++i) {
            Element resource = this.getResourceElement(app, resourceEls.get(i), gInfo, typeClassNames, resourceEls.get(i).getAttribute("type"), src);
            this.writeResourceClass(app, resource, typeClassNames, gInfo, src, true, this.generateInterfaces);
            if (this.generateInterfaces && this.generateImpl) {
                this.writeResourceClass(app, resource, typeClassNames, gInfo, src, true, false);
            }
            if (this.resourceName != null) break;
        }
        this.generateMainClass(resourcesEls.get(0), src);
    }

    private Element getResourceElement(Application app, Element resElement, GrammarInfo gInfo, Set<String> typeClassNames, String type, File srcDir) {
        if (type.length() > 0) {
            if (type.startsWith("#")) {
                String refId = type.substring(1);
                List<Element> resourceTypes = DOMUtils.getChildrenWithName(app.getAppElement(), "http://wadl.dev.java.net/2009/02", "resource_type");
                for (Element resourceType : resourceTypes) {
                    if (!refId.equals(resourceType.getAttribute("id"))) continue;
                    Element realElement = (Element)resourceType.cloneNode(true);
                    DOMUtils.setAttribute(realElement, "id", resElement.getAttribute("id"));
                    DOMUtils.setAttribute(realElement, "path", resElement.getAttribute("path"));
                    return realElement;
                }
            } else {
                URI wadlRef = URI.create(type);
                String wadlRefPath = app.getWadlPath() != null ? SourceGenerator.getBaseWadlPath(app.getWadlPath()) + wadlRef.getPath() : wadlRef.getPath();
                Application refApp = new Application(this.readIncludedDocument(wadlRefPath), wadlRefPath);
                GrammarInfo gInfoBase = this.generateSchemaCodeAndInfo(refApp, typeClassNames, srcDir);
                if (gInfoBase != null) {
                    gInfo.getElementTypeMap().putAll(gInfoBase.getElementTypeMap());
                    gInfo.getNsMap().putAll(gInfo.getNsMap());
                }
                return this.getResourceElement(refApp, resElement, gInfo, typeClassNames, "#" + wadlRef.getFragment(), srcDir);
            }
        }
        return resElement;
    }

    private GrammarInfo getGrammarInfo(Element appElement, List<SchemaInfo> schemaElements) {
        if (schemaElements == null || schemaElements.isEmpty()) {
            return new GrammarInfo();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        NamedNodeMap attrMap = appElement.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node node = attrMap.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.startsWith("xmlns:")) continue;
            String nsValue = node.getNodeValue();
            nsMap.put(nodeName.substring(6), nsValue);
        }
        HashMap<String, String> elementTypeMap = new HashMap<String, String>();
        for (SchemaInfo schemaEl : schemaElements) {
            List<Element> elementEls = DOMUtils.getChildrenWithName(schemaEl.getElement(), "http://www.w3.org/2001/XMLSchema", "element");
            for (Element el : elementEls) {
                String type = el.getAttribute("type");
                if (type.length() <= 0) continue;
                String[] pair = type.split(":");
                elementTypeMap.put(el.getAttribute("name"), pair.length == 1 ? pair[0] : pair[1]);
            }
        }
        return new GrammarInfo(nsMap, elementTypeMap);
    }

    public void generateMainClass(Element resourcesEl, File src) {
    }

    private void writeResourceClass(Application app, Element rElement, Set<String> typeClassNames, GrammarInfo gInfo, File src, boolean isRoot, boolean interfaceIsGenerated) {
        boolean expandedQName;
        QName qname;
        String namespaceURI;
        String resourceId;
        String string = resourceId = this.resourceName != null ? this.resourceName : rElement.getAttribute("id");
        if (resourceId.length() == 0) {
            resourceId = DEFAULT_RESOURCE_NAME;
        }
        if (this.getSchemaClassName(namespaceURI = this.possiblyConvertNamespaceURI((qname = this.convertToQName(resourceId, expandedQName = resourceId.startsWith("{"))).getNamespaceURI(), expandedQName), gInfo, qname.getLocalPart(), typeClassNames) != null) {
            return;
        }
        StringBuilder sbImports = new StringBuilder();
        StringBuilder sbCode = new StringBuilder();
        Set<String> imports = this.createImports();
        String classPackage = this.getClassPackageName(namespaceURI);
        String className = this.getClassName(qname.getLocalPart(), interfaceIsGenerated);
        sbImports.append(this.getClassComment()).append(this.getLineSep());
        sbImports.append("package " + classPackage).append(";").append(this.getLineSep()).append(this.getLineSep());
        if (isRoot && this.writeAnnotations(interfaceIsGenerated)) {
            String path = rElement.getAttribute("path");
            this.writeAnnotation(sbCode, imports, Path.class, path, true, false);
        }
        sbCode.append("public " + this.getClassType(interfaceIsGenerated) + " " + className);
        this.writeImplementsInterface(sbCode, qname.getLocalPart(), interfaceIsGenerated);
        sbCode.append(" {" + this.getLineSep() + this.getLineSep());
        this.writeMethods(rElement, imports, sbCode, typeClassNames, gInfo, isRoot, interfaceIsGenerated);
        List<Element> childEls = DOMUtils.getChildrenWithName(rElement, "http://wadl.dev.java.net/2009/02", "resource");
        for (Element childEl : childEls) {
            if (childEl.getAttribute("id").length() == 0) {
                this.writeMethods(childEl, imports, sbCode, typeClassNames, gInfo, false, interfaceIsGenerated);
                continue;
            }
            this.writeResourceMethod(childEl, imports, sbCode, typeClassNames, gInfo, false, interfaceIsGenerated);
        }
        sbCode.append("}");
        this.writeImports(sbImports, imports, classPackage);
        this.createJavaSourceFile(src, new QName(classPackage, className), sbCode, sbImports);
        for (Element subEl : childEls) {
            String id = subEl.getAttribute("id");
            if (id.length() <= 0 || resourceId.equals(id) || id.startsWith("{java") || id.startsWith("java")) continue;
            this.writeResourceClass(app, this.getResourceElement(app, subEl, gInfo, typeClassNames, subEl.getAttribute("type"), src), typeClassNames, gInfo, src, false, interfaceIsGenerated);
        }
    }

    private QName convertToQName(String resourceId, boolean expandedQName) {
        int lastIndex;
        QName qname = null;
        qname = expandedQName ? JAXRSUtils.convertStringToQName(resourceId) : ((lastIndex = resourceId.lastIndexOf(".")) == -1 ? new QName(resourceId) : new QName(resourceId.substring(0, lastIndex), resourceId.substring(lastIndex + 1)));
        return qname;
    }

    private String getClassType(boolean interfaceIsGenerated) {
        return interfaceIsGenerated ? "interface" : "class";
    }

    private String getClassName(String clsName, boolean interfaceIsGenerated) {
        if (interfaceIsGenerated) {
            return clsName;
        }
        return this.generateInterfaces ? clsName + "Impl" : clsName;
    }

    private boolean writeAnnotations(boolean interfaceIsGenerated) {
        if (interfaceIsGenerated) {
            return true;
        }
        return !this.generateInterfaces && this.generateImpl;
    }

    private void writeImplementsInterface(StringBuilder sb, String clsName, boolean interfaceIsGenerated) {
        if (this.generateInterfaces && !interfaceIsGenerated) {
            sb.append(" implements " + clsName);
        }
    }

    private String getClassComment() {
        return "/**" + this.getLineSep() + " * Created by Apache CXF WadlToJava code generator" + this.getLineSep() + "**/";
    }

    private void writeMethods(Element rElement, Set<String> imports, StringBuilder sbCode, Set<String> typeClassNames, GrammarInfo gInfo, boolean isRoot, boolean interfaceIsGenerated) {
        List<Element> methodEls = DOMUtils.getChildrenWithName(rElement, "http://wadl.dev.java.net/2009/02", "method");
        for (Element methodEl : methodEls) {
            this.writeResourceMethod(methodEl, imports, sbCode, typeClassNames, gInfo, isRoot, interfaceIsGenerated);
        }
    }

    private void writeAnnotation(StringBuilder sbCode, Set<String> imports, Class<?> cls, String value, boolean nextLine, boolean addTab) {
        if (value != null && value.length() == 0) {
            return;
        }
        this.addImport(imports, cls.getName());
        sbCode.append("@").append(cls.getSimpleName());
        if (value != null) {
            sbCode.append("(\"" + value + "\")");
        }
        if (nextLine) {
            sbCode.append(this.getLineSep());
            if (addTab) {
                sbCode.append(TAB);
            }
        }
    }

    private void addImport(Set<String> imports, String clsName) {
        if (imports == null || clsName.startsWith("java.lang")) {
            return;
        }
        if (!imports.contains(clsName)) {
            imports.add(clsName);
        }
    }

    private void writeImports(StringBuilder sbImports, Set<String> imports, String classPackage) {
        for (String clsName : imports) {
            int index = clsName.lastIndexOf(".");
            if (index != -1 && clsName.substring(0, index).equals(classPackage)) continue;
            sbImports.append("import " + clsName).append(";").append(this.getLineSep());
        }
    }

    private void writeResourceMethod(Element methodEl, Set<String> imports, StringBuilder sbCode, Set<String> typeClassNames, GrammarInfo gInfo, boolean isRoot, boolean interfaceIsGenerated) {
        Element resourceEl = "resource".equals(methodEl.getLocalName()) ? methodEl : (Element)methodEl.getParentNode();
        String methodName = methodEl.getAttribute("name");
        String methodNameLowerCase = methodName.toLowerCase();
        String id = methodEl.getAttribute("id");
        if (id.length() == 0) {
            id = methodNameLowerCase;
        }
        List<Element> responseEls = DOMUtils.getChildrenWithName(methodEl, "http://wadl.dev.java.net/2009/02", "response");
        List<Element> requestEls = DOMUtils.getChildrenWithName(methodEl, "http://wadl.dev.java.net/2009/02", "request");
        if (this.writeAnnotations(interfaceIsGenerated)) {
            sbCode.append(TAB);
            if (methodNameLowerCase.length() > 0) {
                if (HTTP_METHOD_ANNOTATIONS.containsKey(methodNameLowerCase)) {
                    this.writeAnnotation(sbCode, imports, HTTP_METHOD_ANNOTATIONS.get(methodNameLowerCase), null, true, true);
                }
                this.writeFormatAnnotations(requestEls, sbCode, imports, true);
                this.writeFormatAnnotations(responseEls, sbCode, imports, false);
            }
            if (!isRoot) {
                String path = resourceEl.getAttribute("path");
                this.writeAnnotation(sbCode, imports, Path.class, path, true, true);
            }
        } else {
            sbCode.append(this.getLineSep()).append(TAB);
        }
        if (!interfaceIsGenerated) {
            sbCode.append("public ");
        }
        boolean responseTypeAvailable = true;
        if (methodNameLowerCase.length() > 0) {
            responseTypeAvailable = this.writeResponseType(responseEls, sbCode, imports, typeClassNames, gInfo);
            sbCode.append(id);
        } else {
            boolean expandedQName = id.startsWith("{");
            QName qname = this.convertToQName(id, expandedQName);
            String packageName = this.possiblyConvertNamespaceURI(qname.getNamespaceURI(), expandedQName);
            String clsSimpleName = this.getSchemaClassName(packageName, gInfo, qname.getLocalPart(), typeClassNames);
            String localName = clsSimpleName == null ? qname.getLocalPart() : clsSimpleName.substring(packageName.length() + 1);
            String subResponseNs = clsSimpleName == null ? this.getClassPackageName(packageName) : clsSimpleName.substring(0, packageName.length());
            String parentId = ((Element)resourceEl.getParentNode()).getAttribute("id");
            this.writeSubResponseType(id.equals(parentId), subResponseNs, localName, sbCode, imports);
            sbCode.append("get" + localName);
        }
        sbCode.append("(");
        LinkedList<Element> inParamElements = new LinkedList<Element>();
        inParamElements.addAll(DOMUtils.getChildrenWithName(resourceEl, "http://wadl.dev.java.net/2009/02", "param"));
        this.writeRequestTypes(requestEls, inParamElements, sbCode, imports, typeClassNames, gInfo, interfaceIsGenerated);
        sbCode.append(")");
        if (interfaceIsGenerated) {
            sbCode.append(";");
        } else {
            this.generateEmptyMethodBody(sbCode, responseTypeAvailable);
        }
        sbCode.append(this.getLineSep()).append(this.getLineSep());
    }

    private String possiblyConvertNamespaceURI(String nsURI, boolean expandedQName) {
        return expandedQName ? this.getPackageFromNamespace(nsURI) : nsURI;
    }

    private String getPackageFromNamespace(String nsURI) {
        return this.schemaPackageMap.containsKey(nsURI) ? this.schemaPackageMap.get(nsURI) : PackageUtils.getPackageNameByNameSpaceURI(nsURI);
    }

    private void generateEmptyMethodBody(StringBuilder sbCode, boolean responseTypeAvailable) {
        sbCode.append(" {");
        sbCode.append(this.getLineSep()).append(TAB).append(TAB);
        sbCode.append("//TODO: implement").append(this.getLineSep()).append(TAB);
        if (responseTypeAvailable) {
            sbCode.append(TAB).append("return null;").append(this.getLineSep()).append(TAB);
        }
        sbCode.append("}");
    }

    private boolean addFormParameters(List<Element> inParamElements, Element requestEl) {
        String mediaType;
        List<Element> repElements = DOMUtils.getChildrenWithName(requestEl, "http://wadl.dev.java.net/2009/02", "representation");
        if (repElements.size() == 1 && "application/x-www-form-urlencoded".equals(mediaType = repElements.get(0).getAttribute("mediaType"))) {
            inParamElements.addAll(DOMUtils.getChildrenWithName(repElements.get(0), "http://wadl.dev.java.net/2009/02", "param"));
            return true;
        }
        return false;
    }

    private boolean writeResponseType(List<Element> responseEls, StringBuilder sbCode, Set<String> imports, Set<String> typeClassNames, GrammarInfo gInfo) {
        List<Element> repElements;
        List<Element> list = repElements = responseEls.size() == 1 ? DOMUtils.getChildrenWithName(responseEls.get(0), "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
        if (repElements.size() == 0) {
            sbCode.append("void ");
            return false;
        }
        String elementName = this.getElementRefName(repElements, typeClassNames, gInfo, imports);
        if (elementName != null) {
            sbCode.append(elementName + " ");
        } else {
            this.addImport(imports, Response.class.getName());
            sbCode.append("Response ");
        }
        return true;
    }

    private void writeSubResponseType(boolean recursive, String ns, String localName, StringBuilder sbCode, Set<String> imports) {
        if (!recursive && ns.length() > 0) {
            this.addImport(imports, ns + "." + localName);
        }
        sbCode.append(localName).append(" ");
    }

    private void writeRequestTypes(List<Element> requestEls, List<Element> inParamEls, StringBuilder sbCode, Set<String> imports, Set<String> typeClassNames, GrammarInfo gInfo, boolean interfaceIsGenerated) {
        boolean form = false;
        boolean formParamsAvailbale = false;
        if (requestEls.size() == 1 && inParamEls.size() == 0) {
            inParamEls.addAll(DOMUtils.getChildrenWithName(requestEls.get(0), "http://wadl.dev.java.net/2009/02", "param"));
            int currentSize = inParamEls.size();
            form = this.addFormParameters(inParamEls, requestEls.get(0));
            boolean bl = formParamsAvailbale = currentSize < inParamEls.size();
        }
        if (form && !formParamsAvailbale) {
            this.addImport(imports, MultivaluedMap.class.getName());
            sbCode.append("MultivaluedMap map");
        }
        for (int i = 0; i < inParamEls.size(); ++i) {
            Element paramEl = inParamEls.get(i);
            String name = paramEl.getAttribute("name");
            if (this.writeAnnotations(interfaceIsGenerated)) {
                Class<FormParam> paramAnnotation = form ? FormParam.class : PARAM_ANNOTATIONS.get(paramEl.getAttribute("style"));
                this.writeAnnotation(sbCode, imports, paramAnnotation, name, false, false);
                sbCode.append(" ");
            }
            String type = this.getPrimitiveType(paramEl);
            if (Boolean.valueOf(paramEl.getAttribute("repeating")).booleanValue()) {
                this.addImport(imports, List.class.getName());
                type = "List<" + type + ">";
            }
            sbCode.append(type).append(" ").append(name.replace('.', '_'));
            if (i + 1 >= inParamEls.size()) continue;
            sbCode.append(", ");
            if (i + 1 < 4 || (i + 1) % 4 != 0) continue;
            sbCode.append(this.getLineSep()).append(TAB).append(TAB).append(TAB).append(TAB);
        }
        if (!form) {
            List<Element> repElements;
            String elementName = null;
            List<Element> list = repElements = requestEls.size() == 1 ? DOMUtils.getChildrenWithName(requestEls.get(0), "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
            if (repElements.size() > 0) {
                elementName = this.getElementRefName(repElements, typeClassNames, gInfo, imports);
            }
            if (elementName != null) {
                if (inParamEls.size() > 0) {
                    sbCode.append(", ");
                }
                sbCode.append(elementName).append(" ").append(elementName.toLowerCase());
            }
        }
    }

    private String getPrimitiveType(Element paramEl) {
        String type = paramEl.getAttribute("type");
        if (type == null) {
            return "String";
        }
        String[] pair = type.split(":");
        String value = pair.length == 2 ? pair[1] : type;
        return "string".equals(value) ? "String" : value;
    }

    private String getElementRefName(List<Element> repElements, Set<String> typeClassNames, GrammarInfo gInfo, Set<String> imports) {
        String[] pair;
        String elementRef = null;
        for (Element el : repElements) {
            String value = el.getAttribute("element");
            if (value.length() <= 0) continue;
            elementRef = value;
            break;
        }
        if (elementRef != null && (pair = elementRef.split(":")).length == 2) {
            String namespace;
            String string = namespace = gInfo != null ? gInfo.getNsMap().get(pair[0]) : null;
            if (namespace == null) {
                return null;
            }
            String packageName = this.getPackageFromNamespace(namespace);
            String clsName = this.getSchemaClassName(packageName, gInfo, pair[1], typeClassNames);
            if (clsName != null) {
                this.addImport(imports, clsName);
                return clsName.substring(packageName.length() + 1);
            }
        }
        return null;
    }

    private String getSchemaClassName(String packageName, GrammarInfo gInfo, String localName, Set<String> typeClassNames) {
        String clsName = this.matchClassName(typeClassNames, packageName, localName);
        if (clsName == null && gInfo != null) {
            clsName = this.matchClassName(typeClassNames, packageName, gInfo.getElementTypeMap().get(localName));
        }
        return clsName;
    }

    private String matchClassName(Set<String> typeClassNames, String packageName, String localName) {
        if (localName == null) {
            return null;
        }
        String clsName = packageName + "." + localName;
        for (String type : typeClassNames) {
            if (!type.toLowerCase().equals(clsName)) continue;
            return type;
        }
        return null;
    }

    private void writeFormatAnnotations(List<Element> parentEls, StringBuilder sbCode, Set<String> imports, boolean inRep) {
        List<Element> repElements;
        List<Element> list = repElements = parentEls.size() == 1 ? DOMUtils.getChildrenWithName(parentEls.get(0), "http://wadl.dev.java.net/2009/02", "representation") : CastUtils.cast(Collections.emptyList(), Element.class);
        if (repElements.size() == 0) {
            return;
        }
        Class cls = inRep ? Consumes.class : Produces.class;
        this.addImport(imports, cls.getName());
        sbCode.append("@").append(cls.getSimpleName()).append("(");
        if (repElements.size() > 1) {
            sbCode.append("{");
        }
        for (int i = 0; i < repElements.size(); ++i) {
            String mediaType = repElements.get(i).getAttribute("mediaType");
            if (mediaType == null) continue;
            sbCode.append("\"" + mediaType + "\"");
            if (i + 1 >= repElements.size()) continue;
            sbCode.append(", ");
        }
        if (repElements.size() > 1) {
            sbCode.append(" }");
        }
        sbCode.append(")");
        sbCode.append(this.getLineSep()).append(TAB);
    }

    private void createJavaSourceFile(File src, QName qname, StringBuilder sbCode, StringBuilder sbImports) {
        String content = sbImports.toString() + this.getLineSep() + sbCode.toString();
        String namespace = qname.getNamespaceURI();
        this.generatedServiceClasses.add(namespace + "." + qname.getLocalPart());
        namespace = namespace.replace(".", this.getFileSep());
        File currentDir = new File(src.getAbsolutePath(), namespace);
        currentDir.mkdirs();
        File file = new File(currentDir.getAbsolutePath(), qname.getLocalPart() + ".java");
        try {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (FileNotFoundException ex) {
            LOG.warning(file.getAbsolutePath() + " is not found");
        }
        catch (IOException ex) {
            LOG.warning("Problem writing into " + file.getAbsolutePath());
        }
    }

    private Application readWadl(String wadl, String docPath) {
        return new Application(this.readXmlDocument(new StringReader(wadl)), docPath);
    }

    private Element readXmlDocument(Reader reader) {
        try {
            return StaxUtils.read(new InputSource(reader)).getDocumentElement();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to read wadl", ex);
        }
    }

    private void generateClassesFromSchema(JAXBUtils.JCodeModel codeModel, File src) {
        try {
            Object writer = JAXBUtils.createFileCodeWriter(src);
            codeModel.build(writer);
            this.generatedTypeClasses = JAXBUtils.getGeneratedClassNames(codeModel);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write generated Java files for schemas: " + e.getMessage(), e);
        }
    }

    private List<SchemaInfo> getSchemaElements(Application app) {
        List<Element> grammarEls = DOMUtils.getChildrenWithName(app.getAppElement(), "http://wadl.dev.java.net/2009/02", "grammars");
        if (grammarEls.size() != 1) {
            return null;
        }
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        List<Element> schemasEls = DOMUtils.getChildrenWithName(grammarEls.get(0), "http://www.w3.org/2001/XMLSchema", "schema");
        for (Element schemaEl : schemasEls) {
            schemas.add(this.createSchemaInfo(schemaEl, app.getWadlPath()));
        }
        List<Element> includeEls = DOMUtils.getChildrenWithName(grammarEls.get(0), "http://wadl.dev.java.net/2009/02", "include");
        for (Element includeEl : includeEls) {
            String href = includeEl.getAttribute("href");
            String schemaURI = this.resolveLocationWithCatalog(href);
            if (schemaURI == null) {
                schemaURI = app.getWadlPath() != null ? SourceGenerator.getBaseWadlPath(app.getWadlPath()) + href : href;
            }
            schemas.add(this.createSchemaInfo(this.readIncludedDocument(schemaURI), schemaURI));
        }
        return schemas;
    }

    private static String getBaseWadlPath(String docPath) {
        int lastSep = docPath.lastIndexOf("/");
        return lastSep != -1 ? docPath.substring(0, lastSep + 1) : docPath;
    }

    private SchemaInfo createSchemaInfo(Element schemaEl, String systemId) {
        SchemaInfo info = new SchemaInfo(schemaEl.getAttribute("targetNamespace"));
        info.setElement(schemaEl);
        info.setSystemId(systemId);
        return info;
    }

    private String resolveLocationWithCatalog(String href) {
        if (this.bus != null) {
            OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager(this.bus);
            try {
                return new OASISCatalogManagerHelper().resolve(catalogResolver, href, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Catalog resolution failed", e);
            }
        }
        return null;
    }

    private Element readIncludedDocument(String href) {
        try {
            InputStream is = null;
            if (!href.startsWith("http")) {
                is = ResourceUtils.getResourceStream(href, this.bus);
            }
            if (is == null) {
                is = URI.create(href).toURL().openStream();
            }
            return this.readXmlDocument(new InputStreamReader(is, "UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException("Resource " + href + " can not be read");
        }
    }

    private JAXBUtils.JCodeModel createCodeModel(List<SchemaInfo> schemaElements, Set<String> type) {
        JAXBUtils.SchemaCompiler compiler = this.createCompiler(type);
        this.addSchemas(schemaElements, compiler);
        for (InputSource is : this.bindingFiles) {
            compiler.getOptions().addBindFile(is);
        }
        Object elForRun = ReflectionInvokationHandler.createProxyWrapper(new InnerErrorListener(), JAXBUtils.getParamClass(compiler, "setErrorListener"));
        compiler.setErrorListener(elForRun);
        JAXBUtils.S2JJAXBModel intermediateModel = compiler.bind();
        JAXBUtils.JCodeModel codeModel = intermediateModel.generateCode(null, elForRun);
        JAXBUtils.logGeneratedClassNames(LOG, codeModel);
        return codeModel;
    }

    private JAXBUtils.SchemaCompiler createCompiler(Set<String> typeClassNames) {
        return JAXBUtils.createSchemaCompilerWithDefaultAllocator(typeClassNames);
    }

    private void addSchemas(List<SchemaInfo> schemas, JAXBUtils.SchemaCompiler compiler) {
        int i;
        for (i = 0; i < this.schemaPackageFiles.size(); ++i) {
            compiler.parseSchema(this.schemaPackageFiles.get(i));
        }
        for (i = 0; i < schemas.size(); ++i) {
            SchemaInfo schema = schemas.get(i);
            String key = schema.getSystemId();
            if (key != null) {
                if (key.startsWith("classpath:")) {
                    String resource = key.substring(10);
                    URL url = this.getClass().getResource(resource);
                    if (url != null) {
                        try {
                            key = url.toURI().toString();
                        }
                        catch (Exception ex) {}
                    }
                }
            } else {
                key = Integer.toString(i);
            }
            InputSource is = new InputSource((InputStream)null);
            is.setSystemId(key);
            is.setPublicId(key);
            compiler.getOptions().addGrammar(is);
            compiler.parseSchema(key, schema.getElement());
        }
    }

    public void setImportsComparator(Comparator<String> importsComparator) {
        this.importsComparator = importsComparator;
    }

    private Set<String> createImports() {
        return this.importsComparator == null ? new TreeSet<String>(new DefaultImportsComparator()) : new TreeSet<String>(this.importsComparator);
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    public void setGenerateImplementation(boolean generate) {
        this.generateImpl = generate;
    }

    public void setPackageName(String name) {
        this.resourcePackageName = name;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public void setWadlPath(String name) {
        this.wadlPath = name;
    }

    public void setBindingFiles(List<InputSource> files) {
        this.bindingFiles = files;
    }

    public void setSchemaPackageFiles(List<InputSource> files) {
        this.schemaPackageFiles = files;
    }

    public void setSchemaPackageMap(Map<String, String> map) {
        this.schemaPackageMap = map;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public List<String> getGeneratedServiceClasses() {
        return this.generatedServiceClasses;
    }

    public List<String> getGeneratedTypeClasses() {
        return this.generatedTypeClasses;
    }

    static {
        HTTP_METHOD_ANNOTATIONS.put("get", GET.class);
        HTTP_METHOD_ANNOTATIONS.put("put", PUT.class);
        HTTP_METHOD_ANNOTATIONS.put("post", POST.class);
        HTTP_METHOD_ANNOTATIONS.put("delete", DELETE.class);
        HTTP_METHOD_ANNOTATIONS.put("head", HEAD.class);
        HTTP_METHOD_ANNOTATIONS.put("options", OPTIONS.class);
        PARAM_ANNOTATIONS = new HashMap();
        PARAM_ANNOTATIONS.put("template", PathParam.class);
        PARAM_ANNOTATIONS.put("header", HeaderParam.class);
        PARAM_ANNOTATIONS.put("query", QueryParam.class);
        PARAM_ANNOTATIONS.put("matrix", MatrixParam.class);
    }

    private class Application {
        private Element appElement;
        private String wadlPath;

        public Application(Element appElement, String wadlPath) {
            this.appElement = appElement;
            this.wadlPath = wadlPath;
        }

        public Element getAppElement() {
            return this.appElement;
        }

        public String getWadlPath() {
            return this.wadlPath;
        }
    }

    static class InnerErrorListener {
        InnerErrorListener() {
        }

        public void error(SAXParseException ex) {
            throw new RuntimeException("Error compiling schema from WADL : " + ex.getMessage(), ex);
        }

        public void fatalError(SAXParseException ex) {
            throw new RuntimeException("Fatal error compiling schema from WADL : " + ex.getMessage(), ex);
        }

        public void info(SAXParseException ex) {
        }

        public void warning(SAXParseException ex) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultImportsComparator
    implements Comparator<String> {
        private static final String JAVAX_PREFIX = "javax";

        private DefaultImportsComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            boolean javax1 = s1.startsWith(JAVAX_PREFIX);
            boolean javax2 = s2.startsWith(JAVAX_PREFIX);
            if (javax1 && !javax2) {
                return -1;
            }
            if (!javax1 && javax2) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrammarInfo {
        private Map<String, String> nsMap = new HashMap<String, String>();
        private Map<String, String> elementTypeMap = new HashMap<String, String>();

        public GrammarInfo() {
        }

        public GrammarInfo(Map<String, String> nsMap, Map<String, String> elementTypeMap) {
            this.nsMap = nsMap;
            this.elementTypeMap = elementTypeMap;
        }

        public Map<String, String> getNsMap() {
            return this.nsMap;
        }

        public Map<String, String> getElementTypeMap() {
            return this.elementTypeMap;
        }
    }
}

