/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.DelegatingCallbackHandler;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.validate.NoOpValidator;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    public static final String PRINCIPAL_RESULT = "wss4j.principal.result";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    public static final String VALIDATOR_MAP = "wss4j.validator.map";
    public static final String SECURITY_PROCESSED = WSS4JInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class, null, WSS4JInInterceptor.class.getName() + "-Time");
    private boolean ignoreActions;
    private WSSecurityEngine secEngineOverride;

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public WSS4JInInterceptor(boolean ignore) {
        this();
        this.ignoreActions = ignore;
    }

    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
        Map<QName, Object> processorMap = CastUtils.cast((Map)properties.get(PROCESSOR_MAP));
        Map<QName, Object> validatorMap = CastUtils.cast((Map)properties.get(VALIDATOR_MAP));
        if (processorMap != null) {
            if (validatorMap != null) {
                processorMap.putAll(validatorMap);
            }
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(processorMap);
        } else if (validatorMap != null) {
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(validatorMap);
        }
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        ArrayList<PhaseInterceptor<? extends Message>> extras = new ArrayList<PhaseInterceptor<? extends Message>>(1);
        extras.add(SAAJInInterceptor.SAAJPreInInterceptor.INSTANCE);
        return extras;
    }

    public void setIgnoreActions(boolean i) {
        this.ignoreActions = i;
    }

    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        SAAJInInterceptor.INSTANCE.handleMessage(msg);
        return msg.getContent(SOAPMessage.class);
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && "_sendSignatureValues_".equals(key) && this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getOutMessage().get(key);
        }
        return result;
    }

    public final boolean isGET(SoapMessage message) {
        String method = (String)message.get("org.apache.cxf.request.method");
        return "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
    }

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        WSSecurityEngine engine;
        if (msg.containsKey(SECURITY_PROCESSED) || this.isGET(msg)) {
            return;
        }
        msg.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        boolean utWithCallbacks = MessageUtils.getContextualBoolean(msg, "ws-security.validate.token", true);
        this.translateProperties(msg);
        CXFRequestData reqData = new CXFRequestData();
        WSSConfig config = (WSSConfig)msg.getContextualProperty(WSSConfig.class.getName());
        if (config != null) {
            engine = new WSSecurityEngine();
            engine.setWssConfig(config);
        } else {
            engine = this.getSecurityEngine(utWithCallbacks);
            if (engine == null) {
                engine = new WSSecurityEngine();
            }
            config = engine.getWssConfig();
        }
        reqData.setWssConfig(config);
        SOAPMessage doc = this.getSOAPMessage(msg);
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeLog = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (doTimeLog) {
            t0 = System.currentTimeMillis();
        }
        try {
            reqData.setMsgContext(msg);
            this.computeAction(msg, reqData);
            ArrayList<Integer> actions = new ArrayList<Integer>();
            String action = this.getAction(msg, version);
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            reqData.setCallbackHandler(this.getCallback(reqData, doAction, utWithCallbacks));
            String passwordTypeStrict = (String)this.getOption("passwordTypeStrict");
            if (passwordTypeStrict == null) {
                this.setProperty("passwordTypeStrict", "true");
            }
            this.doReceiverAction(doAction, reqData);
            if (doTimeLog) {
                t1 = System.currentTimeMillis();
            }
            Element elem = WSSecurityUtil.getSecurityHeader((Document)doc.getSOAPPart(), (String)actor);
            ArrayList<WSSecurityEngineResult> wsResult = engine.processSecurityHeader(elem, (RequestData)reqData);
            if (doTimeLog) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult != null && !wsResult.isEmpty()) {
                if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                    this.checkSignatureConfirmation(reqData, wsResult);
                }
                this.storeSignature(msg, reqData, wsResult);
                this.storeTimestamp(msg, reqData, wsResult);
                this.checkActions(msg, reqData, wsResult, actions);
                this.doResults(msg, actor, (Element)doc.getSOAPHeader(), (Element)doc.getSOAPBody(), wsResult, utWithCallbacks);
            } else {
                wsResult = new ArrayList<WSSecurityEngineResult>();
                if (doc.getSOAPPart().getEnvelope().getBody().hasFault()) {
                    LOG.warning("Request does not contain Security header, but it's a fault.");
                    this.doResults(msg, actor, (Element)doc.getSOAPHeader(), (Element)doc.getSOAPBody(), wsResult);
                } else {
                    this.checkActions(msg, reqData, wsResult, actions);
                    this.doResults(msg, actor, (Element)doc.getSOAPHeader(), (Element)doc.getSOAPBody(), wsResult);
                }
            }
            this.advanceBody(msg, (Node)doc.getSOAPBody());
            SAAJInInterceptor.replaceHeaders(doc, msg);
            if (doTimeLog) {
                t3 = System.currentTimeMillis();
                TIME_LOG.fine("Receive request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " header, cert verify, timestamp= " + (t3 - t2) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
        }
        catch (WSSecurityException e) {
            LOG.log(Level.WARNING, "", e);
            SoapFault fault = this.createSoapFault(version, e);
            throw fault;
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void checkActions(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult, List<Integer> actions) throws WSSecurityException {
        if (!this.ignoreActions && !this.checkReceiverResultsAnyOrder(wsResult, actions)) {
            LOG.warning("Security processing failed (actions mismatch)");
            throw new WSSecurityException(3);
        }
    }

    private void storeSignature(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        List signatureResults = new ArrayList();
        if (!(signatureResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)2, signatureResults)).isEmpty()) {
            msg.put(SIGNATURE_RESULT, signatureResults.get(signatureResults.size() - 1));
        }
    }

    private void storeTimestamp(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        List timestampResults = new ArrayList();
        if (!(timestampResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)32, timestampResults)).isEmpty()) {
            msg.put(TIMESTAMP_RESULT, timestampResults.get(timestampResults.size() - 1));
        }
    }

    protected void computeAction(SoapMessage msg, RequestData reqData) {
    }

    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult) throws SOAPException, XMLStreamException, WSSecurityException {
        this.doResults(msg, actor, soapHeader, soapBody, wsResult, false);
    }

    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        List results = CastUtils.cast((List)msg.get("RECV_RESULTS"));
        if (results == null) {
            results = new ArrayList();
            msg.put("RECV_RESULTS", (Object)results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        for (WSSecurityEngineResult o : wsResult) {
            SecurityContext sc;
            Principal p = (Principal)o.get((Object)"principal");
            if (p == null || !this.isSecurityContextPrincipal(p, wsResult)) continue;
            msg.put(PRINCIPAL_RESULT, (Object)p);
            if (!utWithCallbacks) {
                WSS4JTokenConverter.convertToken(msg, p);
            }
            if ((sc = msg.get(SecurityContext.class)) != null && sc.getUserPrincipal() != null) continue;
            msg.put(SecurityContext.class, this.createSecurityContext(p));
            break;
        }
    }

    protected boolean isSecurityContextPrincipal(Principal p, List<WSSecurityEngineResult> wsResult) {
        boolean derivedKeyPrincipal = p instanceof WSDerivedKeyTokenPrincipal;
        if (derivedKeyPrincipal || p instanceof CustomTokenPrincipal) {
            return wsResult.size() <= 1;
        }
        return true;
    }

    protected void advanceBody(SoapMessage msg, Node body) throws SOAPException, XMLStreamException, WSSecurityException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(new DOMSource(body));
        int evt = reader.next();
        for (int i = 0; reader.hasNext() && i < 1 && (evt != 2 || evt != 1); ++i) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, reader);
    }

    protected SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get("action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    protected CallbackHandler getCallback(RequestData reqData, int doAction, boolean utWithCallbacks) throws WSSecurityException {
        if (!(utWithCallbacks || (doAction & 1) == 0 && (doAction & 0x2000) == 0)) {
            CallbackHandler pwdCallback = null;
            try {
                pwdCallback = this.getCallback(reqData, doAction);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new DelegatingCallbackHandler(pwdCallback);
        }
        return this.getCallback(reqData, doAction);
    }

    protected CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        TokenStore store;
        Endpoint ep;
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            Object o = ((SoapMessage)reqData.getMsgContext()).getContextualProperty("ws-security.callback-handler");
            if (o instanceof String) {
                try {
                    o = ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
                }
                catch (Exception e) {
                    throw new WSSecurityException(e.getMessage(), (Throwable)e);
                }
            }
            if (o instanceof CallbackHandler) {
                cbHandler = (CallbackHandler)o;
            }
            if (cbHandler == null) {
                try {
                    cbHandler = this.getPasswordCallbackHandler(reqData);
                }
                catch (WSSecurityException sec) {
                    TokenStore store2;
                    Endpoint ep2 = ((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class);
                    if (ep2 != null && ep2.getEndpointInfo() != null && (store2 = (TokenStore)ep2.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
                        return new TokenStoreCallbackHandler(null, store2);
                    }
                    throw sec;
                }
            }
        }
        if ((ep = ((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class)) != null && ep.getEndpointInfo() != null && (store = (TokenStore)ep.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
            return new TokenStoreCallbackHandler(cbHandler, store);
        }
        return cbHandler;
    }

    protected WSSecurityEngine getSecurityEngine(boolean utWithCallbacks) {
        if (this.secEngineOverride != null) {
            return this.secEngineOverride;
        }
        if (!utWithCallbacks) {
            HashMap<QName, Object> profiles = new HashMap<QName, Object>(1);
            NoOpValidator validator = new NoOpValidator();
            profiles.put(WSSecurityEngine.USERNAME_TOKEN, validator);
            return WSS4JInInterceptor.createSecurityEngine(profiles);
        }
        return null;
    }

    protected static WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Class) {
                config.setProcessor(key, (Class)val);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val instanceof Validator) {
                config.setValidator(key, (Validator)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (Class)null);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        return ret;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }

    static class CXFRequestData
    extends RequestData {
        public Validator getValidator(QName qName) throws WSSecurityException {
            String key = null;
            if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                key = "ws-security.saml1.validator";
            } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                key = "ws-security.saml2.validator";
            } else if (WSSecurityEngine.USERNAME_TOKEN.equals(qName)) {
                key = "ws-security.ut.validator";
            } else if (WSSecurityEngine.SIGNATURE.equals(qName)) {
                key = "ws-security.signature.validator";
            } else if (WSSecurityEngine.TIMESTAMP.equals(qName)) {
                key = "ws-security.timestamp.validator";
            } else if (WSSecurityEngine.BINARY_TOKEN.equals(qName)) {
                key = "ws-security.bst.validator";
            }
            if (key != null) {
                Object o = ((SoapMessage)this.getMsgContext()).getContextualProperty(key);
                try {
                    if (o instanceof Validator) {
                        return (Validator)o;
                    }
                    if (o instanceof Class) {
                        return (Validator)((Class)o).newInstance();
                    }
                    if (o instanceof String) {
                        return (Validator)ClassLoaderUtils.loadClass(o.toString(), WSS4JInInterceptor.class).newInstance();
                    }
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new WSSecurityException(t.getMessage(), t);
                }
            }
            return super.getValidator(qName);
        }
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifier();
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(pc.getType())) {
                    for (SecurityToken token : this.store.getValidTokens()) {
                        if (!id.equals(token.getSHA1())) continue;
                        pc.setKey(token.getSecret());
                        return;
                    }
                    continue;
                }
                SecurityToken tok = this.store.getToken(id);
                if (tok == null) continue;
                pc.setKey(tok.getSecret());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

