/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.AlgorithmWrapper;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingToken
extends TokenWrapper
implements AlgorithmWrapper {
    private SPConstants.SupportTokenType type;
    private AlgorithmSuite algorithmSuite;
    private List<Token> tokens = new ArrayList<Token>();
    private SignedEncryptedElements signedElements;
    private SignedEncryptedElements encryptedElements;
    private SignedEncryptedParts signedParts;
    private SignedEncryptedParts encryptedParts;

    public SupportingToken(SPConstants.SupportTokenType type, SPConstants version) {
        super(version);
        this.type = type;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    @Override
    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public SPConstants.SupportTokenType getTokenType() {
        return this.type;
    }

    public void setTokenType(SPConstants.SupportTokenType t) {
        this.type = t;
    }

    public SignedEncryptedElements getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(SignedEncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public SignedEncryptedParts getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(SignedEncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }

    public SignedEncryptedElements getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(SignedEncryptedElements signedElements) {
        this.signedElements = signedElements;
    }

    public SignedEncryptedParts getSignedParts() {
        return this.signedParts;
    }

    public void setSignedParts(SignedEncryptedParts signedParts) {
        this.signedParts = signedParts;
    }

    @Override
    public void setToken(Token tok) {
        this.addToken(tok);
    }

    @Override
    public Token getToken() {
        if (this.tokens.size() == 1) {
            return this.tokens.get(0);
        }
        return null;
    }

    public QName getRealName() {
        QName ret = null;
        switch (this.type) {
            case SUPPORTING_TOKEN_SUPPORTING: {
                ret = this.constants.getSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_SIGNED: {
                ret = this.constants.getSignedSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_ENDORSING: {
                ret = this.constants.getEndorsingSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENDORSING: {
                ret = this.constants.getSignedEndorsingSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_ENCRYPTED: {
                ret = SP12Constants.ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENCRYPTED: {
                ret = SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_ENDORSING_ENCRYPTED: {
                ret = SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENDORSING_ENCRYPTED: {
                ret = SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public QName getName() {
        QName ret = null;
        switch (this.type) {
            case SUPPORTING_TOKEN_SUPPORTING: {
                ret = SP12Constants.INSTANCE.getSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_SIGNED: {
                ret = SP12Constants.INSTANCE.getSignedSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_ENDORSING: {
                ret = SP12Constants.INSTANCE.getEndorsingSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENDORSING: {
                ret = SP12Constants.INSTANCE.getSignedEndorsingSupportingTokens();
                break;
            }
            case SUPPORTING_TOKEN_ENCRYPTED: {
                ret = SP12Constants.ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENCRYPTED: {
                ret = SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_ENDORSING_ENCRYPTED: {
                ret = SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            case SUPPORTING_TOKEN_SIGNED_ENDORSING_ENCRYPTED: {
                ret = SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public boolean isEncryptedToken() {
        return this.type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENCRYPTED || this.type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENCRYPTED || this.type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENDORSING_ENCRYPTED || this.type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENDORSING_ENCRYPTED;
    }

    @Override
    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        String localname = this.getRealName().getLocalPart();
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        for (Token token : this.getTokens()) {
            token.serialize(writer);
        }
        if (this.signedParts != null) {
            this.signedParts.serialize(writer);
        } else if (this.signedElements != null) {
            this.signedElements.serialize(writer);
        } else if (this.encryptedParts != null) {
            this.encryptedParts.serialize(writer);
        } else if (this.encryptedElements != null) {
            this.encryptedElements.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public Policy getPolicy() {
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        for (Token token : this.getTokens()) {
            all.addPolicyComponent((PolicyComponent)token);
        }
        if (this.signedParts != null) {
            all.addPolicyComponent((PolicyComponent)this.signedParts);
        } else if (this.signedElements != null) {
            all.addPolicyComponent((PolicyComponent)this.signedElements);
        } else if (this.encryptedParts != null) {
            all.addPolicyComponent((PolicyComponent)this.encryptedParts);
        } else if (this.encryptedElements != null) {
            all.addPolicyComponent((PolicyComponent)this.encryptedElements);
        }
        ea.addPolicyComponent((PolicyComponent)all);
        PolicyComponent pc = p.normalize(true);
        if (pc instanceof Policy) {
            return (Policy)pc;
        }
        p = new Policy();
        p.addPolicyComponent(pc);
        return p;
    }
}

