/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class TransportToken
extends TokenWrapper {
    public TransportToken(SPConstants version) {
        super(version);
    }

    public Token getTransportToken() {
        return this.getToken();
    }

    public QName getRealName() {
        return this.constants.getTransportToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getTransportToken();
    }

    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String wspPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (wspPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.token != null) {
            this.token.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

