/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

@NoJSR250Annotations
public class LoggingInInterceptor
extends AbstractLoggingInterceptor {
    private static final Logger LOG = LogUtils.getLogger(LoggingInInterceptor.class);

    public LoggingInInterceptor() {
        super("receive");
    }

    public LoggingInInterceptor(String phase) {
        super(phase);
    }

    public LoggingInInterceptor(String id, String phase) {
        super(id, phase);
    }

    public LoggingInInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LoggingInInterceptor(String id, int lim) {
        this(id, "receive");
        this.limit = lim;
    }

    public LoggingInInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public LoggingInInterceptor(String id, PrintWriter w) {
        this(id, "receive");
        this.writer = w;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.writer != null || this.getLogger().isLoggable(Level.INFO)) {
            this.logging(message);
        }
    }

    protected void logging(Message message) throws Fault {
        InputStream is;
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        if (message.containsKey(LoggingMessage.ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get(LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put(LoggingMessage.ID_KEY, id);
        }
        message.put(LoggingMessage.ID_KEY, id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get(Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get(Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get("org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get("Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get(Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get("org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get(Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if ((is = message.getContent(InputStream.class)) != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy(is, bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
        this.log(buffer.toString());
    }

    protected Logger getLogger() {
        return LOG;
    }
}

