/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAnnotationListener;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInInterceptor;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyOutInterceptor;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.PolicyRegistryImpl;
import org.apache.cxf.ws.policy.PolicyVerificationInFaultInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class PolicyEngineImpl
implements PolicyEngine,
BusExtension {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyEngineImpl.class);
    private static final String POLICY_INFO_REQUEST_SERVER = "policy-engine-info-serve-request";
    private static final String POLICY_INFO_FAULT_SERVER = "policy-engine-info-serve-fault";
    private static final String POLICY_INFO_RESPONSE_SERVER = "policy-engine-info-serve-response";
    private static final String POLICY_INFO_ENDPOINT_SERVER = "policy-engine-info-serve-rendpoint";
    private static final String POLICY_INFO_REQUEST_CLIENT = "policy-engine-info-client-request";
    private static final String POLICY_INFO_FAULT_CLIENT = "policy-engine-info-client-fault";
    private static final String POLICY_INFO_RESPONSE_CLIENT = "policy-engine-info-client-response";
    private static final String POLICY_INFO_ENDPOINT_CLIENT = "policy-engine-info-client-endpoint";
    private Bus bus;
    private PolicyRegistry registry;
    private Collection<PolicyProvider> policyProviders;
    private Collection<PolicyProvider> preSetPolicyProviders = new LinkedList<PolicyProvider>();
    private boolean enabled = true;
    private Boolean ignoreUnknownAssertions;
    private boolean addedBusInterceptors;
    private AlternativeSelector alternativeSelector;

    public PolicyEngineImpl() {
        this.init();
    }

    public PolicyEngineImpl(boolean en) {
        this.enabled = en;
        this.init();
    }

    public PolicyEngineImpl(Bus b) {
        this.init();
        this.setBus(b);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Resource
    public final void setBus(Bus b) {
        if (this.bus == b) {
            return;
        }
        this.bus = b;
        this.addBusInterceptors();
        FactoryBeanListenerManager fblm = this.bus.getExtension(FactoryBeanListenerManager.class);
        if (fblm != null) {
            for (FactoryBeanListener l : fblm.getListeners()) {
                if (!(l instanceof PolicyAnnotationListener)) continue;
                return;
            }
            fblm.addListener(new PolicyAnnotationListener());
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setPolicyProviders(Collection<PolicyProvider> p) {
        this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>(p);
    }

    public synchronized void addPolicyProvider(PolicyProvider p) {
        if (this.policyProviders != null) {
            this.policyProviders.add(p);
        } else {
            this.preSetPolicyProviders.add(p);
        }
    }

    public synchronized Collection<PolicyProvider> getPolicyProviders() {
        if (this.policyProviders == null) {
            ConfiguredBeanLocator loc;
            this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>();
            if (this.bus != null && (loc = this.bus.getExtension(ConfiguredBeanLocator.class)) != null) {
                loc.getBeansOfType(PolicyProvider.class);
            }
            this.policyProviders.addAll(this.preSetPolicyProviders);
            this.preSetPolicyProviders = null;
        }
        return this.policyProviders;
    }

    public void setRegistry(PolicyRegistry r) {
        this.registry = r;
    }

    @Override
    public PolicyRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
        if (this.enabled && !this.addedBusInterceptors) {
            this.addBusInterceptors();
        } else if (!this.enabled && this.addedBusInterceptors) {
            this.removeBusInterceptors();
        }
    }

    @Override
    public synchronized AlternativeSelector getAlternativeSelector() {
        if (this.alternativeSelector == null && this.enabled) {
            this.alternativeSelector = new MinimalAlternativeSelector();
        }
        return this.alternativeSelector;
    }

    @Override
    public void setAlternativeSelector(AlternativeSelector as) {
        this.alternativeSelector = as;
    }

    @Override
    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions == null ? true : this.ignoreUnknownAssertions;
    }

    @Override
    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    @Override
    public Class<?> getRegistrationType() {
        return PolicyEngine.class;
    }

    @Override
    public EffectivePolicy getEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Conduit c) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (c instanceof Assertor) {
                assertor = (Assertor)((Object)c);
            }
            epi.initialise(ei, boi, this, assertor, true, true);
            boi.setProperty(POLICY_INFO_REQUEST_CLIENT, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_CLIENT, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Destination d) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)((Object)d);
            }
            epi.initialise(ei, boi, this, assertor, false, false);
            boi.setProperty(POLICY_INFO_RESPONSE_SERVER, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_SERVER, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, Destination d) {
        if (bfi == null) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)((Object)d);
            }
            epi.initialise(ei, boi, bfi, this, assertor);
            return epi;
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)(bfi = this.mapToWrappedBindingFaultInfo(bfi)).getProperty(POLICY_INFO_FAULT_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)((Object)d);
            }
            epi.initialise(ei, boi, bfi, this, assertor);
            bfi.setProperty(POLICY_INFO_FAULT_SERVER, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    private BindingFaultInfo mapToWrappedBindingFaultInfo(BindingFaultInfo bfi) {
        BindingOperationInfo boi = bfi.getBindingOperation();
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            for (BindingFaultInfo bf2 : boi.getFaults()) {
                if (!bf2.getFaultInfo().getName().equals(bfi.getFaultInfo().getName())) continue;
                return bf2;
            }
        }
        return bfi;
    }

    @Override
    public void setEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_SERVER, ep);
    }

    @Override
    public EndpointPolicy getClientEndpointPolicy(EndpointInfo ei, Conduit conduit) {
        Assertor assertor = conduit instanceof Assertor ? (Assertor)((Object)conduit) : null;
        return this.getEndpointPolicy(ei, true, assertor);
    }

    @Override
    public EndpointPolicy getServerEndpointPolicy(EndpointInfo ei, Destination destination) {
        Assertor assertor = destination instanceof Assertor ? (Assertor)((Object)destination) : null;
        return this.getEndpointPolicy(ei, false, assertor);
    }

    private EndpointPolicy getEndpointPolicy(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        EndpointPolicy ep = (EndpointPolicy)ei.getProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER);
        if (null != ep) {
            return ep;
        }
        return this.createEndpointPolicyInfo(ei, isRequestor, assertor);
    }

    @Override
    public void setClientEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_CLIENT, ep);
    }

    @Override
    public void setServerEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_SERVER, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialise(ei, boi, this, false, true);
            boi.setProperty(POLICY_INFO_REQUEST_SERVER, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_SERVER, ep);
    }

    @Override
    public EffectivePolicy getEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialise(ei, boi, this, true, false);
            boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, ep);
    }

    @Override
    public EffectivePolicy getEffectiveClientFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi) {
        EffectivePolicy effectivePolicy = null;
        if (bfi != null) {
            effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_CLIENT);
        }
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, boi, bfi, this);
            if (bfi != null) {
                bfi.setProperty(POLICY_INFO_FAULT_CLIENT, epi);
            }
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_CLIENT, ep);
    }

    protected final void init() {
        this.registry = new PolicyRegistryImpl();
    }

    public synchronized void removeBusInterceptors() {
        this.bus.getInInterceptors().remove(PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().remove(PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().remove(ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().remove(ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = false;
    }

    public final synchronized void addBusInterceptors() {
        AssertionBuilderRegistry abr;
        if (null == this.bus || !this.enabled) {
            return;
        }
        if (this.ignoreUnknownAssertions != null && null != (abr = this.bus.getExtension(AssertionBuilderRegistry.class))) {
            abr.setIgnoreUnknownAssertions(this.ignoreUnknownAssertions);
        }
        this.bus.getInInterceptors().add(PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().add(PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().add(ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = true;
    }

    Policy getAggregatedServicePolicy(ServiceInfo si) {
        if (si == null) {
            return new Policy();
        }
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(si);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedEndpointPolicy(EndpointInfo ei) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(ei);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedOperationPolicy(BindingOperationInfo boi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(boi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedMessagePolicy(BindingMessageInfo bmi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bmi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedFaultPolicy(BindingFaultInfo bfi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bfi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Collection<Assertion> getAssertions(PolicyComponent pc, boolean includeOptional) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add(a);
            }
        } else {
            this.addAssertions(pc, includeOptional, assertions);
        }
        return assertions;
    }

    Collection<Assertion> getAssertions(EffectivePolicy pc, boolean includeOptional) {
        if (pc == null || pc.getChosenAlternative() == null) {
            return null;
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (Assertion assertion : pc.getChosenAlternative()) {
            if (5 == assertion.getType()) {
                if (!includeOptional && assertion.isOptional()) continue;
                assertions.add(assertion);
                continue;
            }
            this.addAssertions((PolicyComponent)assertion, includeOptional, assertions);
        }
        return assertions;
    }

    void addAssertions(PolicyComponent pc, boolean includeOptional, Collection<Assertion> assertions) {
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add((Assertion)pc);
            }
            return;
        }
        if (4 == pc.getType()) {
            PolicyReference pr = (PolicyReference)pc;
            pc = pr.normalize(this.registry, false);
        }
        PolicyOperator po = (PolicyOperator)pc;
        List<PolicyComponent> pcs = CastUtils.cast(po.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent child : pcs) {
            this.addAssertions(child, includeOptional, assertions);
        }
    }

    Set<QName> getVocabulary(PolicyComponent pc, boolean includeOptional) {
        Collection<Assertion> assertions = this.getAssertions(pc, includeOptional);
        HashSet<QName> vocabulary = new HashSet<QName>();
        for (Assertion a : assertions) {
            vocabulary.add(a.getName());
        }
        return vocabulary;
    }

    EndpointPolicyImpl createEndpointPolicyInfo(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        EndpointPolicyImpl epi = new EndpointPolicyImpl(ei, this, isRequestor, assertor);
        epi.initialize();
        ei.setProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER, epi);
        return epi;
    }

    @Override
    public boolean supportsAlternative(Collection<? extends PolicyComponent> alternative, Assertor assertor) {
        PolicyInterceptorProviderRegistry pipr = this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        for (PolicyComponent policyComponent : alternative) {
            if (policyComponent instanceof Assertion) {
                Assertion a = (Assertion)policyComponent;
                if (a.isOptional() || null != pipr.get(a.getName()) || null != assertor && assertor.canAssert(a.getName())) continue;
                LOG.fine("Alternative " + a.getName() + " is not supported");
                return false;
            }
            return false;
        }
        return true;
    }

    EffectivePolicyImpl createOutPolicyInfo() {
        return new EffectivePolicyImpl();
    }
}

