/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.ServletRequestPropertyHolder;
import org.apache.cxf.message.Message;

public final class PropertyHolderFactory {
    private PropertyHolderFactory() {
    }

    public static PropertyHolder getPropertyHolder(Message m) {
        return m.containsKey("HTTP.REQUEST") ? new ServletRequestPropertyHolder(m) : new MessagePropertyHolder(m);
    }

    private static class MessagePropertyHolder
    implements PropertyHolder {
        private static final String PROPERTY_KEY = "jaxrs.filter.properties";
        private Message m;
        private Map<String, Object> props;

        public MessagePropertyHolder(Message m) {
            this.m = m;
            this.props = CastUtils.cast((Map)m.getExchange().get(PROPERTY_KEY));
        }

        @Override
        public Object getProperty(String name) {
            return this.props == null ? null : this.props.get(name);
        }

        @Override
        public void removeProperty(String name) {
            if (this.props != null) {
                this.props.remove(name);
            }
        }

        @Override
        public void setProperty(String name, Object value) {
            if (this.props == null) {
                this.props = new HashMap<String, Object>();
                this.m.getExchange().put(PROPERTY_KEY, this.props);
            }
            if (value == null) {
                this.removeProperty(name);
            } else {
                this.props.put(name, value);
            }
        }

        @Override
        public Enumeration<String> getPropertyNames() {
            final Iterator<String> it = this.props != null ? this.props.keySet().iterator() : null;
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it != null ? it.hasNext() : false;
                }

                @Override
                public String nextElement() {
                    if (it != null) {
                        return (String)it.next();
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    public static interface PropertyHolder {
        public Object getProperty(String var1);

        public void removeProperty(String var1);

        public void setProperty(String var1, Object var2);

        public Enumeration<String> getPropertyNames();
    }
}

