/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLCorbaWriterImpl
implements WSDLWriter {
    public static final int DEFAULT_INDENT_LEVEL = 2;
    final WSDLWriter wrapped;

    public WSDLCorbaWriterImpl(WSDLWriter orig) {
        this.wrapped = orig;
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.wrapped.setFeature(name, value);
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        return this.wrapped.getFeature(name);
    }

    public Document getDocument(Definition wsdlDef) throws WSDLException {
        try {
            this.fixTypes(wsdlDef);
        }
        catch (Exception ex) {
            throw new WSDLException("PARSER_ERROR", ex.getMessage(), (Throwable)ex);
        }
        Document doc = this.wrapped.getDocument(wsdlDef);
        Element imp = null;
        Element child = DOMUtils.getFirstElement(doc.getDocumentElement());
        while (child != null) {
            if (child.getNamespaceURI().equals(doc.getDocumentElement().getNamespaceURI())) {
                if (imp == null) {
                    imp = child;
                }
            } else if (imp != null) {
                doc.getDocumentElement().removeChild(child);
                doc.getDocumentElement().insertBefore(child, imp);
            }
            child = DOMUtils.getNextElement(child);
        }
        return doc;
    }

    private void fixTypes(Definition wsdlDef) throws ParserConfigurationException {
        Types t = wsdlDef.getTypes();
        if (t == null) {
            return;
        }
        List<ExtensibilityElement> l = CastUtils.cast(t.getExtensibilityElements());
        if (l == null) {
            return;
        }
        for (ExtensibilityElement e : l) {
            if (!(e instanceof Schema)) continue;
            Schema sc = (Schema)e;
            String pfx = wsdlDef.getPrefix(sc.getElementType().getNamespaceURI());
            if (StringUtils.isEmpty(pfx)) {
                pfx = "xsd";
                String ns = wsdlDef.getNamespace(pfx);
                int count = 1;
                while (!StringUtils.isEmpty(ns)) {
                    pfx = "xsd" + count++;
                    ns = wsdlDef.getNamespace(pfx);
                }
                wsdlDef.addNamespace(pfx, sc.getElementType().getNamespaceURI());
            }
            if (sc.getElement() != null) continue;
            this.fixSchema(sc, pfx);
        }
    }

    private void fixSchema(Schema sc, String pfx) throws ParserConfigurationException {
        Document doc = XMLUtils.newDocument();
        Element el = doc.createElementNS(sc.getElementType().getNamespaceURI(), pfx + ":" + sc.getElementType().getLocalPart());
        sc.setElement(el);
        Map mp = CastUtils.cast(sc.getImports());
        for (Map.Entry ent : mp.entrySet()) {
            Element imp = doc.createElementNS(sc.getElementType().getNamespaceURI(), pfx + ":import");
            el.appendChild(imp);
            imp.setAttribute("namespace", (String)ent.getKey());
        }
    }

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        XMLUtils.writeTo((Node)this.getDocument(wsdlDef), sink, 2);
    }

    public void writeWSDL(Definition wsdlDef, OutputStream sink) throws WSDLException {
        XMLUtils.writeTo((Node)this.getDocument(wsdlDef), sink, 2);
    }
}

