/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.VelocityGenerator;
import org.apache.cxf.tools.common.model.JavaClass;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.tools.util.FileWriterUtil;

public class BeanGenerator
extends AbstractGenerator<File> {
    private static final String TEMPLATE = "org/apache/cxf/tools/java2wsdl/generator/wsdl11/wrapperbean.vm";
    private File compileToDir;

    public void setCompileToDir(File f) {
        this.compileToDir = f;
    }

    protected Collection<JavaClass> generateBeanClasses(ServiceInfo service) {
        return null;
    }

    @Override
    public File generate(File sourcedir) {
        Collection<JavaClass> wrapperClasses;
        File dir = this.getOutputBase();
        if (dir == null) {
            dir = sourcedir;
        }
        if (dir == null) {
            dir = new File("./");
        }
        if (!(wrapperClasses = this.generateBeanClasses(this.getServiceModel())).isEmpty()) {
            this.generateAndCompile(wrapperClasses, dir);
        }
        return dir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateAndCompile(Collection<JavaClass> wrapperClasses, File dir) {
        VelocityGenerator generator = new VelocityGenerator(false);
        generator.setBaseDir(dir.toString());
        ArrayList<File> generatedFiles = new ArrayList<File>();
        try {
            for (JavaClass wrapperClass : wrapperClasses) {
                generator.setCommonAttributes();
                generator.setAttributes("bean", wrapperClass);
                File file = generator.parseOutputName(wrapperClass.getPackageName(), wrapperClass.getName());
                generatedFiles.add(file);
                generator.doWrite(TEMPLATE, new FileWriterUtil(file.getParent(), this.getOutputStreamCreator()).getWriter(file, (String)this.getToolContext().get("encoding")));
                generator.clearAttributes();
            }
            Compiler compiler = new Compiler();
            compiler.setOutputDir(this.compileToDir);
            ArrayList<String> files = new ArrayList<String>(generatedFiles.size());
            for (File file : generatedFiles) {
                files.add(file.getAbsolutePath());
            }
            if (compiler.compileFiles(files.toArray(new String[files.size()]))) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

