/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.javatowadl;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;

public class ResourceMapJavaDocProvider
implements DocumentationProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceMapJavaDocProvider.class);
    private Properties dumpedDocFile;

    public ResourceMapJavaDocProvider(String targetFolder) {
        try {
            this.dumpedDocFile = new Properties();
            FileInputStream fis = new FileInputStream(targetFolder + "/site/apidocs/dumpFile.properties");
            this.dumpedDocFile.load(fis);
            fis.close();
        }
        catch (Exception e) {
            LOG.warning("can't load dumped Docomentation file" + e.getMessage());
        }
    }

    public String getClassDoc(ClassResourceInfo cri) {
        Class<?> annotatedClass = this.getPathAnnotatedClass(cri.getServiceClass());
        return this.dumpedDocFile.getProperty(annotatedClass.getName());
    }

    public String getMethodDoc(OperationResourceInfo ori) {
        Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
        String methodKey = method.getDeclaringClass().getName() + "." + method.getName();
        return this.dumpedDocFile.getProperty(methodKey);
    }

    public String getMethodResponseDoc(OperationResourceInfo ori) {
        Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
        String methodResponseKey = method.getDeclaringClass().getName() + "." + method.getName() + "." + "returnCommentTag";
        return this.dumpedDocFile.getProperty(methodResponseKey);
    }

    public String getMethodParameterDoc(OperationResourceInfo ori, int paramIndex) {
        Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
        String methodParamKey = method.getDeclaringClass().getName() + "." + method.getName() + ".paramCommentTag." + paramIndex;
        return this.dumpedDocFile.getProperty(methodParamKey);
    }

    private Class<?> getPathAnnotatedClass(Class<?> cls) {
        if (cls.getAnnotation(Path.class) != null) {
            return cls;
        }
        if (cls.getSuperclass().getAnnotation(Path.class) != null) {
            return cls.getSuperclass();
        }
        for (Class<?> i : cls.getInterfaces()) {
            if (i.getAnnotation(Path.class) == null) continue;
            return i;
        }
        return cls;
    }
}

