/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ParameterType;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyImpl
extends AbstractClient
implements InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    private ClassResourceInfo cri;
    private boolean inheritHeaders;
    private boolean isRoot;
    private Map<String, Object> valuesMap;

    public ClientProxyImpl(URI baseURI, URI currentURI, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(baseURI, currentURI);
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
    }

    private void initValuesMap(Object ... varValues) {
        if (this.isRoot && varValues.length != 0) {
            this.valuesMap = new LinkedHashMap<String, Object>();
            List<String> vars = this.cri.getURITemplate().getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= varValues.length) {
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, new Object[]{vars.size(), varValues.length});
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put(vars.get(i), varValues[i]);
            }
        } else {
            this.valuesMap = Collections.emptyMap();
        }
    }

    @Override
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = ClientProxyImpl.getParametersInfo(ori, m, params);
        List<Object> pathParams = this.getPathParamValues(types, params, ori);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            builder.path(ori.getClassResourceInfo().getServiceClass());
        }
        builder.path(new Method[]{m});
        ClientProxyImpl.handleMatrixes(types, params, builder);
        ClientProxyImpl.handleQueries(types, params, builder);
        URI uri = builder.build(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap<String, String> paramHeaders = new MetadataMap<String, String>();
        this.handleHeaders(paramHeaders, types, params);
        this.handleCookies(paramHeaders, types, params);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            ClientProxyImpl proxyImpl = new ClientProxyImpl(this.getBaseURI(), uri, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setBus(this.bus);
            proxyImpl.setConduitSelector(this.conduitSelector);
            proxyImpl.setInInterceptors(this.inInterceptors);
            proxyImpl.setOutInterceptors(this.outInterceptors);
            Object proxy = JAXRSClientFactory.create(m.getReturnType(), proxyImpl);
            if (this.inheritHeaders) {
                WebClient.client(proxy).headers(headers);
            }
            WebClient.client(proxy).headers(paramHeaders);
            return proxy;
        }
        headers.putAll(paramHeaders);
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), bodyIndex == -1 ? null : params[bodyIndex].getClass(), m.getReturnType());
        return this.doChainedInvocation(uri, headers, ori, params, bodyIndex, types);
    }

    private static MultivaluedMap<ParameterType, Parameter> getParametersInfo(OperationResourceInfo ori, Method m, Object[] params) {
        MetadataMap<ParameterType, Parameter> map = new MetadataMap<ParameterType, Parameter>();
        Annotation[][] paramAnns = m.getParameterAnnotations();
        if (paramAnns.length == 0) {
            return map;
        }
        for (int i = 0; i < paramAnns.length; ++i) {
            Parameter p = ClientProxyImpl.getParameter(i, paramAnns[i], ori);
            map.add((Object)p.getType(), p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (((List)map.get((Object)ParameterType.REQUEST_BODY)).size() > 1) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "ONLY_FORM_ALLOWED");
            }
        }
        return map;
    }

    private static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        return index;
    }

    private static void checkResponse(Method m, Response r, Message message) throws Throwable {
        int status = r.getStatus();
        if (status >= 400) {
            Object t;
            ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(m, message);
            if (mapper != null && (t = mapper.fromResponse(r)) != null) {
                throw t;
            }
            throw new WebApplicationException(r);
        }
    }

    private static ResponseExceptionMapper<?> findExceptionMapper(Method m, Message message) {
        ProviderFactory pf = ProviderFactory.getInstance(message);
        for (Class<?> exType : m.getExceptionTypes()) {
            ResponseExceptionMapper mapper = pf.createResponseExceptionMapper(exType);
            if (mapper == null) continue;
            return mapper;
        }
        return null;
    }

    private MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<MediaType> accepts;
        if (headers.getFirst((Object)"Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            } else {
                String cType = bodyClass != null && InjectionUtils.isPrimitive(bodyClass) ? "text/plain" : (ori.getConsumeTypes().isEmpty() || ori.getConsumeTypes().get(0).equals((Object)WILDCARD) ? "application/xml" : ori.getConsumeTypes().get(0).toString());
                headers.putSingle((Object)"Content-Type", (Object)cType);
            }
        }
        if ((accepts = this.getAccept()) == null) {
            accepts = InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : (ori.getProduceTypes().size() == 0 || ori.getConsumeTypes().get(0).equals((Object)WILDCARD) ? Collections.singletonList(MediaType.APPLICATION_XML_TYPE) : ori.getProduceTypes());
            for (MediaType mt : accepts) {
                headers.add((Object)"Accept", (Object)mt.toString());
            }
        }
        return headers;
    }

    private List<Object> getPathParamValues(MultivaluedMap<ParameterType, Parameter> map, Object[] params, OperationResourceInfo ori) {
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        List<String> vars = ori.getURITemplate().getVariables();
        block0: for (Parameter p : paramsList) {
            if (this.valuesMap.containsKey(p.getValue()) && !vars.contains(p.getValue())) {
                int index = 0;
                Iterator<String> it = this.valuesMap.keySet().iterator();
                while (it.hasNext()) {
                    if (it.next().equals(p.getValue())) {
                        list.remove(index);
                        list.add(index, params[p.getIndex()]);
                        continue block0;
                    }
                    ++index;
                }
                continue;
            }
            list.add(params[p.getIndex()]);
        }
        return list;
    }

    private static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        return map.get((Object)key) == null ? Collections.EMPTY_LIST : (List)map.get((Object)key);
    }

    private static void handleQueries(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        for (Parameter p : qs) {
            if (params[p.getIndex()] == null) continue;
            ub.queryParam(p.getValue(), params[p.getIndex()].toString());
        }
    }

    private static void handleMatrixes(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        for (Parameter p : mx) {
            if (params[p.getIndex()] == null) continue;
            ub.matrixParam(p.getValue(), params[p.getIndex()].toString());
        }
    }

    private MultivaluedMap<String, String> handleForm(MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        MetadataMap<String, String> form = new MetadataMap<String, String>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        for (Parameter p : fm) {
            if (params[p.getIndex()] == null) continue;
            form.add(p.getValue(), params[p.getIndex()].toString());
        }
        return form;
    }

    private void handleHeaders(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        for (Parameter p : hs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)p.getValue(), (Object)params[p.getIndex()].toString());
        }
    }

    private void handleCookies(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        for (Parameter p : cs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)"Cookie", (Object)(p.getValue() + '=' + params[p.getIndex()].toString()));
        }
    }

    private static Parameter getParameter(int index, Annotation[] anns, OperationResourceInfo ori) {
        PathParam a;
        Context ctx = AnnotationUtils.getAnnotation(anns, Context.class);
        if (ctx != null) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_CONTEXT_PARAMETERS");
        }
        if ((a = AnnotationUtils.getAnnotation(anns, PathParam.class)) != null) {
            return new Parameter(ParameterType.PATH, index, a.value());
        }
        QueryParam q = AnnotationUtils.getAnnotation(anns, QueryParam.class);
        if (q != null) {
            return new Parameter(ParameterType.QUERY, index, q.value());
        }
        MatrixParam m = AnnotationUtils.getAnnotation(anns, MatrixParam.class);
        if (m != null) {
            return new Parameter(ParameterType.MATRIX, index, m.value());
        }
        HeaderParam h = AnnotationUtils.getAnnotation(anns, HeaderParam.class);
        if (h != null) {
            return new Parameter(ParameterType.HEADER, index, h.value());
        }
        Parameter p = null;
        CookieParam c = AnnotationUtils.getAnnotation(anns, CookieParam.class);
        p = c != null ? new Parameter(ParameterType.COOKIE, index, c.value()) : new Parameter(ParameterType.REQUEST_BODY, index, null);
        return p;
    }

    private Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object[] params, int bodyIndex, MultivaluedMap<ParameterType, Parameter> types) throws Throwable {
        Message m = this.createMessage(ori.getHttpMethod(), headers, uri);
        if (bodyIndex != -1 || types.containsKey((Object)ParameterType.FORM)) {
            m.setContent(OperationResourceInfo.class, (Object)ori);
            m.put((Object)"BODY_INDEX", (Object)bodyIndex);
            MultivaluedMap<String, String> body = bodyIndex != -1 ? params[bodyIndex] : this.handleForm(types, params);
            MessageContentsList contents = new MessageContentsList(new Object[]{body});
            m.setContent(List.class, (Object)contents);
            m.getInterceptorChain().add((Interceptor)new BodyWriter());
        }
        try {
            m.getInterceptorChain().doIntercept(m);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        HttpURLConnection connect = (HttpURLConnection)m.get((Object)"http.connection");
        return this.handleResponse(connect, m, ori);
    }

    protected Object handleResponse(HttpURLConnection connect, Message inMessage, OperationResourceInfo ori) throws Throwable {
        Response r = this.setResponseBuilder(connect).clone().build();
        Method method = ori.getMethodToInvoke();
        ClientProxyImpl.checkResponse(method, r, inMessage);
        if (method.getReturnType() == Void.class) {
            return null;
        }
        if (method.getReturnType() == Response.class) {
            return r;
        }
        return this.readBody(r, connect, inMessage, method.getReturnType(), method.getGenericReturnType(), method.getDeclaredAnnotations());
    }

    protected static void reportInvalidResourceMethod(Method m, String name) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, new Object[]{m.getDeclaringClass().getName(), m.getName()});
        LOG.severe(errorMsg.toString());
        throw new WebApplicationException(405);
    }

    private class BodyWriter
    extends AbstractOutDatabindingInterceptor {
        public BodyWriter() {
            super("write");
        }

        public void handleMessage(Message m) throws Fault {
            OperationResourceInfo ori = (OperationResourceInfo)m.getContent(OperationResourceInfo.class);
            OutputStream os = (OutputStream)m.getContent(OutputStream.class);
            if (os == null || ori == null) {
                return;
            }
            MessageContentsList objs = MessageContentsList.getContentsList((Message)m);
            if (objs == null || objs.size() == 0) {
                return;
            }
            MultivaluedMap headers = (MultivaluedMap)m.get((Object)Message.PROTOCOL_HEADERS);
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)m.get((Object)"BODY_INDEX");
            Object body = objs.get(0);
            try {
                if (bodyIndex != -1) {
                    ClientProxyImpl.this.writeBody(body, m, body.getClass(), method.getGenericParameterTypes()[bodyIndex], method.getParameterAnnotations()[bodyIndex], (MultivaluedMap<String, String>)headers, os);
                } else {
                    ClientProxyImpl.this.writeBody(body, m, body.getClass(), body.getClass(), method.getDeclaredAnnotations(), (MultivaluedMap<String, String>)headers, os);
                }
                os.flush();
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        }
    }

    private static class Parameter {
        private ParameterType type;
        private int ind;
        private String aValue;

        public Parameter(ParameterType type, int ind, String aValue) {
            this.type = type;
            this.ind = ind;
            this.aValue = aValue;
        }

        public int getIndex() {
            return this.ind;
        }

        public String getValue() {
            return this.aValue;
        }

        public ParameterType getType() {
            return this.type;
        }
    }
}

