/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSOutInterceptor.class);

    public JAXRSOutInterceptor() {
        super("marshal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        try {
            this.processResponse(message);
        }
        finally {
            ProviderFactory.getInstance(message).clearThreadLocalProxies();
            ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
            if (cri != null) {
                cri.clearThreadLocalProxies();
            }
        }
    }

    private void processResponse(Message message) {
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        if (objs.get(0) != null) {
            Object responseObj = objs.get(0);
            Response response = null;
            response = objs.get(0) instanceof Response ? (Response)responseObj : Response.ok((Object)responseObj).build();
            Exchange exchange = message.getExchange();
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get((Object)OperationResourceInfo.class.getName());
            List<ProviderInfo<ResponseHandler>> handlers = ProviderFactory.getInstance(message).getResponseHandlers();
            for (ProviderInfo<ResponseHandler> rh : handlers) {
                Response r = rh.getProvider().handleResponse(message, ori, response);
                if (r == null) continue;
                response = r;
            }
            this.serializeMessage(message, response, ori, true);
        } else {
            message.put((Object)Message.RESPONSE_CODE, (Object)204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeMessage(Message message, Response response, OperationResourceInfo ori, boolean firstTry) {
        message.put((Object)Message.RESPONSE_CODE, (Object)response.getStatus());
        Map theHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (firstTry && theHeaders != null) {
            theHeaders.putAll(response.getMetadata());
        } else {
            message.put((Object)Message.PROTOCOL_HEADERS, (Object)response.getMetadata());
        }
        Object responseObj = response.getEntity();
        if (responseObj == null) {
            return;
        }
        Class<?> targetType = responseObj.getClass();
        List<MediaType> availableContentTypes = this.computeAvailableContentTypes(message, response);
        Method invoked = null;
        if (firstTry) {
            invoked = ori == null ? null : ori.getMethodToInvoke();
        }
        MessageBodyWriter<?> writer = null;
        MediaType responseType = null;
        for (MediaType type : availableContentTypes) {
            writer = ProviderFactory.getInstance(message).createMessageBodyWriter(targetType, invoked != null ? invoked.getGenericReturnType() : null, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, type, message);
            if (writer == null) continue;
            responseType = type;
            break;
        }
        OutputStream outOriginal = (OutputStream)message.getContent(OutputStream.class);
        if (writer == null) {
            message.put((Object)Message.RESPONSE_CODE, (Object)500);
            this.writeResponseErrorMessage(outOriginal, "NO_MSG_WRITER", targetType.getSimpleName());
            return;
        }
        boolean enabled = this.checkBufferingMode(message, writer, firstTry);
        try {
            responseType = this.checkFinalContentType(responseType);
            LOG.fine("Response content type is: " + responseType.toString());
            message.put((Object)"Content-Type", (Object)responseType.toString());
            LOG.fine("Response EntityProvider is: " + writer.getClass().getName());
            try {
                writer.writeTo(responseObj, targetType, invoked != null ? invoked.getGenericReturnType() : null, invoked != null ? invoked.getAnnotations() : new Annotation[]{}, responseType, response.getMetadata(), (OutputStream)message.getContent(OutputStream.class));
                this.checkCachedStream(message, outOriginal, enabled);
            }
            finally {
                if (enabled) {
                    message.setContent(OutputStream.class, (Object)outOriginal);
                    message.put((Object)XMLStreamWriter.class.getName(), null);
                }
            }
        }
        catch (IOException ex) {
            this.handleWriteException(message, response, ori, ex, responseObj, firstTry);
        }
        catch (Throwable ex) {
            this.handleWriteException(message, response, ori, ex, responseObj, firstTry);
        }
    }

    private boolean checkBufferingMode(Message m, MessageBodyWriter w, boolean firstTry) {
        boolean enabled;
        if (!firstTry) {
            return false;
        }
        Object outBuf = m.getContextualProperty("org.apache.cxf.output.buffering");
        boolean bl = enabled = Boolean.TRUE.equals(outBuf) || "true".equals(outBuf);
        if (!enabled && outBuf == null) {
            enabled = InjectionUtils.invokeBooleanGetter(w, "getEnableBuffering");
        }
        if (enabled) {
            boolean streamingOn;
            boolean bl2 = streamingOn = "org.apache.cxf.jaxrs.provider.JAXBElementProvider".equals(w.getClass().getName()) && InjectionUtils.invokeBooleanGetter(w, "getEnableStreaming");
            if (streamingOn) {
                m.put((Object)XMLStreamWriter.class.getName(), (Object)new CachingXmlEventWriter());
            } else {
                m.setContent(OutputStream.class, (Object)new CachedOutputStream());
            }
        }
        return enabled;
    }

    private void checkCachedStream(Message m, OutputStream osOriginal, boolean enabled) throws Exception {
        CachedOutputStream cos;
        if (!enabled) {
            return;
        }
        XMLStreamWriter writer = (XMLStreamWriter)m.get((Object)XMLStreamWriter.class.getName());
        if (writer instanceof CachingXmlEventWriter) {
            CachingXmlEventWriter cache = (CachingXmlEventWriter)writer;
            if (cache.getEvents().size() != 0) {
                XMLStreamWriter origWriter = StaxUtils.createXMLStreamWriter((OutputStream)osOriginal);
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent((XMLEvent)event, (XMLStreamWriter)origWriter);
                }
            }
            m.put((Object)XMLStreamWriter.class.getName(), null);
            return;
        }
        OutputStream os = (OutputStream)m.getContent(OutputStream.class);
        if (os != osOriginal && os instanceof CachedOutputStream && (cos = (CachedOutputStream)os).size() != 0) {
            cos.writeCacheTo(osOriginal);
        }
    }

    private void handleWriteException(Message message, Response response, OperationResourceInfo ori, Throwable ex, Object responseObj, boolean firstTry) {
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        if (firstTry) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
            if (excResponse != null) {
                this.serializeMessage(message, excResponse, ori, false);
            }
        } else {
            message.put((Object)Message.RESPONSE_CODE, (Object)500);
            this.writeResponseErrorMessage(out, "SERIALIZE_ERROR", responseObj.getClass().getSimpleName());
        }
    }

    private void writeResponseErrorMessage(OutputStream out, String errorString, String parameter) {
        try {
            org.apache.cxf.common.i18n.Message message = new org.apache.cxf.common.i18n.Message(errorString, BUNDLE, new Object[]{parameter});
            LOG.warning(message.toString());
            out.write(message.toString().getBytes("UTF-8"));
        }
        catch (IOException another) {
            // empty catch block
        }
    }

    private List<MediaType> computeAvailableContentTypes(Message message, Response response) {
        Object contentType = response.getMetadata().getFirst((Object)"Content-Type");
        Exchange exchange = message.getExchange();
        List<MediaType> produceTypes = null;
        OperationResourceInfo operation = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        if (contentType != null) {
            return Collections.singletonList(MediaType.valueOf((String)contentType.toString()));
        }
        produceTypes = operation != null ? operation.getProduceTypes() : Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        List<MediaType> acceptContentTypes = (List<MediaType>)exchange.get((Object)"Accept");
        if (acceptContentTypes == null) {
            acceptContentTypes = Collections.singletonList(MediaType.valueOf((String)"*/*"));
        }
        return JAXRSUtils.intersectMimeTypes(acceptContentTypes, produceTypes);
    }

    private MediaType checkFinalContentType(MediaType mt) {
        if (mt.isWildcardType() || mt.isWildcardSubtype()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if (mt.getParameters().containsKey("q")) {
            StringBuilder sb = new StringBuilder();
            sb.append(mt.getType()).append('/').append(mt.getSubtype());
            if (mt.getParameters().size() > 1) {
                for (String key : mt.getParameters().keySet()) {
                    if ("q".equals(key)) continue;
                    sb.append(';').append(key).append('=').append((String)mt.getParameters().get(key));
                }
            }
            return MediaType.valueOf((String)sb.toString());
        }
        return mt;
    }
}

