/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XmlSchemaPrimitiveUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.Description;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlGenerator
implements RequestHandler {
    public static final String WADL_QUERY = "_wadl";
    public static final MediaType WADL_TYPE = MediaType.valueOf((String)"application/vnd.sun.wadl+xml");
    public static final String WADL_NS = "http://research.sun.com/wadl/2006/10";
    private static final Logger LOG = LogUtils.getL7dLogger(WadlGenerator.class);
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private String wadlNamespace;
    private boolean ignoreMessageWriters = true;
    private boolean singleResourceMultipleMethods = true;
    private boolean useSingleSlashResource = true;

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resource) {
        if (!"GET".equals(m.get((Object)Message.HTTP_REQUEST_METHOD))) {
            return null;
        }
        UriInfoImpl ui = new UriInfoImpl(m);
        if (!ui.getQueryParameters().containsKey((Object)WADL_QUERY)) {
            return null;
        }
        StringBuilder sbMain = new StringBuilder();
        sbMain.append("<application xmlns=\"").append(this.getNamespace()).append("\" xmlns:xs=\"").append("http://www.w3.org/2001/XMLSchema").append("\"");
        StringBuilder sbGrammars = new StringBuilder();
        sbGrammars.append("<grammars>");
        StringBuilder sbResources = new StringBuilder();
        sbResources.append("<resources base=\"").append(ui.getBaseUri().toString()).append("\">");
        List<ClassResourceInfo> cris = this.getResourcesList(m, resource);
        Set<Class<?>> jaxbTypes = ResourceUtils.getAllRequestResponseTypes(cris, true).keySet();
        JAXBContext context = this.createJaxbContext(jaxbTypes);
        SchemaCollection coll = this.getSchemaCollection(context);
        JAXBContextProxy proxy = null;
        if (coll != null) {
            proxy = (JAXBContextProxy)ReflectionInvokationHandler.createProxyWrapper((Object)context, JAXBContextProxy.class);
        }
        IdentityHashMap clsMap = new IdentityHashMap();
        HashSet<ClassResourceInfo> visitedResources = new HashSet<ClassResourceInfo>();
        for (ClassResourceInfo cri : cris) {
            String path = cri.getURITemplate().getValue();
            sbResources.append("<resource path=\"").append(path).append("\">");
            this.handleDocs(cri.getServiceClass().getAnnotations(), sbResources);
            this.handleResource(sbResources, jaxbTypes, proxy, clsMap, cri, visitedResources);
            sbResources.append("</resource>");
        }
        sbResources.append("</resources>");
        this.handleGrammars(sbMain, sbGrammars, coll, clsMap);
        sbGrammars.append("</grammars>");
        sbMain.append(">");
        sbMain.append(sbGrammars.toString());
        sbMain.append(sbResources.toString());
        sbMain.append("</application>");
        m.getExchange().put((Object)"ignore.message.writers", (Object)this.ignoreMessageWriters);
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        MediaType type = headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_XML_TYPE) ? MediaType.APPLICATION_XML_TYPE : WADL_TYPE;
        return Response.ok().type(type).entity((Object)sbMain.toString()).build();
    }

    private void handleGrammars(StringBuilder sbApp, StringBuilder sbGrammars, SchemaCollection coll, Map<Class<?>, QName> clsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (QName qName : clsMap.values()) {
            map.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        for (Map.Entry entry : map.entrySet()) {
            sbApp.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        this.writeSchemas(sbGrammars, coll);
    }

    private void writeSchemas(StringBuilder sb, SchemaCollection coll) {
        if (coll == null) {
            return;
        }
        for (XmlSchema xs : coll.getXmlSchemas()) {
            if (xs.getItems().getCount() == 0) continue;
            StringWriter writer = new StringWriter();
            xs.write((Writer)writer);
            sb.append(writer.toString());
        }
    }

    private void handleResource(StringBuilder sb, Set<Class<?>> jaxbTypes, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, ClassResourceInfo cri, Set<ClassResourceInfo> visitedResources) {
        visitedResources.add(cri);
        List<OperationResourceInfo> sortedOps = this.sortOperationsByPath(cri.getMethodDispatcher().getOperationResourceInfos());
        boolean resourceTagOpened = false;
        for (int i = 0; i < sortedOps.size(); ++i) {
            OperationResourceInfo ori = sortedOps.get(i);
            if (ori.getHttpMethod() == null) {
                Class<?> cls = ori.getMethodToInvoke().getReturnType();
                ClassResourceInfo subcri = cri.findResource(cls, cls);
                if (subcri != null && !visitedResources.contains(subcri)) {
                    String path = ori.getURITemplate().getValue();
                    sb.append("<resource path=\"").append(path).append("\">");
                    this.handleDocs(subcri.getServiceClass().getAnnotations(), sb);
                    this.handlePathAndMatrixParams(sb, ori);
                    this.handleResource(sb, jaxbTypes, jaxbProxy, clsMap, subcri, visitedResources);
                    sb.append("</resource>");
                    continue;
                }
                this.handleDynamicSubresource(sb, jaxbTypes, jaxbProxy, clsMap, ori, subcri);
                continue;
            }
            OperationResourceInfo nextOp = i + 1 < sortedOps.size() ? sortedOps.get(i + 1) : null;
            resourceTagOpened = this.handleOperation(sb, jaxbTypes, jaxbProxy, clsMap, ori, nextOp, resourceTagOpened, i);
        }
    }

    private boolean handleOperation(StringBuilder sb, Set<Class<?>> jaxbTypes, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, OperationResourceInfo nextOp, boolean resourceTagOpened, int index) {
        boolean isVoid;
        boolean samePathOperationFollows = this.singleResourceMultipleMethods && this.compareOperations(ori, nextOp);
        String path = ori.getURITemplate().getValue();
        if (!resourceTagOpened && this.openResource(path)) {
            String parentPath;
            resourceTagOpened = true;
            URITemplate template = ori.getClassResourceInfo().getURITemplate();
            if (template != null && (parentPath = template.getValue()).endsWith("/") && path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            sb.append("<resource path=\"").append(path).append("\">");
            this.handlePathAndMatrixParams(sb, ori);
        } else if (index == 0) {
            this.handlePathAndMatrixParams(sb, ori);
        }
        sb.append("<method name=\"").append(ori.getHttpMethod()).append("\">");
        this.handleDocs(ori.getAnnotatedMethod().getAnnotations(), sb);
        if (ori.getMethodToInvoke().getParameterTypes().length != 0) {
            sb.append("<request>");
            if (this.isFormRequest(ori)) {
                this.handleRepresentation(sb, jaxbTypes, jaxbProxy, clsMap, ori, null, false);
            } else {
                for (Parameter p : ori.getParameters()) {
                    this.handleParameter(sb, jaxbTypes, jaxbProxy, clsMap, ori, p);
                }
            }
            sb.append("</request>");
        }
        sb.append("<response");
        boolean bl = isVoid = Void.TYPE == ori.getMethodToInvoke().getReturnType();
        if (isVoid) {
            sb.append(" status=\"204\"");
        }
        sb.append(">");
        if (Void.TYPE != ori.getMethodToInvoke().getReturnType()) {
            this.handleRepresentation(sb, jaxbTypes, jaxbProxy, clsMap, ori, ori.getMethodToInvoke().getReturnType(), false);
        }
        sb.append("</response>");
        sb.append("</method>");
        if (resourceTagOpened && !samePathOperationFollows) {
            sb.append("</resource>");
            resourceTagOpened = false;
        }
        return resourceTagOpened;
    }

    protected boolean compareOperations(OperationResourceInfo ori1, OperationResourceInfo ori2) {
        if (ori1 == null || ori2 == null || !ori1.getURITemplate().getValue().equals(ori2.getURITemplate().getValue())) {
            return false;
        }
        int ori1PathParams = 0;
        int ori1MatrixParams = 0;
        for (Parameter p : ori1.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori1PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori1MatrixParams;
        }
        int ori2PathParams = 0;
        int ori2MatrixParams = 0;
        for (Parameter p : ori2.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori2PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori2MatrixParams;
        }
        return ori1PathParams == ori2PathParams && ori1MatrixParams == ori2MatrixParams;
    }

    private boolean openResource(String path) {
        if ("/".equals(path)) {
            return this.useSingleSlashResource;
        }
        return true;
    }

    protected void handleDynamicSubresource(StringBuilder sb, Set<Class<?>> jaxbTypes, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, ClassResourceInfo subcri) {
        if (subcri != null) {
            sb.append("<!-- Recursive subresource -->");
        } else {
            sb.append("<!-- Dynamic subresource -->");
        }
        sb.append("<resource path=\"").append(ori.getURITemplate().getValue()).append("\">");
        this.handlePathAndMatrixParams(sb, ori);
        sb.append("</resource>");
    }

    private void handlePathAndMatrixParams(StringBuilder sb, OperationResourceInfo ori) {
        this.handleParams(sb, ori, ParameterType.PATH);
        this.handleParams(sb, ori, ParameterType.MATRIX);
    }

    private void handleParameter(StringBuilder sb, Set<Class<?>> jaxbTypes, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Parameter pm) {
        Class<?> cls = ori.getMethodToInvoke().getParameterTypes()[pm.getIndex()];
        if (pm.getType() == ParameterType.REQUEST_BODY) {
            this.handleRepresentation(sb, jaxbTypes, jaxbProxy, clsMap, ori, cls, true);
            return;
        }
        if (pm.getType() == ParameterType.PATH || pm.getType() == ParameterType.MATRIX) {
            return;
        }
        if (pm.getType() == ParameterType.HEADER || pm.getType() == ParameterType.QUERY) {
            this.writeParam(sb, pm, ori);
        }
    }

    private void handleParams(StringBuilder sb, OperationResourceInfo ori, ParameterType type) {
        for (Parameter pm : ori.getParameters()) {
            if (pm.getType() != type) continue;
            this.writeParam(sb, pm, ori);
        }
    }

    private void writeParam(StringBuilder sb, Parameter pm, OperationResourceInfo ori) {
        Class<?> type = ori.getMethodToInvoke().getParameterTypes()[pm.getIndex()];
        if (!"".equals(pm.getName())) {
            this.doWriteParam(sb, pm, type, pm.getName());
        } else {
            this.doWriteBeanParam(sb, type, pm, null);
        }
    }

    private void doWriteBeanParam(StringBuilder sb, Class<?> type, Parameter pm, String parentName) {
        Map<Parameter, Class<?>> pms = InjectionUtils.getParametersFromBeanClass(type, pm.getType());
        for (Map.Entry<Parameter, Class<?>> entry : pms.entrySet()) {
            String name = entry.getKey().getName();
            if (parentName != null) {
                name = parentName + "." + name;
            }
            if (InjectionUtils.isPrimitive(entry.getValue())) {
                this.doWriteParam(sb, entry.getKey(), entry.getValue(), name);
                continue;
            }
            this.doWriteBeanParam(sb, entry.getValue(), entry.getKey(), name);
        }
    }

    protected void doWriteParam(StringBuilder sb, Parameter pm, Class<?> type, String paramName) {
        String value;
        sb.append("<param name=\"").append(paramName).append("\" ");
        String style = ParameterType.PATH == pm.getType() ? "template" : (ParameterType.FORM == pm.getType() ? "query" : pm.getType().toString().toLowerCase());
        sb.append("style=\"").append(style).append("\"");
        if (pm.getDefaultValue() != null) {
            sb.append(" default=\"").append(pm.getDefaultValue()).append("\"");
        }
        if ((value = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type)) != null) {
            sb.append(" type=\"").append(value).append("\"");
        }
        sb.append("/>");
    }

    private void handleRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean inbound) {
        List<MediaType> types;
        List<MediaType> list = types = inbound ? ori.getConsumeTypes() : ori.getProduceTypes();
        if (types.size() == 1 && types.get(0).equals((Object)MediaType.WILDCARD_TYPE) && (type == null || MultivaluedMap.class.isAssignableFrom(type))) {
            types = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        }
        if (type != null) {
            for (MediaType mt : types) {
                if (InjectionUtils.isPrimitive(type)) {
                    String rep = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type);
                    String value = rep == null ? type.getSimpleName() : rep;
                    sb.append("<!-- Primitive type : " + value + " -->");
                }
                sb.append("<representation");
                sb.append(" mediaType=\"").append(mt.toString()).append("\"");
                if (jaxbProxy != null && mt.getSubtype().contains("xml") && jaxbTypes.contains(type)) {
                    this.generateQName(sb, jaxbProxy, clsMap, type);
                }
                sb.append("/>");
            }
        } else {
            sb.append("<representation");
            sb.append(" mediaType=\"").append(types.get(0).toString()).append("\">");
            for (Parameter pm : ori.getParameters()) {
                this.writeParam(sb, pm, ori);
            }
            sb.append("</representation>");
        }
    }

    protected List<OperationResourceInfo> sortOperationsByPath(Set<OperationResourceInfo> ops) {
        LinkedList<OperationResourceInfo> opsWithSamePath = new LinkedList<OperationResourceInfo>(ops);
        Collections.sort(opsWithSamePath, new Comparator<OperationResourceInfo>(){

            @Override
            public int compare(OperationResourceInfo op1, OperationResourceInfo op2) {
                boolean sub2;
                boolean sub1 = op1.getHttpMethod() == null;
                boolean bl = sub2 = op2.getHttpMethod() == null;
                if (sub1 && !sub2) {
                    return 1;
                }
                if (!sub1 && sub2) {
                    return -1;
                }
                URITemplate ut1 = op1.getURITemplate();
                URITemplate ut2 = op2.getURITemplate();
                int result = ut1.getValue().compareTo(ut2.getValue());
                if (result == 0) {
                    result = op1.getHttpMethod().compareTo(op2.getHttpMethod());
                }
                return result;
            }
        });
        return opsWithSamePath;
    }

    public List<ClassResourceInfo> getResourcesList(Message m, ClassResourceInfo cri) {
        return cri != null ? Collections.singletonList(cri) : ((JAXRSServiceImpl)((Object)m.getExchange().get(Service.class))).getClassResourceInfos();
    }

    private void generateQName(StringBuilder sb, JAXBContextProxy jaxbProxy, Map<Class<?>, QName> clsMap, Class<?> type) {
        QName typeQName = clsMap.get(type);
        if (typeQName != null) {
            this.writeQName(sb, typeQName);
            return;
        }
        QName qname = this.getQName(jaxbProxy, type, clsMap);
        if (qname != null) {
            this.writeQName(sb, qname);
            clsMap.put(type, qname);
        }
    }

    private void writeQName(StringBuilder sb, QName qname) {
        sb.append(" element=\"").append(qname.getPrefix()).append(':').append(qname.getLocalPart()).append("\"");
    }

    private SchemaCollection getSchemaCollection(JAXBContext context) {
        if (context == null) {
            return null;
        }
        SchemaCollection xmlSchemaCollection = new SchemaCollection();
        HashSet<DOMSource> schemas = new HashSet<DOMSource>();
        try {
            for (DOMResult r : JAXBUtils.generateJaxbSchemas((JAXBContext)context, (Map)CastUtils.cast(Collections.emptyMap(), String.class, DOMResult.class))) {
                schemas.add(new DOMSource(r.getNode(), r.getSystemId()));
            }
        }
        catch (IOException e) {
            LOG.fine("No schema can be generated");
            return null;
        }
        boolean hackAroundEmptyNamespaceIssue = false;
        for (DOMSource r : schemas) {
            hackAroundEmptyNamespaceIssue = this.addSchemaDocument(xmlSchemaCollection, (Document)r.getNode(), r.getSystemId(), hackAroundEmptyNamespaceIssue);
        }
        return xmlSchemaCollection;
    }

    private QName getQName(JAXBContextProxy jaxbProxy, Class<?> type, Map<Class<?>, QName> clsMap) {
        XmlRootElement root = type.getAnnotation(XmlRootElement.class);
        if (root != null) {
            QName qname = this.getQNameFromParts(root.name(), root.namespace(), clsMap);
            if (qname != null) {
                return qname;
            }
            String ns = JAXBUtils.getPackageNamespace(type);
            if (ns != null) {
                return this.getQNameFromParts(root.name(), ns, clsMap);
            }
            return null;
        }
        try {
            JAXBBeanInfo jaxbInfo = JAXBUtils.getBeanInfo((JAXBContextProxy)jaxbProxy, type);
            if (jaxbInfo == null) {
                return null;
            }
            Object instance = type.newInstance();
            return this.getQNameFromParts(jaxbInfo.getElementLocalName(instance), jaxbInfo.getElementNamespaceURI(instance), clsMap);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getPrefix(String ns, Map<Class<?>, QName> clsMap) {
        String prefix = null;
        for (QName name : clsMap.values()) {
            if (!name.getNamespaceURI().equals(ns)) continue;
            prefix = name.getPrefix();
            break;
        }
        if (prefix == null) {
            int size = new HashSet<QName>(clsMap.values()).size();
            prefix = "prefix" + (size + 1);
        }
        return prefix;
    }

    private JAXBContext createJaxbContext(Set<Class<?>> classes) {
        if (classes.isEmpty()) {
            return null;
        }
        HashSet classesToBeBound = new HashSet(classes);
        JAXBUtils.scanPackages(classesToBeBound, null);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound.toArray(new Class[classes.size()]));
            return ctx;
        }
        catch (JAXBException ex) {
            LOG.fine("No JAXB context can be created");
            return null;
        }
    }

    private boolean isFormRequest(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.FORM) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSchemaDocument(SchemaCollection col, Document d, String systemId, boolean hackAroundEmptyNamespaceIssue) {
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty((String)ns)) {
            if (DOMUtils.getFirstElement((Node)d.getDocumentElement()) == null) {
                hackAroundEmptyNamespaceIssue = true;
                return hackAroundEmptyNamespaceIssue;
            }
            d = this.copy(d);
            ns = "";
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        if (hackAroundEmptyNamespaceIssue) {
            d = this.doEmptyNamespaceHack(d);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
        }
        Document document = d;
        synchronized (document) {
            col.read(d, systemId, null);
        }
        return hackAroundEmptyNamespaceIssue;
    }

    private Document doEmptyNamespaceHack(Document d) {
        boolean hasStuffToRemove = false;
        Element el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
        while (el != null) {
            if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                hasStuffToRemove = true;
                break;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        if (hasStuffToRemove) {
            d = this.copy(d);
            el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
            while (el != null) {
                if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                    d.getDocumentElement().removeChild(el);
                    el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
                    continue;
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        return d;
    }

    private Document copy(Document doc) {
        try {
            return StaxUtils.copy((Document)doc);
        }
        catch (XMLStreamException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    private QName getQNameFromParts(String name, String namespace, Map<Class<?>, QName> clsMap) {
        if (name == null || "##default".equals(name) || name.length() == 0) {
            return null;
        }
        if (namespace == null || "##default".equals(namespace) || namespace.length() == 0) {
            return null;
        }
        String prefix = this.getPrefix(namespace, clsMap);
        return new QName(namespace, name, prefix);
    }

    public void setIgnoreMessageWriters(boolean ignoreMessageWriters) {
        this.ignoreMessageWriters = ignoreMessageWriters;
    }

    private void handleDocs(Annotation[] anns, StringBuilder sb) {
        for (Annotation a : anns) {
            if (a.annotationType() != Description.class) continue;
            Description d = (Description)a;
            sb.append("<doc");
            if (d.lang().length() > 0) {
                sb.append(" xml:lang=\"" + d.lang() + "\"");
            }
            if (d.title().length() > 0) {
                sb.append(" title=\"" + d.title() + "\"");
            }
            sb.append(">");
            if (d.value().length() > 0) {
                sb.append(d.value());
            } else if (d.docuri().length() > 0) {
                String path;
                InputStream is = null;
                if (d.docuri().startsWith(CLASSPATH_PREFIX) && (is = ResourceUtils.getClasspathResourceStream(path = d.docuri().substring(CLASSPATH_PREFIX.length()), SchemaHandler.class, BusFactory.getDefaultBus())) != null) {
                    try {
                        sb.append(IOUtils.toString((InputStream)is));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            sb.append("</doc>");
        }
    }

    private String getNamespace() {
        return this.wadlNamespace != null ? this.wadlNamespace : WADL_NS;
    }

    public void setWadlNamespace(String namespace) {
        this.wadlNamespace = namespace;
    }

    public void setSingleResourceMultipleMethods(boolean singleResourceMultipleMethods) {
        this.singleResourceMultipleMethods = singleResourceMultipleMethods;
    }

    public void setUseSingleSlashResource(boolean useSingleSlashResource) {
        this.useSingleSlashResource = useSingleSlashResource;
    }
}

