/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.security.Principal;
import java.util.List;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

public class SecurityContextImpl
implements javax.ws.rs.core.SecurityContext {
    private Message m;

    public SecurityContextImpl(Message m) {
        this.m = m;
    }

    public String getAuthenticationScheme() {
        if (this.m.get(AuthorizationPolicy.class) != null) {
            return "BASIC";
        }
        List<String> authorizationValues = new HttpHeadersImpl(this.m).getRequestHeader("Authorization");
        return authorizationValues.size() > 0 ? authorizationValues.get(0) : "Unknown scheme";
    }

    public Principal getUserPrincipal() {
        SecurityContext sc = (SecurityContext)this.m.get(SecurityContext.class);
        return sc == null ? null : sc.getUserPrincipal();
    }

    public boolean isSecure() {
        String value = HttpUtils.getEndpointAddress(this.m);
        return value.startsWith("https://");
    }

    public boolean isUserInRole(String role) {
        SecurityContext sc = (SecurityContext)this.m.get(SecurityContext.class);
        return sc == null ? false : sc.isUserInRole(role);
    }
}

