/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyImpl
extends AbstractClient
implements InvocationHandlerAware,
InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    private static final String SLASH = "/";
    private ClassResourceInfo cri;
    private boolean inheritHeaders;
    private boolean isRoot;
    private Map<String, Object> valuesMap;

    public ClientProxyImpl(URI baseURI, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(baseURI);
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
    }

    public ClientProxyImpl(ClientState initialState, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(initialState);
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
    }

    private void initValuesMap(Object ... varValues) {
        if (this.isRoot && varValues.length != 0) {
            this.valuesMap = new LinkedHashMap<String, Object>();
            List<String> vars = this.cri.getURITemplate().getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= varValues.length) {
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, new Object[]{vars.size(), varValues.length});
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put(vars.get(i), varValues[i]);
            }
        } else {
            this.valuesMap = Collections.emptyMap();
        }
    }

    @Override
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = ClientProxyImpl.getParametersInfo(ori);
        List<Object> pathParams = this.getPathParamValues(types, params, ori);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            this.addNonEmptyPath(builder, ori.getClassResourceInfo().getURITemplate().getValue());
        }
        this.addNonEmptyPath(builder, ori.getURITemplate().getValue());
        ClientProxyImpl.handleMatrixes(types, params, builder);
        ClientProxyImpl.handleQueries(types, params, builder);
        URI uri = builder.buildFromEncoded(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap<String, String> paramHeaders = new MetadataMap<String, String>();
        this.handleHeaders(paramHeaders, types, params);
        this.handleCookies(paramHeaders, types, params);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            MetadataMap<String, String> subHeaders = paramHeaders;
            if (this.inheritHeaders) {
                subHeaders.putAll((Map)headers);
            }
            ClientState newState = this.getState().newState(uri, subHeaders, this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
            ClientProxyImpl proxyImpl = new ClientProxyImpl(newState, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setConfiguration(this.getConfiguration());
            return JAXRSClientFactory.create(m.getReturnType(), proxyImpl);
        }
        headers.putAll(paramHeaders);
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), bodyIndex == -1 ? null : params[bodyIndex].getClass(), m.getReturnType());
        return this.doChainedInvocation(uri, headers, ori, params, bodyIndex, types, pathParams);
    }

    private void addNonEmptyPath(UriBuilder builder, String pathValue) {
        if (!SLASH.equals(pathValue)) {
            builder.path(pathValue);
        }
    }

    private static MultivaluedMap<ParameterType, Parameter> getParametersInfo(OperationResourceInfo ori) {
        MetadataMap<ParameterType, Parameter> map = new MetadataMap<ParameterType, Parameter>();
        List<Parameter> parameters = ori.getParameters();
        if (parameters.size() == 0) {
            return map;
        }
        for (Parameter p : parameters) {
            if (p.getType() == ParameterType.CONTEXT) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_CONTEXT_PARAMETERS");
            }
            map.add((Object)p.getType(), p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (((List)map.get((Object)ParameterType.REQUEST_BODY)).size() > 1) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "ONLY_FORM_ALLOWED");
            }
        }
        return map;
    }

    private static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        return index;
    }

    private void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        ServerWebApplicationException t = null;
        int status = r.getStatus();
        if (status >= 400) {
            if (m.getReturnType() == Response.class && m.getExceptionTypes().length == 0) {
                return;
            }
            ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(m, inMessage);
            if (mapper != null && (t = (ServerWebApplicationException)((Object)mapper.fromResponse(r))) != null) {
                throw t;
            }
            if (t == null) {
                t = new ServerWebApplicationException(r);
            }
            if (inMessage.getExchange().get((Object)Message.RESPONSE_CODE) == null) {
                throw t;
            }
            Endpoint ep = (Endpoint)inMessage.getExchange().get(Endpoint.class);
            inMessage.getExchange().put(InterceptorProvider.class, (Object)this.getConfiguration());
            inMessage.setContent(Exception.class, (Object)new Fault((Throwable)((Object)t)));
            inMessage.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(inMessage);
            }
            throw t;
        }
    }

    private static ResponseExceptionMapper<?> findExceptionMapper(Method m, Message message) {
        ProviderFactory pf = ProviderFactory.getInstance(message);
        for (Class<?> exType : m.getExceptionTypes()) {
            ResponseExceptionMapper mapper = pf.createResponseExceptionMapper(exType);
            if (mapper == null) continue;
            return mapper;
        }
        return null;
    }

    private MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<MediaType> accepts;
        if (headers.getFirst((Object)"Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            } else {
                String cType = bodyClass != null && InjectionUtils.isPrimitive(bodyClass) ? "text/plain" : (ori.getConsumeTypes().isEmpty() || ori.getConsumeTypes().get(0).equals((Object)MediaType.WILDCARD_TYPE) ? "application/xml" : ori.getConsumeTypes().get(0).toString());
                headers.putSingle((Object)"Content-Type", (Object)cType);
            }
        }
        if ((accepts = this.getAccept(headers)) == null) {
            boolean produceWildcard;
            boolean bl = produceWildcard = ori.getProduceTypes().size() == 0 || ori.getProduceTypes().get(0).equals((Object)MediaType.WILDCARD_TYPE);
            accepts = produceWildcard ? (InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : Collections.singletonList(MediaType.APPLICATION_XML_TYPE)) : (responseClass == Void.class ? Collections.singletonList(MediaType.WILDCARD_TYPE) : ori.getProduceTypes());
            for (MediaType mt : accepts) {
                headers.add((Object)"Accept", (Object)mt.toString());
            }
        }
        return headers;
    }

    private List<MediaType> getAccept(MultivaluedMap<String, String> allHeaders) {
        List headers = (List)allHeaders.get((Object)"Accept");
        if (headers == null || headers.size() == 0) {
            return null;
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String s : headers) {
            types.add(MediaType.valueOf((String)s));
        }
        return types;
    }

    private List<Object> getPathParamValues(MultivaluedMap<ParameterType, Parameter> map, Object[] params, OperationResourceInfo ori) {
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        List<String> vars = ori.getURITemplate().getVariables();
        block0: for (Parameter p : paramsList) {
            if (this.valuesMap.containsKey(p.getName()) && !vars.contains(p.getName())) {
                int index = 0;
                Iterator<String> it = this.valuesMap.keySet().iterator();
                while (it.hasNext()) {
                    if (it.next().equals(p.getName())) {
                        list.remove(index);
                        list.add(index, params[p.getIndex()]);
                        continue block0;
                    }
                    ++index;
                }
                continue;
            }
            String paramName = p.getName();
            if (!"".equals(paramName)) {
                list.add(params[p.getIndex()]);
                continue;
            }
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(params[p.getIndex()], "");
            for (String var : vars) {
                list.addAll((Collection)values.get((Object)var));
            }
        }
        return list;
    }

    private static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        return map.get((Object)key) == null ? Collections.EMPTY_LIST : (List)map.get((Object)key);
    }

    private static void handleQueries(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        for (Parameter p : qs) {
            if (params[p.getIndex()] == null) continue;
            ClientProxyImpl.addParametersToBuilder(ub, p.getName(), params[p.getIndex()], ParameterType.QUERY);
        }
    }

    private static void handleMatrixes(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        for (Parameter p : mx) {
            if (params[p.getIndex()] == null) continue;
            ClientProxyImpl.addParametersToBuilder(ub, p.getName(), params[p.getIndex()], ParameterType.MATRIX);
        }
    }

    private MultivaluedMap<String, String> handleForm(MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        MetadataMap<String, String> form = new MetadataMap<String, String>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        for (Parameter p : fm) {
            Object pValue = params[p.getIndex()];
            if (pValue == null) continue;
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    FormUtils.addPropertyToForm(form, p.getName(), it.next());
                }
                continue;
            }
            FormUtils.addPropertyToForm(form, p.getName(), pValue);
        }
        return form;
    }

    private void handleHeaders(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        for (Parameter p : hs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)p.getName(), (Object)params[p.getIndex()].toString());
        }
    }

    private void handleCookies(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        for (Parameter p : cs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)"Cookie", (Object)(p.getName() + '=' + params[p.getIndex()].toString()));
        }
    }

    private Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object[] params, int bodyIndex, MultivaluedMap<ParameterType, Parameter> types, List<Object> pathParams) throws Throwable {
        Message outMessage = this.createMessage(ori.getHttpMethod(), headers, uri);
        outMessage.getExchange().setOneWay(ori.isOneway());
        this.getState().setTemplates(this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
        outMessage.put((Object)"jaxrs.template.parameters", this.getState().getTemplates());
        outMessage.setContent(OperationResourceInfo.class, (Object)ori);
        this.setPlainOperationNameProperty(outMessage, ori.getMethodToInvoke().getName());
        outMessage.getExchange().put(Method.class, (Object)ori.getMethodToInvoke());
        boolean isForm = types.containsKey((Object)ParameterType.FORM);
        if (bodyIndex != -1 || isForm) {
            outMessage.put((Object)"BODY_INDEX", (Object)bodyIndex);
            MultivaluedMap<String, String> body = isForm ? this.handleForm(types, params) : params[bodyIndex];
            MessageContentsList contents = new MessageContentsList(new Object[]{body});
            outMessage.setContent(List.class, (Object)contents);
            outMessage.getInterceptorChain().add((Interceptor)new BodyWriter());
        } else {
            this.setEmptyRequestProperty(outMessage, ori.getHttpMethod());
        }
        try {
            outMessage.getInterceptorChain().doIntercept(outMessage);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        HttpURLConnection connect = (HttpURLConnection)outMessage.get((Object)"http.connection");
        return this.handleResponse(connect, outMessage, ori);
    }

    protected Object handleResponse(HttpURLConnection connect, Message outMessage, OperationResourceInfo ori) throws Throwable {
        Response r = this.setResponseBuilder(connect, outMessage.getExchange()).build();
        Method method = ori.getMethodToInvoke();
        this.checkResponse(method, r, outMessage);
        if (method.getReturnType() == Void.class) {
            return null;
        }
        if (method.getReturnType() == Response.class && (r.getEntity() == null || InputStream.class.isAssignableFrom(r.getEntity().getClass()) && ((InputStream)r.getEntity()).available() == 0)) {
            return r;
        }
        return this.readBody(r, outMessage, method.getReturnType(), method.getGenericReturnType(), method.getDeclaredAnnotations());
    }

    @Override
    public Object getInvocationHandler() {
        return this;
    }

    protected static void reportInvalidResourceMethod(Method m, String name) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, new Object[]{m.getDeclaringClass().getName(), m.getName()});
        LOG.severe(errorMsg.toString());
        throw new ClientWebApplicationException(errorMsg.toString());
    }

    private class BodyWriter
    extends AbstractOutDatabindingInterceptor {
        public BodyWriter() {
            super("write");
        }

        public void handleMessage(Message outMessage) throws Fault {
            OperationResourceInfo ori = (OperationResourceInfo)outMessage.getContent(OperationResourceInfo.class);
            OutputStream os = (OutputStream)outMessage.getContent(OutputStream.class);
            if (os == null && outMessage.getContent(XMLStreamWriter.class) == null || ori == null) {
                return;
            }
            MessageContentsList objs = MessageContentsList.getContentsList((Message)outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            MultivaluedMap headers = (MultivaluedMap)outMessage.get((Object)Message.PROTOCOL_HEADERS);
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)outMessage.get((Object)"BODY_INDEX");
            Method aMethod = ori.getAnnotatedMethod();
            Annotation[] anns = aMethod == null || bodyIndex == -1 ? new Annotation[]{} : aMethod.getParameterAnnotations()[bodyIndex];
            Object body = objs.get(0);
            try {
                if (bodyIndex != -1) {
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), method.getGenericParameterTypes()[bodyIndex], anns, (MultivaluedMap<String, String>)headers, os);
                } else {
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), body.getClass(), anns, (MultivaluedMap<String, String>)headers, os);
                }
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        }
    }
}

