/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.blueprint;

import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.blueprint.SimpleBPBeanDefinitionParser;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.blueprint.BlueprintResourceFactory;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.w3c.dom.Element;

public class JAXRSServerFactoryBeanDefinitionParser
extends SimpleBPBeanDefinitionParser {
    public JAXRSServerFactoryBeanDefinitionParser() {
        super(JAXRSServerFactoryBean.class);
    }

    protected void mapAttribute(MutableBeanMetadata bean, Element e, String name, String val, ParserContext context) {
        if ("beanNames".equals(name)) {
            String[] values = StringUtils.split((String)val, (String)" ");
            MutableCollectionMetadata tempFactories = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
            for (String v : values) {
                String theValue = v.trim();
                if (theValue.length() <= 0) continue;
                MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
                factory.setObject(new PassThroughCallable<BlueprintResourceFactory>(new BlueprintResourceFactory(v)));
                MutableBeanMetadata resourceBean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
                resourceBean.setRuntimeClass(BlueprintResourceFactory.class);
                resourceBean.setFactoryComponent((Target)factory);
                resourceBean.setFactoryMethod("call");
                resourceBean.setInitMethod("init");
                tempFactories.addValue((Metadata)resourceBean);
            }
            bean.addProperty("tempFactories", (Metadata)tempFactories);
        } else if ("serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addProperty(name, this.createValue(context, q));
        } else {
            this.mapToProperty(bean, name, val, context);
        }
    }

    protected void mapElement(ParserContext ctx, MutableBeanMetadata bean, Element el, String name) {
        if ("properties".equals(name) || "extensionMappings".equals(name) || "languageMappings".equals(name)) {
            bean.addProperty(name, this.parseMapData(ctx, (ComponentMetadata)bean, el));
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            bean.addProperty(name, this.parseListData(ctx, (ComponentMetadata)bean, el));
        } else if ("features".equals(name) || "schemaLocations".equals(name) || "providers".equals(name) || "serviceBeans".equals(name) || "modelBeans".equals(name)) {
            bean.addProperty(name, this.parseListData(ctx, (ComponentMetadata)bean, el));
        } else if ("serviceFactories".equals(name)) {
            bean.addProperty("resourceProviders", this.parseListData(ctx, (ComponentMetadata)bean, el));
        } else if ("model".equals(name)) {
            List<UserResource> resources = ResourceUtils.getResourcesFromElement(el);
            MutableCollectionMetadata list = (MutableCollectionMetadata)ctx.createMetadata(MutableCollectionMetadata.class);
            list.setCollectionClass(List.class);
            for (UserResource res : resources) {
                MutablePassThroughMetadata factory = (MutablePassThroughMetadata)ctx.createMetadata(MutablePassThroughMetadata.class);
                factory.setObject(new PassThroughCallable<UserResource>(res));
                MutableBeanMetadata resourceBean = (MutableBeanMetadata)ctx.createMetadata(MutableBeanMetadata.class);
                resourceBean.setFactoryComponent((Target)factory);
                resourceBean.setFactoryMethod("call");
                list.addValue((Metadata)resourceBean);
            }
            bean.addProperty("modelBeans", (Metadata)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    public Metadata parse(Element element, ParserContext context) {
        MutableBeanMetadata bean = (MutableBeanMetadata)super.parse(element, context);
        bean.setInitMethod("init");
        bean.setActivation(1);
        return bean;
    }

    protected boolean hasBusProperty() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

