/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private String scheme;
    private String userInfo;
    private int port = -1;
    private String host;
    private List<PathSegment> paths = new ArrayList<PathSegment>();
    private boolean leadingSlash;
    private String fragment;
    private String schemeSpecificPart;
    private MultivaluedMap<String, String> query = new MetadataMap<String, String>();
    private MultivaluedMap<String, String> matrix = new MetadataMap<String, String>();

    public UriBuilderImpl() {
    }

    public UriBuilderImpl(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.doBuild(false, values);
    }

    private URI doBuild(boolean fromEncoded, Object ... values) {
        URITemplate fragmentTempl;
        String theFragment;
        URITemplate queryTempl;
        if (values == null) {
            throw new IllegalArgumentException("Template parameter values are set to null");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new IllegalArgumentException("Template parameter value is set to null");
        }
        String thePath = this.buildPath();
        URITemplate pathTempl = new URITemplate(thePath);
        thePath = this.substituteVarargs(pathTempl, values, 0, false, fromEncoded);
        String theQuery = this.buildQuery();
        int queryTemplateVarsSize = 0;
        if (theQuery != null && (queryTemplateVarsSize = (queryTempl = new URITemplate(theQuery)).getVariables().size()) > 0) {
            int lengthDiff = values.length - pathTempl.getVariables().size();
            queryTemplateVarsSize = queryTempl.getVariables().size();
            theQuery = this.substituteVarargs(queryTempl, values, values.length - lengthDiff, true, fromEncoded);
        }
        if ((theFragment = this.fragment) != null && (fragmentTempl = new URITemplate(theFragment)).getVariables().size() > 0) {
            int lengthDiff = values.length - pathTempl.getVariables().size() - queryTemplateVarsSize;
            theFragment = this.substituteVarargs(fragmentTempl, values, values.length - lengthDiff, true, fromEncoded);
        }
        try {
            return this.buildURI(fromEncoded, thePath, theQuery, theFragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private URI buildURI(boolean fromEncoded, String thePath, String theQuery, String theFragment) throws URISyntaxException {
        if (fromEncoded) {
            return this.buildURIFromEncoded(thePath, theQuery, theFragment);
        }
        if (!this.isSchemeOpaque()) {
            if (!(this.scheme == null && this.host == null && this.userInfo == null || thePath.length() == 0 || thePath.startsWith("/"))) {
                thePath = "/" + thePath;
            }
            try {
                return this.buildURIFromEncoded(thePath, theQuery, theFragment);
            }
            catch (Exception ex) {
                URI uri = new URI(this.scheme, this.userInfo, this.host, this.port, thePath, theQuery, theFragment);
                if (thePath.contains("%2F")) {
                    String realPath = uri.getRawPath().replace("%252F", "%2F");
                    uri = this.buildURIFromEncoded(realPath, uri.getRawQuery(), uri.getRawFragment());
                }
                return uri;
            }
        }
        return new URI(this.scheme, this.schemeSpecificPart, theFragment);
    }

    private URI buildURIFromEncoded(String thePath, String theQuery, String theFragment) throws URISyntaxException {
        StringBuilder b = new StringBuilder();
        if (this.scheme != null) {
            b.append(this.scheme).append(":");
        }
        if (!this.isSchemeOpaque()) {
            if (this.scheme != null) {
                b.append("//");
            }
            if (this.userInfo != null) {
                b.append(this.userInfo).append('@');
            }
            if (this.host != null) {
                b.append(this.host);
            }
            if (this.port != -1) {
                b.append(':').append(this.port);
            }
            if (thePath != null && thePath.length() > 0) {
                b.append(thePath.startsWith("/") || b.length() == 0 ? thePath : '/' + thePath);
            }
            if (theQuery != null && theQuery.length() != 0) {
                b.append('?').append(theQuery);
            }
        } else {
            b.append(this.schemeSpecificPart);
        }
        if (theFragment != null) {
            b.append('#').append(theFragment);
        }
        return new URI(b.toString());
    }

    private boolean isSchemeOpaque() {
        return this.schemeSpecificPart != null;
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.doBuild(true, values);
    }

    public URI buildFromMap(Map<String, ? extends Object> map) throws IllegalArgumentException, UriBuilderException {
        return this.doBuildFromMap(map, false);
    }

    private URI doBuildFromMap(Map<String, ? extends Object> map, boolean fromEncoded) throws IllegalArgumentException, UriBuilderException {
        try {
            String thePath = this.buildPath();
            thePath = this.substituteMapped(thePath, map, false, fromEncoded);
            String theQuery = this.buildQuery();
            if (theQuery != null) {
                theQuery = this.substituteMapped(theQuery, map, true, fromEncoded);
            }
            String theFragment = this.fragment == null ? null : this.substituteMapped(this.fragment, map, true, fromEncoded);
            return this.buildURI(fromEncoded, thePath, theQuery, theFragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private String substituteVarargs(URITemplate templ, Object[] values, int ind, boolean isQuery, boolean fromEncoded) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        LinkedHashSet<String> uniqueVars = new LinkedHashSet<String>(templ.getVariables());
        if (values.length < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + values.length + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        int idx = ind;
        for (String var : uniqueVars) {
            Object oval;
            if ((oval = values[idx++]) == null) {
                throw new IllegalArgumentException("No object for " + var);
            }
            String value = oval.toString();
            value = fromEncoded ? HttpUtils.encodePartiallyEncoded(value, isQuery) : (isQuery ? HttpUtils.queryEncode(value) : HttpUtils.pathEncode(value));
            varValueMap.put(var, value);
        }
        return templ.substitute(varValueMap);
    }

    private String substituteMapped(String path, Map<String, ? extends Object> varValueMap, boolean isQuery, boolean fromEncoded) {
        URITemplate templ = new URITemplate(path);
        HashSet<String> uniqueVars = new HashSet<String>(templ.getVariables());
        if (varValueMap.size() < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + varValueMap.size() + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        LinkedHashMap<String, Object> theMap = new LinkedHashMap<String, Object>();
        for (String var : uniqueVars) {
            Object oval = varValueMap.get(var);
            if (oval == null) {
                throw new IllegalArgumentException("No object for " + var);
            }
            oval = fromEncoded ? HttpUtils.encodePartiallyEncoded(oval.toString(), isQuery) : (isQuery ? HttpUtils.queryEncode(oval.toString()) : HttpUtils.pathEncode(oval.toString()));
            theMap.put(var, oval);
        }
        return templ.substitute(theMap);
    }

    public URI buildFromEncodedMap(Map<String, ? extends Object> map) throws IllegalArgumentException, UriBuilderException {
        HashMap<String, String> decodedMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Value is null");
            }
            String theValue = entry.getValue().toString();
            if (theValue.contains("/")) {
                StringBuilder buf = new StringBuilder();
                String[] values = StringUtils.split((String)theValue, (String)"/");
                for (int i = 0; i < values.length; ++i) {
                    buf.append(HttpUtils.encodePartiallyEncoded(values[i], false));
                    if (i + 1 >= values.length) continue;
                    buf.append("/");
                }
                decodedMap.put(entry.getKey(), buf.toString());
                continue;
            }
            decodedMap.put(entry.getKey(), HttpUtils.encodePartiallyEncoded(theValue, false));
        }
        return this.doBuildFromMap(decodedMap, true);
    }

    public UriBuilder clone() {
        UriBuilderImpl builder = new UriBuilderImpl();
        builder.scheme = this.scheme;
        builder.userInfo = this.userInfo;
        builder.port = this.port;
        builder.host = this.host;
        builder.paths = new ArrayList<PathSegment>(this.paths);
        builder.fragment = this.fragment;
        builder.query = new MetadataMap<String, String>((Map<String, List<String>>)this.query);
        builder.matrix = new MetadataMap<String, String>((Map<String, List<String>>)this.matrix);
        builder.schemeSpecificPart = this.schemeSpecificPart;
        builder.leadingSlash = this.leadingSlash;
        return builder;
    }

    public UriBuilder fragment(String theFragment) throws IllegalArgumentException {
        this.fragment = theFragment;
        return this;
    }

    public UriBuilder host(String theHost) throws IllegalArgumentException {
        if ("".equals(theHost)) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        this.host = theHost;
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        Class cls = resource;
        Path ann = cls.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Class '" + resource.getCanonicalName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path foundAnn = null;
        for (Method meth : resource.getMethods()) {
            if (!meth.getName().equals(method)) continue;
            Path ann = meth.getAnnotation(Path.class);
            if (foundAnn != null && ann != null) {
                throw new IllegalArgumentException("Multiple Path annotations for '" + method + "' overloaded method");
            }
            foundAnn = ann;
        }
        if (foundAnn == null) {
            throw new IllegalArgumentException("No Path annotation for '" + method + "' method");
        }
        return this.path(foundAnn.value());
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path ann = method.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Method '" + method.getClass().getCanonicalName() + "." + method.getName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(String path) throws IllegalArgumentException {
        return this.doPath(path, true);
    }

    private UriBuilder doPath(String path, boolean checkSegments) {
        List<Object> segments;
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (this.isAbsoluteUriPath(path)) {
            this.uri(URI.create(path));
            return this;
        }
        if (this.paths.isEmpty()) {
            this.leadingSlash = path.startsWith("/");
        }
        if (checkSegments) {
            segments = JAXRSUtils.getPathSegments(path, false, false);
        } else {
            segments = new ArrayList();
            segments.add(new PathSegmentImpl(path.replaceAll("/", "%2F"), false));
        }
        if (!this.paths.isEmpty() && !this.matrix.isEmpty()) {
            PathSegment ps = this.paths.remove(this.paths.size() - 1);
            this.paths.add(this.replacePathSegment(ps));
        }
        this.paths.addAll(segments);
        this.matrix.clear();
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        }
        return this;
    }

    public UriBuilder port(int thePort) throws IllegalArgumentException {
        if (thePort < 0 && thePort != -1) {
            throw new IllegalArgumentException("Port cannot be negative");
        }
        this.port = thePort;
        return this;
    }

    public UriBuilder scheme(String s) throws IllegalArgumentException {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        try {
            if (this.scheme == null) {
                this.scheme = "http";
            }
            URI uri = new URI(this.scheme, ssp, this.fragment);
            this.setUriParts(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Wrong syntax of scheme-specific part", e);
        }
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
        return this;
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    private void setUriParts(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        String theScheme = uri.getScheme();
        if (theScheme != null) {
            this.scheme = theScheme;
        }
        String rawPath = uri.getRawPath();
        if (!uri.isOpaque() && (theScheme != null || rawPath != null && rawPath.startsWith("/"))) {
            String rawQuery;
            this.port = uri.getPort();
            this.host = uri.getHost();
            if (rawPath != null) {
                this.setPathAndMatrix(uri.getRawPath());
            }
            if ((rawQuery = uri.getRawQuery()) != null) {
                this.query = JAXRSUtils.getStructuredParams(rawQuery, "&", false, false);
            }
            this.userInfo = uri.getUserInfo();
            this.schemeSpecificPart = null;
        } else {
            this.schemeSpecificPart = uri.getSchemeSpecificPart();
        }
        String theFragment = uri.getFragment();
        if (theFragment != null) {
            this.fragment = theFragment;
        }
    }

    private void setPathAndMatrix(String path) {
        this.leadingSlash = path.startsWith("/");
        this.paths = JAXRSUtils.getPathSegments(path, false, false);
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        } else {
            this.matrix.clear();
        }
    }

    private String buildPath() {
        StringBuilder sb = new StringBuilder();
        Iterator<PathSegment> iter = this.paths.iterator();
        while (iter.hasNext()) {
            PathSegment ps = iter.next();
            String p = ps.getPath();
            if (p.length() == 0 && iter.hasNext()) continue;
            p = new URITemplate(p).encodeLiteralCharacters(false);
            if (sb.length() == 0 && this.leadingSlash) {
                sb.append('/');
            } else if (!p.startsWith("/") && sb.length() > 0) {
                sb.append('/');
            }
            sb.append(p);
            if (!iter.hasNext()) continue;
            this.buildMatrix(sb, (MultivaluedMap<String, String>)ps.getMatrixParameters());
        }
        this.buildMatrix(sb, this.matrix);
        return sb.toString();
    }

    private String buildQuery() {
        return this.buildParams(this.query, '&');
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null || values == null) {
            throw new IllegalArgumentException("name or values is null");
        }
        List list = (List)this.matrix.get((Object)name);
        if (list == null) {
            this.matrix.put((Object)name, this.toStringList(values));
        } else {
            list.addAll(this.toStringList(values));
        }
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null || values == null) {
            throw new IllegalArgumentException("name or values is null");
        }
        List list = (List)this.query.get((Object)name);
        if (list == null) {
            this.query.put((Object)name, this.toStringList(values));
        } else {
            list.addAll(this.toStringList(values));
        }
        return this;
    }

    public UriBuilder replaceMatrix(String matrixValues) throws IllegalArgumentException {
        this.matrix = JAXRSUtils.getStructuredParams(matrixValues, ";", true, false);
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values != null && values.length >= 1 && values[0] != null) {
            this.matrix.put((Object)name, this.toStringList(values));
        } else {
            this.matrix.remove((Object)name);
        }
        return this;
    }

    public UriBuilder replacePath(String path) {
        if (path == null) {
            this.clearPathAndMatrix();
        } else if (this.isAbsoluteUriPath(path)) {
            this.clearPathAndMatrix();
            this.uri(URI.create(path));
        } else {
            this.setPathAndMatrix(path);
        }
        return this;
    }

    private void clearPathAndMatrix() {
        this.paths.clear();
        this.matrix.clear();
    }

    private boolean isAbsoluteUriPath(String path) {
        return path.startsWith("http:") || path.startsWith("https:");
    }

    public UriBuilder replaceQuery(String queryValue) throws IllegalArgumentException {
        if (queryValue != null) {
            queryValue = queryValue.replace(" ", "%20");
        }
        this.query = JAXRSUtils.getStructuredParams(queryValue, "&", false, true);
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values != null && values.length >= 1 && values[0] != null) {
            this.query.put((Object)name, this.toStringList(values));
        } else {
            this.query.remove((Object)name);
        }
        return this;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("Segments should not be null");
        }
        for (String segment : segments) {
            this.doPath(segment, false);
        }
        return this;
    }

    private List<String> toStringList(Object ... values) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value == null) {
                    throw new IllegalArgumentException("Null value on " + i + " position");
                }
                list.add(value.toString());
            }
        }
        if (list.isEmpty()) {
            list.add("");
        }
        return list;
    }

    private String buildParams(MultivaluedMap<String, String> map, char separator) {
        boolean isQuery = separator == '&';
        StringBuilder b = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Iterator sit = ((List)entry.getValue()).iterator();
            while (sit.hasNext()) {
                String val = (String)sit.next();
                boolean templateValue = val.startsWith("{") && val.endsWith("}");
                val = !templateValue ? HttpUtils.encodePartiallyEncoded(val, isQuery) : new URITemplate(val).encodeLiteralCharacters(isQuery);
                b.append((String)entry.getKey());
                if (val.length() != 0) {
                    b.append('=').append(val);
                }
                if (!sit.hasNext() && !it.hasNext()) continue;
                b.append(separator);
            }
        }
        return b.length() > 0 ? b.toString() : null;
    }

    private void buildMatrix(StringBuilder sb, MultivaluedMap<String, String> map) {
        if (!map.isEmpty()) {
            sb.append(';');
            sb.append(this.buildParams(map, ';'));
        }
    }

    private PathSegment replacePathSegment(PathSegment ps) {
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        this.buildMatrix(sb, this.matrix);
        return new PathSegmentImpl(sb.toString());
    }

    public UriBuilder uriAsTemplate(String uri) {
        int index = uri.indexOf(":");
        if (index != -1) {
            this.scheme = uri.substring(0, index);
            if ((uri = uri.substring(index + 1)).indexOf("//") == 0) {
                index = (uri = uri.substring(2)).indexOf("/");
                if (index != -1) {
                    String[] schemePair = uri.substring(0, index).split(":");
                    this.host = schemePair[0];
                    this.port = schemePair.length == 2 ? Integer.valueOf(schemePair[1]) : -1;
                }
                uri = uri.substring(index);
            }
        }
        this.setPathAndMatrix(uri);
        return this;
    }
}

