/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonProducer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonProducer.class);
    private boolean supportFlattened;
    private String plainPayload;
    private String encodedPayload;
    private List<JwsJsonSignatureEntry> signatures = new LinkedList<JwsJsonSignatureEntry>();
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();

    public JwsJsonProducer(String tbsDocument) {
        this(tbsDocument, false);
    }

    public JwsJsonProducer(String tbsDocument, boolean supportFlattened) {
        this.supportFlattened = supportFlattened;
        this.plainPayload = tbsDocument;
    }

    public String getPlainPayload() {
        return this.plainPayload;
    }

    public String getUnsignedEncodedPayload() {
        if (this.encodedPayload == null) {
            this.encodedPayload = Base64UrlUtility.encode((String)this.getPlainPayload());
        }
        return this.encodedPayload;
    }

    public String getJwsJsonSignedDocument() {
        return this.getJwsJsonSignedDocument(false);
    }

    public String getJwsJsonSignedDocument(boolean detached) {
        if (this.signatures.isEmpty()) {
            return null;
        }
        Boolean b64Status = JwsJsonProducer.validateB64Status(this.signatures);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!detached) {
            sb.append("\"payload\":\"" + this.getActualPayload(b64Status) + "\"");
            sb.append(",");
        }
        if (!this.supportFlattened || this.signatures.size() > 1) {
            sb.append("\"signatures\":[");
            for (int i = 0; i < this.signatures.size(); ++i) {
                JwsJsonSignatureEntry signature = this.signatures.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(signature.toJson());
            }
            sb.append("]");
        } else {
            sb.append(this.signatures.get(0).toJson(true));
        }
        sb.append("}");
        return sb.toString();
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return this.signatures;
    }

    public String signWith(List<JwsSignatureProvider> signers) {
        for (JwsSignatureProvider signer : signers) {
            this.signWith(signer);
        }
        return this.getJwsJsonSignedDocument();
    }

    public String signWith(JwsSignatureProvider signer) {
        JwsHeaders headers = new JwsHeaders();
        headers.setSignatureAlgorithm(signer.getAlgorithm());
        return this.signWith(signer, headers);
    }

    public String signWith(JwsSignatureProvider signer, JwsHeaders protectedHeader) {
        return this.signWith(signer, protectedHeader, null);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk));
    }

    public String signWith(PrivateKey key, SignatureAlgorithm algo) {
        return this.signWith(JwsUtils.getPrivateKeySignatureProvider(key, algo));
    }

    public String signWith(byte[] key, SignatureAlgorithm algo) {
        return this.signWith(JwsUtils.getHmacSignatureProvider(key, algo));
    }

    public String signWith(JwsSignatureProvider signer, JwsHeaders protectedHeader, JwsHeaders unprotectedHeader) {
        JwsHeaders unionHeaders = new JwsHeaders();
        if (protectedHeader != null) {
            unionHeaders.asMap().putAll(protectedHeader.asMap());
        }
        if (unprotectedHeader != null) {
            JwsJsonProducer.checkUnprotectedHeaders(unprotectedHeader, "crit", "b64");
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), unprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            unionHeaders.asMap().putAll(unprotectedHeader.asMap());
        }
        if (unionHeaders.getSignatureAlgorithm() == null) {
            LOG.warning("Algorithm header is not set");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        String actualPayload = protectedHeader != null ? this.getActualPayload(protectedHeader.getPayloadEncodingStatus()) : this.getUnsignedEncodedPayload();
        String sequenceToBeSigned = protectedHeader != null ? Base64UrlUtility.encode((String)this.writer.toJson((JsonMapObject)protectedHeader)) + "." + actualPayload : "." + this.getUnsignedEncodedPayload();
        byte[] bytesToBeSigned = StringUtils.toBytesUTF8((String)sequenceToBeSigned);
        byte[] signatureBytes = signer.sign(unionHeaders, bytesToBeSigned);
        String encodedSignatureBytes = Base64UrlUtility.encode((byte[])signatureBytes);
        JwsJsonSignatureEntry signature = protectedHeader != null ? new JwsJsonSignatureEntry(actualPayload, Base64UrlUtility.encode((String)this.writer.toJson((JsonMapObject)protectedHeader)), encodedSignatureBytes, unprotectedHeader) : new JwsJsonSignatureEntry(this.getUnsignedEncodedPayload(), null, encodedSignatureBytes, unprotectedHeader);
        return this.updateJwsJsonSignedDocument(signature);
    }

    private String getActualPayload(Boolean payloadEncodingStatus) {
        return Boolean.FALSE == payloadEncodingStatus ? this.getPlainPayload() : this.getUnsignedEncodedPayload();
    }

    private String updateJwsJsonSignedDocument(JwsJsonSignatureEntry signature) {
        this.signatures.add(signature);
        return this.getJwsJsonSignedDocument();
    }

    private static void checkUnprotectedHeaders(JoseHeaders unprotected, String ... headerNames) {
        for (String headerName : headerNames) {
            if (!unprotected.containsHeader(headerName)) continue;
            LOG.warning("Unprotected headers contain a header \"" + headerName + "\" which must be protected");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
    }

    static Boolean validateB64Status(List<JwsJsonSignatureEntry> signatures) {
        LinkedHashSet<Boolean> b64Set = new LinkedHashSet<Boolean>();
        for (JwsJsonSignatureEntry entry : signatures) {
            Boolean status;
            JwsHeaders headers = entry.getProtectedHeader();
            Boolean bl = status = headers != null ? headers.getPayloadEncodingStatus() : null;
            if (status == null) {
                status = Boolean.TRUE;
            }
            b64Set.add(status);
        }
        if (b64Set.size() > 1) {
            LOG.warning("Each signature entry can sign only encoded or only unencoded payload");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        return (Boolean)b64Set.iterator().next();
    }
}

