/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;

public class JwsInputStream
extends FilterInputStream {
    private JwsVerificationSignature signature;
    private byte[] signatureBytes;
    private boolean verifyOnLastRead;

    public JwsInputStream(InputStream out, JwsVerificationSignature signature, byte[] signatureBytes, boolean verifyOnLastRead) {
        super(out);
        this.signature = signature;
        this.signatureBytes = signatureBytes;
        this.verifyOnLastRead = verifyOnLastRead;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value != -1) {
            byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
            this.signature.update(bytes, 0, bytes.length);
        } else {
            this.verify();
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int num = this.in.read(b, off, len);
        if (num != -1) {
            this.signature.update(b, off, num);
        } else {
            this.verify();
        }
        return num;
    }

    private void verify() {
        if (this.verifyOnLastRead && !this.signature.verify(this.signatureBytes)) {
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
    }
}

