/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwa;

import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;

public enum KeyAlgorithm {
    RSA_OAEP("RSA-OAEP", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", -1),
    RSA_OAEP_256("RSA-OAEP-256", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", -1),
    RSA1_5("RSA1_5", "RSA/ECB/PKCS1Padding", -1),
    A128KW("A128KW", "AESWrap", 128),
    A192KW("A192KW", "AESWrap", 192),
    A256KW("A256KW", "AESWrap", 256),
    A128GCMKW("A128GCMKW", "AES/GCM/NoPadding", 128),
    A192GCMKW("A192GCMKW", "AES/GCM/NoPadding", 192),
    A256GCMKW("A256GCMKW", "AES/GCM/NoPadding", 256),
    PBES2_HS256_A128KW("PBES2-HS256+A128KW", "AESWrap", 128),
    PBES2_HS384_A192KW("PBES2-HS384+A192KW", "AESWrap", 192),
    PBES2_HS512_A256KW("PBES2-HS512+A256KW", "AESWrap", 256),
    ECDH_ES_A128KW("ECDH-ES+A128KW", "AESWrap", 128),
    ECDH_ES_A192KW("ECDH-ES+A192KW", "AESWrap", 192),
    ECDH_ES_A256KW("ECDH-ES+A256KW", "AESWrap", 256),
    ECDH_ES_DIRECT("ECDH-ES", null, -1);

    private final String jwaName;
    private final String javaName;
    private final int keySizeBits;

    private KeyAlgorithm(String jwaName, String javaName, int keySizeBits) {
        this.jwaName = jwaName;
        this.javaName = javaName;
        this.keySizeBits = keySizeBits;
    }

    public String getJwaName() {
        return this.jwaName;
    }

    public String getJavaName() {
        return this.javaName == null ? this.name() : this.javaName;
    }

    public String getJavaAlgoName() {
        return AlgorithmUtils.stripAlgoProperties(this.getJavaName());
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public static KeyAlgorithm getAlgorithm(String algo) {
        if (algo == null) {
            return null;
        }
        return KeyAlgorithm.valueOf(algo.replace('-', '_').replace('+', '_'));
    }
}

