/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.EcdhAesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.EcdhAesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public final class JweUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JweUtils.class);
    private static final String JSON_WEB_ENCRYPTION_CEK_ALGO_PROP = "rs.security.jwe.content.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_KEY_ALGO_PROP = "rs.security.jwe.key.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP = "rs.security.jwe.zip.algorithm";
    private static final String RSSEC_ENCRYPTION_OUT_PROPS = "rs.security.encryption.out.properties";
    private static final String RSSEC_ENCRYPTION_IN_PROPS = "rs.security.encryption.in.properties";
    private static final String RSSEC_ENCRYPTION_PROPS = "rs.security.encryption.properties";
    private static final String RSSEC_ENCRYPTION_REPORT_KEY_PROP = "rs.security.jwe.report.public.key";
    private static final String RSSEC_ENCRYPTION_REPORT_KEY_ID_PROP = "rs.security.jwe.report.public.key.id";

    private JweUtils() {
    }

    public static String encrypt(RSAPublicKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(RSAPublicKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, byte[] content, String ct) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getRSAKeyEncryptionProvider(key, keyAlgo);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encrypt(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, byte[] content, String ct) {
        if (keyAlgo != null) {
            KeyEncryptionProvider keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
            return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
        }
        return JweUtils.encryptDirect(key, contentAlgo, content, ct);
    }

    public static String encrypt(JsonWebKey key, ContentAlgorithm contentAlgo, byte[] content, String ct) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getKeyEncryptionProvider(key);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encryptDirect(SecretKey key, ContentAlgorithm contentAlgo, byte[] content) {
        return JweUtils.encryptDirect(key, contentAlgo, content, null);
    }

    public static String encryptDirect(SecretKey key, ContentAlgorithm contentAlgo, byte[] content, String ct) {
        JweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key, contentAlgo);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static String encryptDirect(JsonWebKey key, byte[] content, String ct) {
        JweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static byte[] decrypt(PrivateKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getPrivateKeyDecryptionAlgorithm(key, keyAlgo);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decrypt(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo, String content) {
        if (keyAlgo != null) {
            KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo);
            return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
        }
        return JweUtils.decryptDirect(key, contentAlgo, content);
    }

    public static byte[] decrypt(JsonWebKey key, ContentAlgorithm contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(key);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decryptDirect(SecretKey key, ContentAlgorithm contentAlgo, String content) {
        JweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    public static byte[] decryptDirect(JsonWebKey key, String content) {
        JweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key);
        return jwe.decrypt(content).getContent();
    }

    public static KeyEncryptionProvider getKeyEncryptionProvider(JsonWebKey jwk) {
        return JweUtils.getKeyEncryptionProvider(jwk, null);
    }

    public static KeyEncryptionProvider getKeyEncryptionProvider(JsonWebKey jwk, KeyAlgorithm defaultAlgorithm) {
        KeyAlgorithm keyAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : KeyAlgorithm.getAlgorithm(jwk.getAlgorithm());
        KeyEncryptionProvider keyEncryptionProvider = null;
        KeyType keyType = jwk.getKeyType();
        keyEncryptionProvider = KeyType.RSA == keyType ? JweUtils.getRSAKeyEncryptionProvider(JwkUtils.toRSAPublicKey(jwk, true), keyAlgo) : (KeyType.OCTET == keyType ? JweUtils.getSecretKeyEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyAlgo) : new EcdhAesWrapKeyEncryptionAlgorithm(JwkUtils.toECPublicKey(jwk), jwk.getStringProperty("crv"), keyAlgo));
        return keyEncryptionProvider;
    }

    public static KeyEncryptionProvider getRSAKeyEncryptionProvider(RSAPublicKey key, KeyAlgorithm algo) {
        return new RSAKeyEncryptionAlgorithm(key, algo);
    }

    public static KeyEncryptionProvider getSecretKeyEncryptionAlgorithm(SecretKey key, KeyAlgorithm algo) {
        if (AlgorithmUtils.isAesKeyWrap(algo.getJwaName())) {
            return new AesWrapKeyEncryptionAlgorithm(key, algo);
        }
        if (AlgorithmUtils.isAesGcmKeyWrap(algo.getJwaName())) {
            return new AesGcmWrapKeyEncryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyDecryptionAlgorithm(jwk, null);
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk, KeyAlgorithm defaultAlgorithm) {
        KeyAlgorithm keyAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : KeyAlgorithm.getAlgorithm(jwk.getAlgorithm());
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        KeyType keyType = jwk.getKeyType();
        keyDecryptionProvider = KeyType.RSA == keyType ? JweUtils.getPrivateKeyDecryptionAlgorithm(JwkUtils.toRSAPrivateKey(jwk), keyAlgo) : (KeyType.OCTET == keyType ? JweUtils.getSecretKeyDecryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyAlgo) : JweUtils.getPrivateKeyDecryptionAlgorithm(JwkUtils.toECPrivateKey(jwk), keyAlgo));
        return keyDecryptionProvider;
    }

    public static KeyDecryptionAlgorithm getPrivateKeyDecryptionAlgorithm(PrivateKey key, KeyAlgorithm algo) {
        if (key instanceof RSAPrivateKey) {
            return new RSAKeyDecryptionAlgorithm((RSAPrivateKey)key, algo);
        }
        return new EcdhAesWrapKeyDecryptionAlgorithm((ECPrivateKey)key, algo);
    }

    public static KeyDecryptionAlgorithm getSecretKeyDecryptionAlgorithm(SecretKey key, KeyAlgorithm algo) {
        if (AlgorithmUtils.isAesKeyWrap(algo.getJwaName())) {
            return new AesWrapKeyDecryptionAlgorithm(key, algo);
        }
        if (AlgorithmUtils.isAesGcmKeyWrap(algo.getJwaName())) {
            return new AesGcmWrapKeyDecryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static ContentEncryptionProvider getContentEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getContentEncryptionAlgorithm(jwk, null);
    }

    public static ContentEncryptionProvider getContentEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        ContentEncryptionProvider contentEncryptionProvider = null;
        KeyType keyType = jwk.getKeyType();
        if (KeyType.OCTET == keyType) {
            return JweUtils.getContentEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), JweUtils.getContentAlgo(ctEncryptionAlgo));
        }
        return contentEncryptionProvider;
    }

    public static ContentEncryptionProvider getContentEncryptionAlgorithm(SecretKey key, ContentAlgorithm algorithm) {
        if (AlgorithmUtils.isAesGcm(algorithm.getJwaName())) {
            return new AesGcmContentEncryptionAlgorithm(key, null, algorithm);
        }
        return null;
    }

    public static ContentEncryptionProvider getContentEncryptionAlgorithm(String algorithm) {
        if (AlgorithmUtils.isAesGcm(algorithm)) {
            return new AesGcmContentEncryptionAlgorithm(JweUtils.getContentAlgo(algorithm));
        }
        return null;
    }

    public static ContentDecryptionAlgorithm getContentDecryptionAlgorithm(ContentAlgorithm algorithm) {
        if (AlgorithmUtils.isAesGcm(algorithm.getJwaName())) {
            return new AesGcmContentDecryptionAlgorithm(algorithm);
        }
        return null;
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk) {
        return JweUtils.getContentDecryptionSecretKey(jwk, null);
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        KeyType keyType = jwk.getKeyType();
        if (KeyType.OCTET == keyType && AlgorithmUtils.isAesGcm(ctEncryptionAlgo)) {
            return JwkUtils.toSecretKey(jwk);
        }
        return null;
    }

    private static ContentAlgorithm getContentAlgo(String algo) {
        return ContentAlgorithm.getAlgorithm(algo);
    }

    public static JweEncryption getDirectKeyJweEncryption(JsonWebKey key) {
        return JweUtils.getDirectKeyJweEncryption(JwkUtils.toSecretKey(key), JweUtils.getContentAlgo(key.getAlgorithm()));
    }

    public static JweEncryption getDirectKeyJweEncryption(SecretKey key, ContentAlgorithm algo) {
        if (AlgorithmUtils.isAesCbcHmac(algo.getJwaName())) {
            return new AesCbcHmacJweEncryption(algo, key.getEncoded(), null, new DirectKeyEncryptionAlgorithm());
        }
        return new JweEncryption(new DirectKeyEncryptionAlgorithm(), JweUtils.getContentEncryptionAlgorithm(key, algo));
    }

    public static JweDecryption getDirectKeyJweDecryption(JsonWebKey key) {
        return JweUtils.getDirectKeyJweDecryption(JwkUtils.toSecretKey(key), JweUtils.getContentAlgo(key.getAlgorithm()));
    }

    public static JweDecryption getDirectKeyJweDecryption(SecretKey key, ContentAlgorithm algorithm) {
        if (AlgorithmUtils.isAesCbcHmac(algorithm.getJwaName())) {
            return new AesCbcHmacJweDecryption((KeyDecryptionAlgorithm)new DirectKeyDecryptionAlgorithm(key), algorithm);
        }
        return new JweDecryption(new DirectKeyDecryptionAlgorithm(key), JweUtils.getContentDecryptionAlgorithm(algorithm));
    }

    public static JweEncryptionProvider loadEncryptionProvider(boolean required) {
        return JweUtils.loadEncryptionProvider(null, required);
    }

    public static JweEncryptionProvider loadEncryptionProvider(JweHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_ENCRYPTION_OUT_PROPS, RSSEC_ENCRYPTION_PROPS);
        if (props == null) {
            return null;
        }
        boolean reportPublicKey = headers != null && MessageUtils.isTrue((Object)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_REPORT_KEY_PROP, (String)"rs.security.report.public.key"));
        boolean reportPublicKeyId = headers != null && MessageUtils.isTrue((Object)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_REPORT_KEY_ID_PROP, (String)"rs.security.report.public.key.id"));
        KeyEncryptionProvider keyEncryptionProvider = null;
        String keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, null, null);
        KeyAlgorithm keyAlgo = KeyAlgorithm.getAlgorithm(keyEncryptionAlgo);
        String contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, null);
        ContentEncryptionProvider ctEncryptionProvider = null;
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, KeyOperation.ENCRYPT);
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, jwk.getAlgorithm());
                ctEncryptionProvider = JweUtils.getContentEncryptionAlgorithm(jwk, contentEncryptionAlgo);
            } else {
                keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, jwk.getAlgorithm(), JweUtils.getDefaultKeyAlgo(jwk));
                keyEncryptionProvider = JweUtils.getKeyEncryptionProvider(jwk, keyAlgo);
                if (reportPublicKey || reportPublicKeyId) {
                    JwkUtils.setPublicKeyInfo(jwk, headers, keyEncryptionAlgo, reportPublicKey, reportPublicKeyId);
                }
            }
        } else {
            keyEncryptionProvider = JweUtils.getRSAKeyEncryptionProvider((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props), keyAlgo);
            if (reportPublicKey) {
                headers.setX509Chain(KeyManagementUtils.loadAndEncodeX509CertificateOrChain(m, props));
            }
        }
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, ctEncryptionProvider, contentEncryptionAlgo, props.getProperty(JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP));
    }

    public static JweDecryptionProvider loadDecryptionProvider(boolean required) {
        return JweUtils.loadDecryptionProvider(null, required);
    }

    public static JweDecryptionProvider loadDecryptionProvider(JweHeaders inHeaders, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_ENCRYPTION_IN_PROPS, RSSEC_ENCRYPTION_PROPS);
        if (props == null) {
            return null;
        }
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        String contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, null);
        SecretKey ctDecryptionKey = null;
        String keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, null, null);
        if (inHeaders != null && inHeaders.getHeader("x5c") != null) {
            List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(inHeaders.getX509Chain());
            KeyManagementUtils.validateCertificateChain(props, chain);
            PrivateKey privateKey = KeyManagementUtils.loadPrivateKey(m, props, chain, KeyOperation.DECRYPT);
            contentEncryptionAlgo = inHeaders.getContentEncryptionAlgorithm().getJwaName();
            keyDecryptionProvider = JweUtils.getPrivateKeyDecryptionAlgorithm(privateKey, inHeaders.getKeyEncryptionAlgorithm());
        } else if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, KeyOperation.DECRYPT);
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, jwk.getAlgorithm());
                ctDecryptionKey = JweUtils.getContentDecryptionSecretKey(jwk, contentEncryptionAlgo);
            } else {
                keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, jwk.getAlgorithm(), JweUtils.getDefaultKeyAlgo(jwk));
                keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(jwk, KeyAlgorithm.getAlgorithm(keyEncryptionAlgo));
            }
        } else {
            keyDecryptionProvider = JweUtils.getPrivateKeyDecryptionAlgorithm(KeyManagementUtils.loadPrivateKey(m, props, KeyOperation.DECRYPT), KeyAlgorithm.getAlgorithm(keyEncryptionAlgo));
        }
        return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, ctDecryptionKey, JweUtils.getContentAlgo(contentEncryptionAlgo));
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentEncryptionAlgo, String compression) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getRSAKeyEncryptionProvider(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, JweHeaders headers) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getRSAKeyEncryptionProvider(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentEncryptionAlgo, String compression) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, JweHeaders headers) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, ContentAlgorithm contentEncryptionAlgo, String compression) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getKeyEncryptionProvider(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, JweHeaders headers) {
        KeyEncryptionProvider keyEncryptionProvider = JweUtils.getKeyEncryptionProvider(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionProvider keyEncryptionProvider, ContentAlgorithm contentEncryptionAlgo, String compression) {
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm().getJwaName() : null, contentEncryptionAlgo.getJwaName(), compression);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionProvider keyEncryptionProvider, JweHeaders headers) {
        String contentEncryptionAlgo = headers.getContentEncryptionAlgorithm().getJwaName();
        if (AlgorithmUtils.isAesCbcHmac(contentEncryptionAlgo)) {
            return new AesCbcHmacJweEncryption(JweUtils.getContentAlgo(contentEncryptionAlgo), keyEncryptionProvider);
        }
        return new JweEncryption(keyEncryptionProvider, JweUtils.getContentEncryptionAlgorithm(contentEncryptionAlgo));
    }

    public static JweDecryptionProvider createJweDecryptionProvider(PrivateKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getPrivateKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(JsonWebKey key, ContentAlgorithm contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getKeyDecryptionAlgorithm(key), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, ContentAlgorithm contentDecryptionAlgo) {
        if (AlgorithmUtils.isAesCbcHmac(contentDecryptionAlgo.getJwaName())) {
            return new AesCbcHmacJweDecryption(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return new JweDecryption(keyDecryptionProvider, JweUtils.getContentDecryptionAlgorithm(contentDecryptionAlgo));
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    public static byte[] getECDHKey(JsonWebKey privateKey, JsonWebKey peerPublicKey, byte[] partyUInfo, byte[] partyVInfo, String algoName, int algoKeyBitLen) {
        return JweUtils.getECDHKey(JwkUtils.toECPrivateKey(privateKey), JwkUtils.toECPublicKey(peerPublicKey), partyUInfo, partyVInfo, algoName, algoKeyBitLen);
    }

    public static byte[] getECDHKey(ECPrivateKey privateKey, ECPublicKey peerPublicKey, byte[] partyUInfo, byte[] partyVInfo, String algoName, int algoKeyBitLen) {
        byte[] keyZ = JweUtils.generateKeyZ(privateKey, peerPublicKey);
        return JweUtils.calculateDerivedKey(keyZ, algoName, partyUInfo, partyVInfo, algoKeyBitLen);
    }

    public static byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
        byte[] headersAAD = JweHeaders.toCipherAdditionalAuthData(headersJson);
        if (aad != null) {
            byte[] newAAD = Arrays.copyOf(headersAAD, headersAAD.length + 1 + aad.length);
            newAAD[headersAAD.length] = 46;
            System.arraycopy(aad, 0, newAAD, headersAAD.length + 1, aad.length);
            return newAAD;
        }
        return headersAAD;
    }

    private static byte[] calculateDerivedKey(byte[] keyZ, String algoName, byte[] apuBytes, byte[] apvBytes, int algoKeyBitLen) {
        byte[] emptyPartyInfo = new byte[4];
        if (apuBytes != null && apvBytes != null && Arrays.equals(apuBytes, apvBytes)) {
            LOG.warning("Derived key calculation problem: apu equals to apv");
            throw new JweException(JweException.Error.KEY_ENCRYPTION_FAILURE);
        }
        byte[] algorithmId = JweUtils.concatenateDatalenAndData(StringUtils.toBytesASCII((String)algoName));
        byte[] partyUInfo = apuBytes == null ? emptyPartyInfo : JweUtils.concatenateDatalenAndData(apuBytes);
        byte[] partyVInfo = apvBytes == null ? emptyPartyInfo : JweUtils.concatenateDatalenAndData(apvBytes);
        byte[] suppPubInfo = JweUtils.datalenToBytes(algoKeyBitLen);
        byte[] otherInfo = new byte[algorithmId.length + partyUInfo.length + partyVInfo.length + suppPubInfo.length];
        System.arraycopy(algorithmId, 0, otherInfo, 0, algorithmId.length);
        System.arraycopy(partyUInfo, 0, otherInfo, algorithmId.length, partyUInfo.length);
        System.arraycopy(partyVInfo, 0, otherInfo, algorithmId.length + partyUInfo.length, partyVInfo.length);
        System.arraycopy(suppPubInfo, 0, otherInfo, algorithmId.length + partyUInfo.length + partyVInfo.length, suppPubInfo.length);
        byte[] concatKDF = new byte[36 + otherInfo.length];
        concatKDF[3] = 1;
        System.arraycopy(keyZ, 0, concatKDF, 4, keyZ.length);
        System.arraycopy(otherInfo, 0, concatKDF, 36, otherInfo.length);
        try {
            byte[] round1Hash = MessageDigestUtils.createDigest((byte[])concatKDF, (String)"SHA-256");
            return Arrays.copyOf(round1Hash, algoKeyBitLen / 8);
        }
        catch (Exception ex) {
            LOG.warning("Derived key calculation problem: round hash1 error");
            throw new JweException(JweException.Error.KEY_ENCRYPTION_FAILURE);
        }
    }

    private static byte[] generateKeyZ(ECPrivateKey privateKey, ECPublicKey publicKey) {
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(privateKey);
            ka.doPhase(publicKey, true);
            return ka.generateSecret();
        }
        catch (Exception ex) {
            LOG.warning("Derived key calculation problem");
            throw new JweException(JweException.Error.KEY_ENCRYPTION_FAILURE);
        }
    }

    private static byte[] concatenateDatalenAndData(byte[] bytesASCII) {
        byte[] datalen = JweUtils.datalenToBytes(bytesASCII.length);
        byte[] all = new byte[4 + bytesASCII.length];
        System.arraycopy(datalen, 0, all, 0, 4);
        System.arraycopy(bytesASCII, 0, all, 4, bytesASCII.length);
        return all;
    }

    private static byte[] datalenToBytes(int len) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        return buf.putInt(len).array();
    }

    private static JweHeaders prepareJweHeaders(String keyEncryptionAlgo, String contentEncryptionAlgo, String compression) {
        JweHeaders headers = new JweHeaders();
        if (keyEncryptionAlgo != null) {
            headers.setKeyEncryptionAlgorithm(KeyAlgorithm.getAlgorithm(keyEncryptionAlgo));
        }
        headers.setContentEncryptionAlgorithm(ContentAlgorithm.getAlgorithm(contentEncryptionAlgo));
        if (compression != null) {
            headers.setZipAlgorithm(compression);
        }
        return headers;
    }

    private static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionProvider keyEncryptionProvider, ContentEncryptionProvider ctEncryptionProvider, String contentEncryptionAlgo, String compression) {
        if (keyEncryptionProvider == null && ctEncryptionProvider == null) {
            LOG.warning("Key or content encryptor is not available");
            throw new JweException(JweException.Error.NO_ENCRYPTOR);
        }
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm().getJwaName() : null, contentEncryptionAlgo, compression);
        if (keyEncryptionProvider != null) {
            return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
        }
        return new JweEncryption(new DirectKeyEncryptionAlgorithm(), ctEncryptionProvider);
    }

    private static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, SecretKey ctDecryptionKey, ContentAlgorithm contentDecryptionAlgo) {
        if (keyDecryptionProvider == null && ctDecryptionKey == null) {
            LOG.warning("Key or content encryptor is not available");
            throw new JweException(JweException.Error.NO_ENCRYPTOR);
        }
        if (keyDecryptionProvider != null) {
            return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return JweUtils.getDirectKeyJweDecryption(ctDecryptionKey, contentDecryptionAlgo);
    }

    private static String getKeyEncryptionAlgo(Message m, Properties props, String algo, String defaultAlgo) {
        if (algo == null) {
            if (defaultAlgo == null) {
                defaultAlgo = "RSA-OAEP";
            }
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_ENCRYPTION_KEY_ALGO_PROP, defaultAlgo);
        }
        return algo;
    }

    private static String getDefaultKeyAlgo(JsonWebKey jwk) {
        KeyType keyType = jwk.getKeyType();
        if (KeyType.OCTET == keyType) {
            return "A128GCMKW";
        }
        return "RSA-OAEP";
    }

    private static String getContentEncryptionAlgo(Message m, Properties props, String algo) {
        if (algo == null) {
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_ENCRYPTION_CEK_ALGO_PROP, "A128GCM");
        }
        return algo;
    }

    private static String encrypt(KeyEncryptionProvider keyEncryptionProvider, ContentAlgorithm contentAlgo, byte[] content, String ct) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentAlgo, null);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    private static byte[] decrypt(KeyDecryptionAlgorithm keyDecryptionProvider, ContentAlgorithm contentAlgo, String content) {
        JweDecryptionProvider jwe = JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    private static JweHeaders toJweHeaders(String ct) {
        return new JweHeaders(Collections.singletonMap("cty", ct));
    }

    public static void validateJweCertificateChain(List<X509Certificate> certs) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, true, RSSEC_ENCRYPTION_IN_PROPS, RSSEC_ENCRYPTION_PROPS);
        KeyManagementUtils.validateCertificateChain(props, certs);
    }
}

