/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.RSAPrivateKey;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;

public class RSAKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    public RSAKeyDecryptionAlgorithm(RSAPrivateKey privateKey) {
        this(privateKey, KeyAlgorithm.RSA_OAEP);
    }

    public RSAKeyDecryptionAlgorithm(RSAPrivateKey privateKey, KeyAlgorithm supportedAlgo) {
        this(privateKey, supportedAlgo, true);
    }

    public RSAKeyDecryptionAlgorithm(RSAPrivateKey privateKey, KeyAlgorithm supportedAlgo, boolean unwrap) {
        super(privateKey, supportedAlgo, unwrap);
    }

    @Override
    protected int getKeyCipherBlockSize() {
        return ((RSAPrivateKey)this.getCekDecryptionKey()).getModulus().toByteArray().length;
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!AlgorithmUtils.isRsaKeyWrap(keyAlgo)) {
            this.reportInvalidKeyAlgorithm(keyAlgo);
        }
    }
}

