/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.services;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth.data.Client;
import org.apache.cxf.rs.security.oauth.data.RequestToken;
import org.apache.cxf.rs.security.oauth.data.RequestTokenRegistration;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth.utils.OAuthUtils;

public class RequestTokenHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(RequestTokenHandler.class);
    private static final String[] REQUIRED_PARAMETERS = new String[]{"oauth_consumer_key", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_callback"};
    private long tokenLifetime = 3600L;
    private String defaultScope;

    public Response handle(MessageContext mc, OAuthDataProvider dataProvider) {
        try {
            OAuthMessage oAuthMessage = OAuthUtils.getOAuthMessage(mc, mc.getHttpServletRequest(), REQUIRED_PARAMETERS);
            Client client = dataProvider.getClient(oAuthMessage.getParameter("oauth_consumer_key"));
            if (client == null) {
                throw new OAuthProblemException("consumer_key_unknown");
            }
            OAuthUtils.validateMessage(oAuthMessage, client, null, dataProvider);
            String callback = oAuthMessage.getParameter("oauth_callback");
            this.validateCallbackURL(client, callback);
            List<String> scopes = OAuthUtils.parseParamValue(oAuthMessage.getParameter("scope"), this.defaultScope);
            RequestTokenRegistration reg = new RequestTokenRegistration();
            reg.setClient(client);
            reg.setCallback(callback);
            reg.setState(oAuthMessage.getParameter("state"));
            reg.setScopes(scopes);
            reg.setLifetime(this.tokenLifetime);
            reg.setIssuedAt(System.currentTimeMillis() / 1000L);
            RequestToken requestToken = dataProvider.createRequestToken(reg);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Preparing Temporary Credentials Endpoint correct response");
            }
            HashMap<String, Object> responseParams = new HashMap<String, Object>();
            responseParams.put("oauth_token", requestToken.getTokenKey());
            responseParams.put("oauth_token_secret", requestToken.getTokenSecret());
            responseParams.put("oauth_callback_confirmed", Boolean.TRUE);
            String responseBody = OAuth.formEncode(responseParams.entrySet());
            return Response.ok((Object)responseBody).build();
        }
        catch (OAuthProblemException e) {
            int code;
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "An OAuth-related problem: {0}", new Object[]{e.fillInStackTrace()});
            }
            if ((code = e.getHttpStatusCode()) == 200) {
                code = 401;
            }
            return OAuthUtils.handleException((Exception)((Object)e), code, String.valueOf(e.getParameters().get("realm")));
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Unexpected internal server exception: {0}", new Object[]{e.fillInStackTrace()});
            }
            return OAuthUtils.handleException(e, 500);
        }
    }

    protected void validateCallbackURL(Client client, String oauthCallback) throws OAuthProblemException {
        if (StringUtils.isEmpty((String)oauthCallback) || client.getCallbackURI() != null && !oauthCallback.equals(client.getCallbackURI()) || client.getApplicationURI() != null && !oauthCallback.startsWith(client.getApplicationURI())) {
            OAuthProblemException problemEx = new OAuthProblemException("parameter_rejected - oauth_callback");
            problemEx.setParameter("HTTP status", (Object)400);
            throw problemEx;
        }
    }

    public void setTokenLifetime(long tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }
}

