/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacUtils;
import org.apache.cxf.rs.security.oauth2.tokens.mac.MacAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.mac.MacAuthorizationScheme;
import org.apache.cxf.rs.security.oauth2.tokens.mac.NonceVerifier;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacAccessTokenValidator
implements AccessTokenValidator {
    private OAuthDataProvider dataProvider;
    private NonceVerifier nonceVerifier;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("MAC");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData) throws OAuthServiceException {
        HttpRequestProperties httpProps = new HttpRequestProperties(mc.getUriInfo().getRequestUri(), mc.getHttpServletRequest().getMethod());
        Map<String, String> schemeParams = MacAccessTokenValidator.getSchemeParameters(authSchemeData);
        MacAuthorizationScheme macAuthInfo = new MacAuthorizationScheme(httpProps, schemeParams);
        MacAccessToken macAccessToken = this.validateSchemeData(macAuthInfo, schemeParams.get("mac"));
        this.validateTimestampNonce(macAccessToken, macAuthInfo.getTimestamp(), macAuthInfo.getNonce());
        return new AccessTokenValidation(macAccessToken);
    }

    private static Map<String, String> getSchemeParameters(String authData) {
        String[] attributePairs = authData.split(",");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributePairs) {
            String[] pairValues = pair.trim().split("=", 2);
            attributeMap.put(pairValues[0].trim(), pairValues[1].trim().replaceAll("\"", ""));
        }
        return attributeMap;
    }

    protected void validateTimestampNonce(MacAccessToken token, String ts, String nonce) {
        if (this.nonceVerifier != null) {
            this.nonceVerifier.verifyNonce(token.getTokenKey(), nonce, ts);
        }
    }

    private MacAccessToken validateSchemeData(MacAuthorizationScheme macAuthInfo, String clientMacString) {
        String macKey = macAuthInfo.getMacKey();
        ServerAccessToken accessToken = this.dataProvider.getAccessToken(macKey);
        if (!(accessToken instanceof MacAccessToken)) {
            throw new OAuthServiceException("server_error");
        }
        MacAccessToken macAccessToken = (MacAccessToken)accessToken;
        String normalizedString = macAuthInfo.getNormalizedRequestString();
        try {
            HmacAlgorithm hmacAlgo = HmacAlgorithm.toHmacAlgorithm(macAccessToken.getMacAlgorithm());
            byte[] serverMacData = HmacUtils.computeHmac(macAccessToken.getMacKey(), hmacAlgo, normalizedString);
            byte[] clientMacData = Base64Utility.decode((String)clientMacString);
            boolean validMac = Arrays.equals(serverMacData, clientMacData);
            if (!validMac) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton("MAC"));
            }
        }
        catch (Base64Exception e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        return macAccessToken;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setNonceVerifier(NonceVerifier nonceVerifier) {
        this.nonceVerifier = nonceVerifier;
    }
}

