/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.mac;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.mac.HmacAlgorithm;

public final class HmacUtils {
    private HmacUtils() {
    }

    public static String computeSignature(String macAlgoOAuthName, String macSecret, String data) {
        HmacAlgorithm theAlgo = HmacAlgorithm.toHmacAlgorithm(macAlgoOAuthName);
        return HmacUtils.computeHmacString(macSecret, theAlgo.getJavaName(), data);
    }

    public static String computeHmacString(String macSecret, String macAlgoJavaName, String data) {
        return new String(Base64Utility.encode((byte[])HmacUtils.computeHmac(macSecret, macAlgoJavaName, data)));
    }

    public static byte[] computeHmac(String key, HmacAlgorithm algo, String data) {
        return HmacUtils.computeHmac(key, algo.getJavaName(), data);
    }

    public static byte[] computeHmac(String key, String macAlgoJavaName, String data) {
        try {
            Mac hmac = Mac.getInstance(macAlgoJavaName);
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), macAlgoJavaName);
            hmac.init(secretKey);
            return hmac.doFinal(data.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("invalid_request", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new OAuthServiceException("invalid_request", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthServiceException("invalid_request", (Throwable)e);
        }
    }

    public static String generateSecret(HmacAlgorithm algo) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algo.name());
            return Base64Utility.encode((byte[])keyGen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
    }
}

