/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class ServerAccessToken
extends AccessToken {
    private static final long serialVersionUID = 638776204861456064L;
    private String grantType;
    private Client client;
    private List<OAuthPermission> scopes = new LinkedList<OAuthPermission>();
    private UserSubject subject;
    private String audience;

    protected ServerAccessToken() {
    }

    protected ServerAccessToken(Client client, String tokenType, String tokenKey, long expiresIn) {
        this(client, tokenType, tokenKey, expiresIn, OAuthUtils.getIssuedAt());
    }

    protected ServerAccessToken(Client client, String tokenType, String tokenKey, long expiresIn, long issuedAt) {
        super(tokenType, tokenKey, expiresIn, issuedAt);
        this.client = client;
    }

    protected ServerAccessToken(ServerAccessToken token, String key) {
        super(token.getTokenType(), key, token.getExpiresIn(), token.getIssuedAt(), token.getRefreshToken(), token.getParameters());
        this.client = token.getClient();
        this.grantType = token.getGrantType();
        this.scopes = token.getScopes();
        this.audience = token.getAudience();
        this.subject = token.getSubject();
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client c) {
        this.client = c;
    }

    public List<OAuthPermission> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<OAuthPermission> scopes) {
        this.scopes = scopes;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    public UserSubject getSubject() {
        return this.subject;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    protected static ServerAccessToken validateTokenType(ServerAccessToken token, String expectedType) {
        if (!token.getTokenType().equals(expectedType)) {
            throw new OAuthServiceException("server_error");
        }
        return token;
    }
}

