/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.ClientIdProvider;
import org.apache.cxf.rs.security.oauth2.provider.ClientSecretVerifier;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;

public class AbstractTokenService
extends AbstractOAuthService {
    private boolean canSupportPublicClients;
    private boolean writeCustomErrors;
    private ClientIdProvider clientIdProvider;
    private ClientSecretVerifier clientSecretVerifier;

    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        Client client = null;
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        Principal principal = sc.getUserPrincipal();
        if (principal == null) {
            String clientId = this.retrieveClientId(params);
            if (clientId != null) {
                client = this.getAndValidateClientFromIdAndSecret(clientId, (String)params.getFirst((Object)"client_secret"));
            }
        } else {
            String clientId = this.retrieveClientId(params);
            if (clientId != null) {
                client = this.getClient(clientId);
            } else if (principal.getName() != null) {
                client = this.getClient(principal.getName());
            }
        }
        if (client == null && (client = this.getClientFromTLSCertificates(sc, this.getTlsSessionInfo())) == null) {
            client = this.getClientFromBasicAuthScheme();
        }
        if (client != null && !client.getApplicationCertificates().isEmpty()) {
            this.compareTlsCertificates(this.getTlsSessionInfo(), client.getApplicationCertificates());
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    private TLSSessionInfo getTlsSessionInfo() {
        return (TLSSessionInfo)this.getMessageContext().get((Object)TLSSessionInfo.class.getName());
    }

    protected String retrieveClientId(MultivaluedMap<String, String> params) {
        String clientId = (String)params.getFirst((Object)"client_id");
        if (clientId == null) {
            clientId = (String)this.getMessageContext().get((Object)"client_id");
        }
        if (clientId == null && this.clientIdProvider != null) {
            clientId = this.clientIdProvider.getClientId(this.getMessageContext());
        }
        return clientId;
    }

    protected Client getAndValidateClientFromIdAndSecret(String clientId, String providedClientSecret) {
        Client client = this.getClient(clientId);
        if (!client.getClientId().equals(clientId)) {
            this.reportInvalidClient();
        }
        if (this.isValidPublicClient(client, clientId, providedClientSecret)) {
            return client;
        }
        if (!client.isConfidential() || !this.isConfidenatialClientSecretValid(client, providedClientSecret)) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected boolean isConfidenatialClientSecretValid(Client client, String providedClientSecret) {
        if (this.clientSecretVerifier != null) {
            return this.clientSecretVerifier.validateClientSecret(client, providedClientSecret);
        }
        return client.getClientSecret() != null && providedClientSecret != null && client.getClientSecret().equals(providedClientSecret);
    }

    protected boolean isValidPublicClient(Client client, String clientId, String clientSecret) {
        return this.canSupportPublicClients && !client.isConfidential() && client.getClientSecret() == null && clientSecret == null;
    }

    protected Client getClientFromBasicAuthScheme() {
        String[] userInfo = AuthorizationUtils.getBasicAuthUserInfo(this.getMessageContext());
        if (userInfo != null && userInfo.length == 2) {
            return this.getAndValidateClientFromIdAndSecret(userInfo[0], userInfo[1]);
        }
        return null;
    }

    protected Client getClientFromTLSCertificates(SecurityContext sc, TLSSessionInfo tlsSessionInfo) {
        String clientId;
        Client client = null;
        if (tlsSessionInfo != null && StringUtils.isEmpty((String)sc.getAuthenticationScheme()) && !StringUtils.isEmpty((String)(clientId = this.getClientIdFromTLSCertificates(sc, tlsSessionInfo)))) {
            client = this.getClient(clientId);
        }
        return client;
    }

    protected String getClientIdFromTLSCertificates(SecurityContext sc, TLSSessionInfo tlsInfo) {
        Certificate[] clientCerts = tlsInfo.getPeerCertificates();
        if (clientCerts != null && clientCerts.length > 0) {
            X500Principal x509Principal = ((X509Certificate)clientCerts[0]).getSubjectX500Principal();
            return x509Principal.getName();
        }
        return null;
    }

    protected void compareTlsCertificates(TLSSessionInfo tlsInfo, List<String> base64EncodedCerts) {
        Certificate[] clientCerts;
        if (tlsInfo != null && (clientCerts = tlsInfo.getPeerCertificates()).length == base64EncodedCerts.size()) {
            try {
                for (int i = 0; i < clientCerts.length; ++i) {
                    byte[] clientKey;
                    X509Certificate x509Cert = (X509Certificate)clientCerts[i];
                    byte[] encodedKey = x509Cert.getEncoded();
                    if (Arrays.equals(encodedKey, clientKey = Base64Utility.decode((String)base64EncodedCerts.get(i)))) continue;
                    this.reportInvalidClient();
                }
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.reportInvalidClient();
    }

    protected Response handleException(OAuthServiceException ex, String error) {
        OAuthError customError = ex.getError();
        if (this.writeCustomErrors && customError != null) {
            return this.createErrorResponseFromBean(customError);
        }
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromBean(OAuthError errorBean) {
        return JAXRSUtils.toResponseBuilder((int)400).entity((Object)errorBean).build();
    }

    protected Client getClient(String clientId) {
        Client client;
        block4: {
            if (clientId == null) {
                this.reportInvalidRequestError("Client ID is null");
                return null;
            }
            client = null;
            try {
                client = this.getValidClient(clientId);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block4;
                this.reportInvalidClient(ex.getError());
                return null;
            }
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected void reportInvalidClient() {
        this.reportInvalidClient(new OAuthError("invalid_client"));
    }

    protected void reportInvalidClient(OAuthError error) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((int)401);
        throw ExceptionUtils.toNotAuthorizedException(null, (Response)rb.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build());
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }

    public void setWriteCustomErrors(boolean writeCustomErrors) {
        this.writeCustomErrors = writeCustomErrors;
    }

    public void setClientIdProvider(ClientIdProvider clientIdProvider) {
        this.clientIdProvider = clientIdProvider;
    }

    public void setClientSecretVerifier(ClientSecretVerifier clientSecretVerifier) {
        this.clientSecretVerifier = clientSecretVerifier;
    }
}

