/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.TokenIntrospection;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class AccessTokenIntrospectionClient
implements AccessTokenValidator {
    private WebClient tokenValidatorClient;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("Bearer");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        WebClient client = WebClient.fromClient((Client)this.tokenValidatorClient, (boolean)true);
        MetadataMap props = new MetadataMap();
        props.putSingle((Object)"token", (Object)authSchemeData);
        try {
            TokenIntrospection response = (TokenIntrospection)client.post((Object)props, TokenIntrospection.class);
            return this.convertIntrospectionToValidation(response);
        }
        catch (WebApplicationException ex) {
            throw new OAuthServiceException(ex);
        }
    }

    private AccessTokenValidation convertIntrospectionToValidation(TokenIntrospection response) {
        AccessTokenValidation atv = new AccessTokenValidation();
        atv.setInitialValidationSuccessful(response.isActive());
        if (response.getClientId() != null) {
            atv.setClientId(response.getClientId());
        }
        if (response.getIat() != null) {
            atv.setTokenIssuedAt(response.getIat());
        } else {
            Instant now = Instant.now();
            atv.setTokenIssuedAt(now.toEpochMilli());
        }
        if (response.getExp() != null) {
            atv.setTokenLifetime(response.getExp() - atv.getTokenIssuedAt());
        }
        if (!StringUtils.isEmpty(response.getAud())) {
            atv.setAudiences(response.getAud());
        }
        if (response.getIss() != null) {
            atv.setTokenIssuer(response.getIss());
        }
        if (response.getScope() != null) {
            String[] scopes = response.getScope().split(" ");
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            for (String s : scopes) {
                if (StringUtils.isEmpty((String)s)) continue;
                perms.add(new OAuthPermission(s.trim()));
            }
            atv.setTokenScopes(perms);
        }
        if (response.getUsername() != null) {
            atv.setTokenSubject(new UserSubject(response.getUsername()));
        }
        atv.getExtraProps().putAll(response.getExtensions());
        return atv;
    }

    public void setTokenValidatorClient(WebClient tokenValidatorClient) {
        this.tokenValidatorClient = tokenValidatorClient;
    }
}

