/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;

public class CryptoLoader {
    private static final String CRYPTO_CACHE = "rs-security-xml-crypto.cache";

    public Crypto loadCrypto(String cryptoResource) throws IOException, WSSecurityException {
        URL url = SecurityUtils.loadResource((Object)cryptoResource);
        if (url != null) {
            return CryptoLoader.loadCryptoFromURL(url);
        }
        return null;
    }

    public Crypto getCrypto(Message message, String cryptoKey, String propKey) throws IOException, WSSecurityException {
        Crypto crypto = (Crypto)SecurityUtils.getSecurityPropertyValue((String)cryptoKey, (Message)message);
        if (crypto != null) {
            return crypto;
        }
        Object o = SecurityUtils.getSecurityPropertyValue((String)propKey, (Message)message);
        if (o == null) {
            return null;
        }
        String propResourceName = (String)o;
        Map<Object, Crypto> cryptoCache = this.getCryptoCache(message);
        Crypto crypto2 = crypto = cryptoCache != null ? cryptoCache.get(propResourceName) : null;
        if (crypto != null) {
            return crypto;
        }
        URL url = SecurityUtils.loadResource((Message)message, (Object)propResourceName);
        crypto = url != null ? CryptoLoader.loadCryptoFromURL(url) : CryptoFactory.getInstance((String)propResourceName, (ClassLoader)Thread.currentThread().getContextClassLoader());
        if (cryptoCache != null && crypto != null) {
            cryptoCache.put(o, crypto);
        }
        return crypto;
    }

    public static Crypto loadCryptoFromURL(URL url) throws IOException, WSSecurityException {
        Properties props = new Properties();
        InputStream in = url.openStream();
        props.load(in);
        in.close();
        return CryptoFactory.getInstance((Properties)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Object, Crypto> getCryptoCache(Message message) {
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        if (endpoint != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = endpoint.getEndpointInfo();
            synchronized (endpointInfo) {
                ConcurrentHashMap<Object, Crypto> o = CastUtils.cast((Map)((Map)info.getProperty(CRYPTO_CACHE)));
                if (o == null) {
                    o = new ConcurrentHashMap<Object, Crypto>();
                    info.setProperty(CRYPTO_CACHE, o);
                }
                return o;
            }
        }
        return null;
    }
}

