/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RSSecurityUtils {
    public static final String X509_CERT = "X509Certificate";
    public static final String X509_ISSUER_SERIAL = "X509IssuerSerial";
    public static final String USE_REQUEST_SIGNATURE_CERT = "useReqSigCert";

    private RSSecurityUtils() {
    }

    public static boolean isSignedAndEncryptedTwoWay(Message m) {
        Message outMessage = m.getExchange().getOutMessage();
        Message requestMessage = outMessage != null && MessageUtils.isRequestor((Message)outMessage) ? outMessage : m;
        Object encryptionProperties = SecurityUtils.getSecurityPropertyValue((String)"security.encryption.properties", (Message)m);
        Object signatureProperties = SecurityUtils.getSecurityPropertyValue((String)"security.signature.properties", (Message)m);
        return "POST".equals((String)requestMessage.get((Object)"org.apache.cxf.request.method")) && encryptionProperties != null && signatureProperties != null;
    }

    public static X509Certificate loadX509Certificate(Crypto crypto, Element certNode) throws Exception {
        String base64Value = certNode.getTextContent().trim();
        byte[] certBytes = Base64Utility.decode((String)base64Value);
        Crypto certCrypto = crypto;
        if (certCrypto == null) {
            certCrypto = new Merlin();
        }
        return certCrypto.loadCertificate((InputStream)new ByteArrayInputStream(certBytes));
    }

    public static X509Certificate loadX509IssuerSerial(Crypto crypto, Element certNode) throws Exception {
        Node issuerNameNode = certNode.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName").item(0);
        Node serialNumberNode = certNode.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber").item(0);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerNameNode.getTextContent(), new BigInteger(serialNumberNode.getTextContent()));
        return crypto.getX509Certificates(cryptoType)[0];
    }

    public static X509Certificate[] getCertificates(Crypto crypto, String user) throws Exception {
        if (crypto == null) {
            throw new Exception("Crypto instance is null");
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(user);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null || issuerCerts.length == 0) {
            throw new Exception("No issuer certs were found using issuer name: " + user);
        }
        return issuerCerts;
    }

    public static Crypto getCrypto(Message message, String cryptoKey, String propKey) throws IOException, WSSecurityException {
        return new CryptoLoader().getCrypto(message, cryptoKey, propKey);
    }

    public static String getUserName(Message message, Crypto crypto, String userNameKey) {
        String user = (String)SecurityUtils.getSecurityPropertyValue((String)userNameKey, (Message)message);
        return RSSecurityUtils.getUserName(crypto, user);
    }

    public static String getUserName(Crypto crypto, String userName) {
        if (crypto != null && StringUtils.isEmpty((String)userName)) {
            try {
                userName = crypto.getDefaultX509Identifier();
            }
            catch (WSSecurityException e1) {
                throw new Fault((Throwable)e1);
            }
        }
        return userName;
    }

    public static String getPassword(Message message, String userName, int type, Class<?> callingClass) throws WSSecurityException {
        CallbackHandler handler = RSSecurityUtils.getCallbackHandler(message, callingClass);
        if (handler == null) {
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            return null;
        }
        String password = cb[0].getPassword();
        return password == null ? "" : password;
    }

    public static CallbackHandler getCallbackHandler(Message message, Class<?> callingClass) throws WSSecurityException {
        return RSSecurityUtils.getCallbackHandler(message, callingClass, "security.callback-handler");
    }

    public static CallbackHandler getCallbackHandler(Message message, Class<?> callingClass, String callbackProperty) throws WSSecurityException {
        Object o = SecurityUtils.getSecurityPropertyValue((String)callbackProperty, (Message)message);
        try {
            return SecurityUtils.getCallbackHandler((Object)o);
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
    }
}

