/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class PolicyBuilderImpl
implements PolicyBuilder,
BusExtension {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(PolicyBuilderImpl.class);
    private AssertionBuilderRegistry assertionBuilderRegistry;
    private Bus bus;

    public Class<?> getRegistrationType() {
        return PolicyBuilder.class;
    }

    public void setBus(Bus theBus) {
        this.bus = theBus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setAssertionBuilderRegistry(AssertionBuilderRegistry abr) {
        this.assertionBuilderRegistry = abr;
    }

    public AssertionBuilderRegistry getAssertionBuilderRegistry() {
        return this.assertionBuilderRegistry;
    }

    public PolicyReference getPolicyReference(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        Element element = DOMUtils.readXml((InputStream)is).getDocumentElement();
        return this.getPolicyReference(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyReference getPolicyReference(Element element) {
        if (!"PolicyReference".equals(element.getLocalName())) {
            throw new PolicyException(new Message("NOT_A_POLICYREF_ELEMENT_EXC", BUNDLE, new Object[0]));
        }
        Element element2 = element;
        synchronized (element2) {
            PolicyReference reference = new PolicyReference();
            reference.setURI(element.getAttribute("URI"));
            return reference;
        }
    }

    public Policy getPolicy(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        Element element = DOMUtils.readXml((InputStream)is).getDocumentElement();
        return this.getPolicy(element);
    }

    public Policy getPolicy(Element element) {
        return this.getPolicyOperator(element);
    }

    private Policy getPolicyOperator(Element element) {
        return (Policy)this.processOperationElement(element, (PolicyOperator)new Policy());
    }

    private ExactlyOne getExactlyOneOperator(Element element) {
        return (ExactlyOne)this.processOperationElement(element, (PolicyOperator)new ExactlyOne());
    }

    private All getAllOperator(Element element) {
        return (All)this.processOperationElement(element, (PolicyOperator)new All());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyOperator processOperationElement(Element operationElement, PolicyOperator operator) {
        Element element = operationElement;
        synchronized (element) {
            if (1 == operator.getType()) {
                Policy policyOperator = (Policy)operator;
                NamedNodeMap nnm = operationElement.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Node n = nnm.item(i);
                    if (2 != n.getNodeType()) continue;
                    String namespace = n.getNamespaceURI();
                    QName key = namespace == null ? new QName(n.getLocalName()) : (n.getPrefix() == null ? new QName(namespace, n.getLocalName()) : new QName(namespace, n.getLocalName(), n.getPrefix()));
                    policyOperator.addAttribute(key, n.getNodeValue());
                }
            }
            for (Node n = operationElement.getFirstChild(); n != null; n = n.getNextSibling()) {
                PolicyAssertion a;
                String localName;
                if (1 != n.getNodeType()) continue;
                Element childElement = (Element)n;
                String namespaceURI = childElement.getNamespaceURI();
                QName qn = new QName(namespaceURI, localName = childElement.getLocalName());
                if (PolicyConstants.isPolicyElem((QName)qn)) {
                    operator.addPolicyComponent((PolicyComponent)this.getPolicyOperator(childElement));
                    continue;
                }
                if (PolicyConstants.isAll((QName)qn)) {
                    operator.addPolicyComponent((PolicyComponent)this.getAllOperator(childElement));
                    continue;
                }
                if (PolicyConstants.isExactlyOne((QName)qn)) {
                    operator.addPolicyComponent((PolicyComponent)this.getExactlyOneOperator(childElement));
                    continue;
                }
                if (PolicyConstants.isPolicyRefElem((QName)qn)) {
                    operator.addPolicyComponent((PolicyComponent)this.getPolicyReference(childElement));
                    continue;
                }
                if (null == this.assertionBuilderRegistry || null == (a = this.assertionBuilderRegistry.build(childElement))) continue;
                operator.addPolicyComponent((PolicyComponent)a);
            }
            return operator;
        }
    }

    public PolicyRegistry getPolicyRegistry() {
        PolicyEngine e = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        return e == null ? null : e.getRegistry();
    }
}

