/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.w3c.dom.Element;

public class IssuedToken
extends Token {
    private Element issuerEpr;
    private Element issuerMex;
    private Element rstTemplate;
    private boolean requireExternalReference;
    private boolean requireInternalReference;

    public IssuedToken(SPConstants version) {
        super(version);
    }

    public Element getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(Element issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public void setRequireExternalReference(boolean requireExternalReference) {
        this.requireExternalReference = requireExternalReference;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public void setRequireInternalReference(boolean requireInternalReference) {
        this.requireInternalReference = requireInternalReference;
    }

    public Element getRstTemplate() {
        return this.rstTemplate;
    }

    public void setRstTemplate(Element rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public QName getName() {
        return this.constants.getIssuedToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String inclusion;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, "Issuer", namespaceURI);
            StaxUtils.copy((Element)this.issuerEpr, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (this.rstTemplate != null) {
            StaxUtils.copy((Element)this.rstTemplate, (XMLStreamWriter)writer);
        }
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        if (this.isRequireExternalReference() || this.isRequireInternalReference() || this.isDerivedKeys()) {
            writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, policyNamespaceURI);
            }
            if (this.isRequireExternalReference()) {
                writer.writeEmptyElement(prefix, "RequireExternalReference", namespaceURI);
            }
            if (this.isRequireInternalReference()) {
                writer.writeEmptyElement(prefix, "RequireInternalReference", namespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Element getIssuerMex() {
        return this.issuerMex;
    }

    public void setIssuerMex(Element issuerMex) {
        this.issuerMex = issuerMex;
    }
}

