/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.RecipientToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingHandler
extends AbstractBindingBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(AsymmetricBindingHandler.class);
    AsymmetricBinding abinding;
    private WSSecEncryptedKey encrKey;
    private String encryptedKeyId;
    private byte[] encryptedKeyValue;

    public AsymmetricBindingHandler(AsymmetricBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(binding, saaj, secHeader, aim, message);
        this.abinding = binding;
        this.protectionOrder = binding.getProtectionOrder();
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        if (this.abinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
            this.doEncryptBeforeSign();
        } else {
            this.doSignBeforeEncrypt();
        }
    }

    private void doSignBeforeEncrypt() {
        try {
            Element el;
            Vector<WSEncryptionPart> sigs = new Vector<WSEncryptionPart>();
            if (this.isRequestor()) {
                if (this.timestampEl != null) {
                    el = this.timestampEl.getElement();
                    sigs.add(new WSEncryptionPart(this.addWsuIdToElement(el)));
                }
                this.addSupportingTokens(sigs);
                this.doSignature(sigs);
                this.doEndorse();
            } else {
                this.assertSupportingTokens(sigs);
                if (this.timestampEl != null) {
                    el = this.timestampEl.getElement();
                    sigs.add(new WSEncryptionPart(this.addWsuIdToElement(el)));
                }
                this.addSignatureConfirmation(sigs);
                this.doSignature(sigs);
            }
            Vector<WSEncryptionPart> enc = this.getEncryptedParts();
            if (this.abinding.isSignatureProtection() && this.mainSigId != null) {
                enc.add(new WSEncryptionPart(this.mainSigId, "Element"));
            }
            if (this.isRequestor()) {
                for (String id : this.encryptedTokensIdList) {
                    enc.add(new WSEncryptionPart(id, "Element"));
                }
            }
            RecipientToken recToken = this.abinding.getRecipientToken();
            this.doEncryption(recToken, enc, false);
        }
        catch (Exception e) {
            String reason = e.getMessage();
            LOG.log(Level.WARNING, "Sign before encryption failed due to : " + reason);
            throw new Fault((Throwable)e);
        }
    }

    private void doEncryptBeforeSign() {
        Token encryptionToken = null;
        TokenWrapper wrapper = this.isRequestor() ? this.abinding.getRecipientToken() : this.abinding.getInitiatorToken();
        encryptionToken = wrapper.getToken();
        Vector<WSEncryptionPart> encrParts = null;
        Vector<WSEncryptionPart> sigParts = null;
        try {
            encrParts = this.getEncryptedParts();
            sigParts = this.getSignedParts();
        }
        catch (SOAPException e1) {
            e1.printStackTrace();
        }
        if (encryptionToken != null || encrParts.size() > 0) {
            // empty if block
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            WSSecBase encrBase = this.doEncryption(wrapper, encrParts, true);
            this.handleEncryptedSignedHeaders(encrParts, sigParts);
            if (this.timestampEl != null) {
                sigParts.add(new WSEncryptionPart(this.addWsuIdToElement(this.timestampEl.getElement())));
            }
            if (this.isRequestor()) {
                this.addSupportingTokens(sigParts);
            } else {
                this.addSignatureConfirmation(sigParts);
            }
            if (sigParts.size() > 0 && this.isRequestor() && this.abinding.getInitiatorToken() != null || !this.isRequestor() && this.abinding.getRecipientToken() != null) {
                try {
                    this.doSignature(sigParts);
                }
                catch (WSSecurityException e) {
                    e.printStackTrace();
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
            if (this.isRequestor()) {
                this.doEndorse();
            }
            if (this.abinding.isSignatureProtection() && this.mainSigId != null) {
                Element secondRefList;
                Vector<WSEncryptionPart> secondEncrParts = new Vector<WSEncryptionPart>();
                secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                if (this.isRequestor()) {
                    for (String id : this.encryptedTokensIdList) {
                        secondEncrParts.add(new WSEncryptionPart(id, "Element"));
                    }
                }
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = ((WSSecDKEncrypt)encrBase).encryptForExternalRef(null, secondEncrParts);
                        ((WSSecDKEncrypt)encrBase).addExternalRefElement(secondRefList, this.secHeader);
                    }
                    catch (WSSecurityException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        secondRefList = this.saaj.getSOAPPart().createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
                        this.insertBeforeBottomUp(secondRefList);
                        ((WSSecEncrypt)encrBase).encryptForExternalRef(secondRefList, secondEncrParts);
                    }
                    catch (WSSecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private WSSecBase doEncryption(TokenWrapper recToken, Vector<WSEncryptionPart> encrParts, boolean externalRef) {
        if (recToken != null && recToken.getToken() != null && encrParts.size() > 0) {
            Token encrToken = recToken.getToken();
            this.policyAsserted(recToken);
            this.policyAsserted(encrToken);
            AlgorithmSuite algorithmSuite = this.abinding.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                    if (this.encrKey == null) {
                        this.setupEncryptedKey(recToken, encrToken);
                    }
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setParts(encrParts);
                    dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare((Document)this.saaj.getSOAPPart());
                    this.addDerivedKeyElement(dkEncr.getdktElement());
                    Element refList = dkEncr.encryptForExternalRef(null, encrParts);
                    this.insertBeforeBottomUp(refList);
                    return dkEncr;
                }
                catch (Exception e) {
                    this.policyNotAsserted((PolicyAssertion)recToken, e);
                }
            } else {
                try {
                    WSSecEncrypt encr = new WSSecEncrypt();
                    this.setKeyIdentifierType((WSSecBase)encr, recToken, encrToken);
                    encr.setDocument((Document)this.saaj.getSOAPPart());
                    Crypto crypto = this.getEncryptionCrypto(recToken);
                    this.setEncryptionUser((WSSecEncryptedKey)encr, recToken, false, crypto);
                    encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    encr.setKeyEncAlgo(algorithmSuite.getAsymmetricKeyWrap());
                    encr.prepare((Document)this.saaj.getSOAPPart(), crypto);
                    if (encr.getBSTTokenId() != null) {
                        encr.prependBSTElementToHeader(this.secHeader);
                    }
                    Element encryptedKeyElement = encr.getEncryptedKeyElement();
                    if (externalRef) {
                        Element refList = encr.encryptForExternalRef(null, encrParts);
                        this.insertBeforeBottomUp(refList);
                    } else {
                        Element refList = encr.encryptForInternalRef(null, encrParts);
                        encryptedKeyElement.appendChild(refList);
                    }
                    this.addEncyptedKeyElement(encryptedKeyElement);
                    return encr;
                }
                catch (WSSecurityException e) {
                    this.policyNotAsserted((PolicyAssertion)recToken, e.getMessage());
                }
            }
        }
        return null;
    }

    private void assertUnusedTokens(TokenWrapper wrapper) {
        Collection ais = this.aim.getAssertionInfo(wrapper.getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != wrapper) continue;
            ai.setAsserted(true);
        }
        ais = this.aim.getAssertionInfo(wrapper.getToken().getName());
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() != wrapper.getToken()) continue;
            ai.setAsserted(true);
        }
    }

    private void doSignature(Vector<WSEncryptionPart> sigParts) throws WSSecurityException, SOAPException {
        Token sigToken = null;
        TokenWrapper wrapper = null;
        if (this.isRequestor()) {
            wrapper = this.abinding.getInitiatorToken();
        } else {
            wrapper = this.abinding.getRecipientToken();
            this.assertUnusedTokens(this.abinding.getInitiatorToken());
        }
        sigToken = wrapper.getToken();
        if (sigToken.isDerivedKeys()) {
            this.setupEncryptedKey(wrapper, sigToken);
            WSSecDKSign dkSign = new WSSecDKSign();
            dkSign.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
            dkSign.setSignatureAlgorithm(this.abinding.getAlgorithmSuite().getSymmetricSignature());
            dkSign.setDerivedKeyLength(this.abinding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                dkSign.prepare((Document)this.saaj.getSOAPPart(), this.secHeader);
                if (this.abinding.isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(this.encrKey.getId()));
                }
                dkSign.setParts(sigParts);
                dkSign.addReferencesToSign(sigParts, this.secHeader);
                dkSign.computeSignature();
                this.signatures.add(dkSign.getSignatureValue());
                this.addDerivedKeyElement(dkSign.getdktElement());
                this.insertBeforeBottomUp(dkSign.getSignatureElement());
                this.mainSigId = this.addWsuIdToElement(dkSign.getSignatureElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            AbstractBindingBuilder.WSSecSignatureHelper sig = this.getSignatureBuider(wrapper, sigToken, false);
            if (this.abinding.isTokenProtection() && sig.getBSTTokenId() != null) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            sig.prependBSTElementToHeader(this.secHeader);
            this.insertBeforeBottomUp(sig.getSignatureElement());
            sigParts.addAll(this.getSignedParts());
            AlgorithmSuite algorithmSuite = this.abinding.getAlgorithmSuite();
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setDigestAlgo(algorithmSuite.getDigest());
            sig.setSigCanonicalization(algorithmSuite.getInclusiveC14n());
            sig.addReferencesToSign(sigParts, this.secHeader);
            sig.computeSignature();
            this.signatures.add(sig.getSignatureValue());
            this.mainSigId = this.addWsuIdToElement(sig.getSignatureElement());
        }
    }

    private void setupEncryptedKey(TokenWrapper wrapper, Token token) throws WSSecurityException {
        if (!this.isRequestor() && token.isDerivedKeys()) {
            if (this.encryptedKeyId != null && this.encryptedKeyValue != null) {
                return;
            }
            Object resultsObj = this.message.getExchange().getInMessage().get((Object)"RECV_RESULTS");
            if (resultsObj != null) {
                this.encryptedKeyId = AsymmetricBindingHandler.getRequestEncryptedKeyId((Vector)resultsObj);
                this.encryptedKeyValue = AsymmetricBindingHandler.getRequestEncryptedKeyValue((Vector)resultsObj);
                if (this.encryptedKeyId == null && this.encryptedKeyValue == null) {
                    this.createEncryptedKey(wrapper, token);
                }
            } else {
                this.policyNotAsserted((PolicyAssertion)token, "No security results found");
            }
        } else {
            this.createEncryptedKey(wrapper, token);
        }
    }

    public static String getRequestEncryptedKeyId(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                String encrKeyId = (String)wser.get((Object)"encrypted-key-id");
                if (actInt != 4 || encrKeyId == null) continue;
                return encrKeyId;
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                byte[] decryptedKey = (byte[])wser.get((Object)"decrypted-key");
                if (actInt != 4 || decryptedKey == null) continue;
                return decryptedKey;
            }
        }
        return null;
    }

    private void createEncryptedKey(TokenWrapper wrapper, Token token) throws WSSecurityException {
        this.encrKey = this.getEncryptedKeyBuilder(wrapper, token);
        Element bstElem = this.encrKey.getBinarySecurityTokenElement();
        if (bstElem != null) {
            this.encrKey.prependBSTElementToHeader(this.secHeader);
        }
        this.addEncyptedKeyElement(this.encrKey.getEncryptedKeyElement());
        this.encryptedKeyValue = this.encrKey.getEphemeralKey();
        this.encryptedKeyId = this.encrKey.getId();
        this.message.put(WSSecEncryptedKey.class.getName(), (Object)this.encrKey);
    }
}

