/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SupportingTokenPolicyValidator;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSupportingTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements SupportingTokenPolicyValidator {
    private Message message;
    private List<WSSecurityEngineResult> results;
    private List<WSSecurityEngineResult> signedResults;
    private List<WSSecurityEngineResult> encryptedResults;
    private List<WSSecurityEngineResult> utResults;
    private List<WSSecurityEngineResult> samlResults;
    private boolean validateUsernameToken = true;
    private Element timestamp;
    private boolean signed;
    private boolean encrypted;
    private boolean derived;
    private boolean endorsed;

    @Override
    public void setUsernameTokenResults(List<WSSecurityEngineResult> utResultsList, boolean valUsernameToken) {
        this.utResults = utResultsList;
        this.validateUsernameToken = valUsernameToken;
    }

    @Override
    public void setSAMLTokenResults(List<WSSecurityEngineResult> samlResultsList) {
        this.samlResults = samlResultsList;
    }

    @Override
    public void setTimestampElement(Element timestampElement) {
        this.timestamp = timestampElement;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    public void setResults(List<WSSecurityEngineResult> results) {
        this.results = results;
    }

    public void setSignedResults(List<WSSecurityEngineResult> signedResults) {
        this.signedResults = signedResults;
    }

    public void setEncryptedResults(List<WSSecurityEngineResult> encryptedResults) {
        this.encryptedResults = encryptedResults;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public void setEndorsed(boolean endorsed) {
        this.endorsed = endorsed;
    }

    protected boolean processUsernameTokens() {
        if (!this.validateUsernameToken) {
            return true;
        }
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        tokenResults.addAll(this.utResults);
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.utResults) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            if (!this.endorsed || !this.derived || (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) == null) continue;
            dktResults.add(dktResult);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        return !this.endorsed || this.checkEndorsed(tokenResults);
    }

    protected boolean processSAMLTokens() {
        if (this.samlResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(this.samlResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(this.samlResults)) {
            return false;
        }
        return !this.endorsed || this.checkEndorsed(this.samlResults);
    }

    protected boolean processKerberosTokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            BinarySecurity binarySecurity;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof KerberosSecurity)) continue;
            if (this.endorsed && this.derived && (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) != null) {
                dktResults.add(dktResult);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        return !this.endorsed || this.checkEndorsed(tokenResults);
    }

    protected boolean processX509Tokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            WSSecurityEngineResult resultToStore;
            BinarySecurity binarySecurity;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof X509Security) && !(binarySecurity instanceof PKIPathSecurity)) continue;
            if (this.endorsed && this.derived && (resultToStore = this.processX509DerivedTokenResult(wser)) != null) {
                dktResults.add(resultToStore);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        return !this.endorsed || this.checkEndorsed(tokenResults);
    }

    protected boolean processSCTokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 1024) continue;
            if (this.endorsed && this.derived && (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) != null) {
                dktResults.add(dktResult);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        return !this.endorsed || this.checkEndorsed(tokenResults);
    }

    private WSSecurityEngineResult processX509DerivedTokenResult(WSSecurityEngineResult result) {
        byte[] secret;
        WSSecurityEngineResult dktResult;
        X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
        WSSecurityEngineResult encrResult = this.getMatchingEncryptedKey(cert);
        if (encrResult != null && (dktResult = this.getMatchingDerivedKey(secret = (byte[])encrResult.get((Object)"secret"))) != null) {
            return dktResult;
        }
        return null;
    }

    private WSSecurityEngineResult getMatchingDerivedKey(byte[] secret) {
        for (WSSecurityEngineResult wser : this.results) {
            byte[] dktSecret;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 2048 || !Arrays.equals(secret, dktSecret = (byte[])wser.get((Object)"secret"))) continue;
            return wser;
        }
        return null;
    }

    private WSSecurityEngineResult getMatchingEncryptedKey(X509Certificate cert) {
        for (WSSecurityEngineResult wser : this.results) {
            X509Certificate encrCert;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4 || !cert.equals(encrCert = (X509Certificate)wser.get((Object)"x509-certificate"))) continue;
            return wser;
        }
        return null;
    }

    private boolean isTLSInUse() {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)this.message.get(TLSSessionInfo.class);
        return tlsInfo != null;
    }

    private boolean checkEndorsed(List<WSSecurityEngineResult> tokenResults) {
        if (this.isTLSInUse()) {
            return this.checkTimestampIsSigned(tokenResults);
        }
        return this.checkSignatureIsSigned(tokenResults);
    }

    private boolean areTokensSigned(List<WSSecurityEngineResult> tokens) {
        if (!this.isTLSInUse()) {
            for (WSSecurityEngineResult wser : tokens) {
                Element tokenElement = (Element)wser.get((Object)"token-element");
                if (this.isTokenSigned(tokenElement)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areTokensEncrypted(List<WSSecurityEngineResult> tokens) {
        if (!this.isTLSInUse()) {
            for (WSSecurityEngineResult wser : tokens) {
                Element tokenElement = (Element)wser.get((Object)"token-element");
                if (this.isTokenEncrypted(tokenElement)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkTimestampIsSigned(List<WSSecurityEngineResult> tokenResults) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                if (this.timestamp != dataRef.getProtectedElement() || !this.checkSignature(signedResult, tokenResults)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSignatureIsSigned(List<WSSecurityEngineResult> tokenResults) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null || sl.size() != 1) continue;
            for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.SIGNATURE.equals(signedQName) || !this.checkSignature(signedResult, tokenResults)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSignature(WSSecurityEngineResult signatureResult, List<WSSecurityEngineResult> tokenResult) {
        X509Certificate cert = (X509Certificate)signatureResult.get((Object)"x509-certificate");
        byte[] secret = (byte[])signatureResult.get((Object)"secret");
        for (WSSecurityEngineResult token : tokenResult) {
            Integer actInt = (Integer)token.get((Object)"action");
            BinarySecurity binarySecurity = (BinarySecurity)token.get((Object)"binary-security-token");
            if (binarySecurity instanceof X509Security || binarySecurity instanceof PKIPathSecurity) {
                X509Certificate foundCert = (X509Certificate)token.get((Object)"x509-certificate");
                if (!foundCert.equals(cert)) continue;
                return true;
            }
            if (actInt == 16 || actInt == 8) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)token.get((Object)"saml-assertion");
                SAMLKeyInfo samlKeyInfo = assertionWrapper.getSubjectKeyInfo();
                if (samlKeyInfo == null) continue;
                X509Certificate[] subjectCerts = samlKeyInfo.getCerts();
                byte[] subjectSecretKey = samlKeyInfo.getSecret();
                if (cert != null && subjectCerts != null && cert.equals(subjectCerts[0])) {
                    return true;
                }
                if (subjectSecretKey == null || !Arrays.equals(subjectSecretKey, secret)) continue;
                return true;
            }
            byte[] foundSecret = (byte[])token.get((Object)"secret");
            if (foundSecret != null && Arrays.equals(foundSecret, secret)) {
                return true;
            }
            byte[] derivedKey = (byte[])token.get((Object)"encrypted-ephemeral-key-bytes");
            if (derivedKey == null || !Arrays.equals(derivedKey, secret)) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenSigned(Element token) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            for (WSDataRef dataRef : dataRefs) {
                if (token != dataRef.getProtectedElement()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTokenEncrypted(Element token) {
        for (WSSecurityEngineResult signedResult : this.encryptedResults) {
            List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (dataRefs == null) {
                return false;
            }
            for (WSDataRef dataRef : dataRefs) {
                if (token != dataRef.getProtectedElement()) continue;
                return true;
            }
        }
        return false;
    }
}

