/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.net.URI;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.ClaimsPolicyValidator;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultClaimsPolicyValidator
implements ClaimsPolicyValidator {
    private static final String DEFAULT_CLAIMS_NAMESPACE = "http://schemas.xmlsoap.org/ws/2005/05/identity";

    public boolean validatePolicy(Element claimsPolicy, AssertionWrapper assertion) {
        if (claimsPolicy == null) {
            return false;
        }
        String dialect = claimsPolicy.getAttributeNS(null, "Dialect");
        if (!DEFAULT_CLAIMS_NAMESPACE.equals(dialect)) {
            return false;
        }
        Element claimType = DOMUtils.getFirstElement((Node)claimsPolicy);
        while (claimType != null) {
            if ("ClaimType".equals(claimType.getLocalName())) {
                String claimTypeUri = claimType.getAttributeNS(null, "Uri");
                String claimTypeOptional = claimType.getAttributeNS(null, "Optional");
                if (!(!"".equals(claimTypeOptional) && Boolean.parseBoolean(claimTypeOptional) || this.findClaimInAssertion(assertion, URI.create(claimTypeUri)))) {
                    return false;
                }
            }
            claimType = DOMUtils.getNextElement((Element)claimType);
        }
        return true;
    }

    public String getDialect() {
        return DEFAULT_CLAIMS_NAMESPACE;
    }

    private boolean findClaimInAssertion(AssertionWrapper assertion, URI claimURI) {
        if (assertion.getSaml1() != null) {
            return this.findClaimInAssertion(assertion.getSaml1(), claimURI);
        }
        if (assertion.getSaml2() != null) {
            return this.findClaimInAssertion(assertion.getSaml2(), claimURI);
        }
        return false;
    }

    private boolean findClaimInAssertion(org.opensaml.saml2.core.Assertion assertion, URI claimURI) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return false;
        }
        for (AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                URI attributeNamespace = URI.create(attribute.getNameFormat());
                String desiredRole = attributeNamespace.relativize(claimURI).toString();
                if (!attribute.getName().equals(claimURI.toString()) && !attribute.getName().equals(desiredRole) || attribute.getAttributeValues() == null || attribute.getAttributeValues().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findClaimInAssertion(Assertion assertion, URI claimURI) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            return false;
        }
        for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
            List attributes = statement.getAttributes();
            for (org.opensaml.saml1.core.Attribute attribute : attributes) {
                URI attributeNamespace = URI.create(attribute.getAttributeNamespace());
                String desiredRole = attributeNamespace.relativize(claimURI).toString();
                if (!attribute.getAttributeName().equals(desiredRole) || attribute.getAttributeValues() == null || attribute.getAttributeValues().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

