/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

public class SamlTokenPolicyValidator
extends AbstractSamlPolicyValidator
implements TokenPolicyValidator {
    private Element body;
    private List<WSSecurityEngineResult> signed;

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SAML_TOKEN);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        this.body = soapBody;
        this.signed = signedResults;
        ArrayList samlResults = new ArrayList();
        WSSecurityUtil.fetchAllActionResults(results, (int)16, samlResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)8, samlResults);
        for (AssertionInfo ai : ais) {
            SamlToken samlToken = (SamlToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(samlToken, message)) continue;
            if (samlResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                return false;
            }
            for (WSSecurityEngineResult result : samlResults) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)result.get((Object)"saml-assertion");
                if (!this.checkVersion(samlToken, assertionWrapper)) {
                    ai.setNotAsserted("Wrong SAML Version");
                    return false;
                }
                TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
                Certificate[] tlsCerts = null;
                if (tlsInfo != null) {
                    tlsCerts = tlsInfo.getPeerCertificates();
                }
                if (!this.checkHolderOfKey(assertionWrapper, signedResults, tlsCerts)) {
                    ai.setNotAsserted("Assertion fails holder-of-key requirements");
                    return false;
                }
                if (SAMLUtils.checkSenderVouches(assertionWrapper, tlsCerts, this.body, this.signed)) continue;
                ai.setNotAsserted("Assertion fails sender-vouches requirements");
                return false;
            }
        }
        return true;
    }

    private boolean checkVersion(SamlToken samlToken, AssertionWrapper assertionWrapper) {
        if ((samlToken.isUseSamlVersion11Profile10() || samlToken.isUseSamlVersion11Profile11()) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
            return false;
        }
        return !samlToken.isUseSamlVersion20Profile11() || assertionWrapper.getSamlVersion() == SAMLVersion.VERSION_20;
    }
}

