/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.w3c.dom.Element;

public class WSS11PolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.WSS11);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        List<WSSecurityEngineResult> scResults = WSS4JUtils.fetchAllActionResults(results, 128);
        for (AssertionInfo ai : ais) {
            Wss11 wss11 = (Wss11)ai.getAssertion();
            ai.setAsserted(true);
            if (!MessageUtils.isRequestor((Message)message) || (!wss11.isRequireSignatureConfirmation() || !scResults.isEmpty()) && (wss11.isRequireSignatureConfirmation() || scResults.isEmpty())) continue;
            ai.setNotAsserted("Signature Confirmation policy validation failed");
        }
        return true;
    }
}

