/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.IssuedTokenPolicyValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.Trust10;
import org.apache.wss4j.policy.model.Trust13;
import org.w3c.dom.Element;

public class IssuedTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(IssuedTokenInterceptorProvider.class);
    private static final long serialVersionUID = -6936475570762840527L;
    private static final String ASSOCIATED_TOKEN = IssuedTokenInterceptorProvider.class.getName() + "-" + "Associated_Token";

    public IssuedTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN));
        PolicyBasedWSS4JInInterceptor in = new PolicyBasedWSS4JInInterceptor();
        this.getOutInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getInInterceptors().add(in);
        this.getInFaultInterceptors().add(in);
        this.getOutInterceptors().add(new IssuedTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new IssuedTokenOutInterceptor());
        this.getInInterceptors().add(new IssuedTokenInInterceptor());
        this.getInFaultInterceptors().add(new IssuedTokenInInterceptor());
        PolicyBasedWSS4JStaxOutInterceptor so = new PolicyBasedWSS4JStaxOutInterceptor();
        PolicyBasedWSS4JStaxInInterceptor si = new PolicyBasedWSS4JStaxInInterceptor();
        this.getOutInterceptors().add(so);
        this.getOutFaultInterceptors().add(so);
        this.getInInterceptors().add(si);
        this.getInFaultInterceptors().add(si);
    }

    protected static void assertIssuedToken(IssuedToken issuedToken, AssertionInfoMap aim) {
        if (issuedToken == null) {
            return;
        }
        if (issuedToken.isRequireExternalReference()) {
            IssuedTokenInterceptorProvider.assertPolicy(new QName(issuedToken.getName().getNamespaceURI(), "RequireExternalReference"), aim);
        }
        if (issuedToken.isRequireInternalReference()) {
            IssuedTokenInterceptorProvider.assertPolicy(new QName(issuedToken.getName().getNamespaceURI(), "RequireInternalReference"), aim);
        }
    }

    protected static void assertPolicy(QName n, AssertionInfoMap aim) {
        Collection ais = aim.getAssertionInfo(n);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    static class IssuedTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "IssuedToken");
                if (ais.isEmpty()) {
                    return;
                }
                IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                if (!this.isRequestor(message)) {
                    message.getExchange().remove((Object)"ws-security.token");
                    List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                    if (results != null && results.size() > 0) {
                        this.parseHandlerResults((WSHandlerResult)results.get(0), message, ais);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void parseHandlerResults(WSHandlerResult rResult, Message message, Collection<AssertionInfo> issuedAis) {
            boolean valid;
            List signedResults = WSSecurityUtil.fetchAllActionResults((List)rResult.getResults(), (int)2);
            IssuedTokenPolicyValidator issuedValidator = new IssuedTokenPolicyValidator(signedResults, message);
            for (SamlAssertionWrapper assertionWrapper : this.findSamlTokenResults(rResult.getResults())) {
                valid = issuedValidator.validatePolicy(issuedAis, assertionWrapper);
                if (!valid) continue;
                SecurityToken token = this.createSecurityToken(assertionWrapper);
                message.getExchange().put((Object)"ws-security.token", (Object)token);
                return;
            }
            for (BinarySecurity binarySecurityToken : this.findBinarySecurityTokenResults(rResult.getResults())) {
                valid = issuedValidator.validatePolicy(issuedAis, binarySecurityToken);
                if (!valid) continue;
                SecurityToken token = this.createSecurityToken(binarySecurityToken);
                message.getExchange().put((Object)"ws-security.token", (Object)token);
                return;
            }
        }

        private List<SamlAssertionWrapper> findSamlTokenResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<SamlAssertionWrapper> results = new ArrayList<SamlAssertionWrapper>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 16 && actInt != 8) continue;
                results.add((SamlAssertionWrapper)wser.get((Object)"saml-assertion"));
            }
            return results;
        }

        private List<BinarySecurity> findBinarySecurityTokenResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<BinarySecurity> results = new ArrayList<BinarySecurity>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4096 || !Boolean.TRUE.equals(wser.get((Object)"validated-token"))) continue;
                results.add((BinarySecurity)wser.get((Object)"binary-security-token"));
            }
            return results;
        }

        private SecurityToken createSecurityToken(SamlAssertionWrapper assertionWrapper) {
            SecurityToken token = new SecurityToken(assertionWrapper.getId());
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (subjectKeyInfo != null) {
                token.setSecret(subjectKeyInfo.getSecret());
                X509Certificate[] certs = subjectKeyInfo.getCerts();
                if (certs != null && certs.length > 0) {
                    token.setX509Certificate(certs[0], null);
                }
            }
            if (assertionWrapper.getSaml1() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            } else if (assertionWrapper.getSaml2() != null) {
                token.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            }
            token.setToken(assertionWrapper.getElement());
            return token;
        }

        private SecurityToken createSecurityToken(BinarySecurity binarySecurityToken) {
            SecurityToken token = new SecurityToken(binarySecurityToken.getID());
            token.setToken(binarySecurityToken.getElement());
            token.setSecret(binarySecurityToken.getToken());
            token.setTokenType(binarySecurityToken.getValueType());
            return token;
        }
    }

    static class IssuedTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenOutInterceptor() {
            super("prepare-send");
        }

        private static void mapSecurityProps(Message message, Map<String, Object> ctx) {
            for (String s : SecurityConstants.ALL_PROPERTIES) {
                Object v = message.getContextualProperty(s + ".it");
                if (v == null) {
                    v = message.getContextualProperty(s);
                }
                if (ctx.containsKey(s) || v == null) continue;
                ctx.put(s, v);
            }
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "IssuedToken");
                if (ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                    IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                    SecurityToken tok = this.retrieveCachedToken(message);
                    tok = tok == null ? this.issueToken(message, aim, itok) : this.renewToken(message, aim, itok, tok);
                    if (tok != null) {
                        boolean cacheIssuedToken;
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        boolean bl = cacheIssuedToken = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.cache.issued.token.in.endpoint", (boolean)true) && !this.isOneTimeUse(tok);
                        if (cacheIssuedToken) {
                            ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token", (Object)tok);
                            message.getExchange().put((Object)"ws-security.token", (Object)tok);
                            message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                            ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                        } else {
                            message.put((Object)"ws-security.token", (Object)tok);
                            message.put((Object)"ws-security.token.id", (Object)tok.getId());
                        }
                        WSS4JUtils.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    IssuedToken itok = (IssuedToken)ais.iterator().next().getAssertion();
                    IssuedTokenInterceptorProvider.assertIssuedToken(itok, aim);
                }
            }
        }

        private Trust10 getTrust10(AssertionInfoMap aim) {
            Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "Trust10");
            if (ais.isEmpty()) {
                return null;
            }
            return (Trust10)ais.iterator().next().getAssertion();
        }

        private Trust13 getTrust13(AssertionInfoMap aim) {
            Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "Trust13");
            if (ais.isEmpty()) {
                return null;
            }
            return (Trust13)ais.iterator().next().getAssertion();
        }

        private boolean isOneTimeUse(SecurityToken issuedToken) {
            Element token = issuedToken.getToken();
            if (token != null && "Assertion".equals(token.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(token.getNamespaceURI())) {
                try {
                    SamlAssertionWrapper assertion = new SamlAssertionWrapper(token);
                    if (assertion.getSaml2().getConditions() != null && assertion.getSaml2().getConditions().getOneTimeUse() != null) {
                        return true;
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            return false;
        }

        private SecurityToken retrieveCachedToken(Message message) {
            boolean cacheIssuedToken = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.cache.issued.token.in.endpoint", (boolean)true);
            SecurityToken tok = null;
            if (cacheIssuedToken) {
                String tokId;
                tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                    tok = WSS4JUtils.getTokenStore(message).getToken(tokId);
                }
            } else {
                String tokId;
                tok = (SecurityToken)message.get((Object)"ws-security.token");
                if (tok == null && (tokId = (String)message.get((Object)"ws-security.token.id")) != null) {
                    tok = WSS4JUtils.getTokenStore(message).getToken(tokId);
                }
            }
            return tok;
        }

        private SecurityToken handleDelegation(Message message, Element onBehalfOfToken, Element actAsToken, String appliesTo, boolean enableAppliesTo) throws Exception {
            String associatedToken;
            SecurityToken issuedToken;
            Properties properties;
            String id;
            SecurityToken cachedToken;
            TokenStore tokenStore = WSS4JUtils.getTokenStore(message);
            String key = appliesTo;
            if (!enableAppliesTo || key == null || "".equals(key)) {
                key = ASSOCIATED_TOKEN;
            }
            if (onBehalfOfToken != null && (cachedToken = tokenStore.getToken(id = this.getIdFromToken(onBehalfOfToken))) != null && (properties = cachedToken.getProperties()) != null && properties.containsKey(key) && (issuedToken = tokenStore.getToken(associatedToken = properties.getProperty(key))) != null) {
                return issuedToken;
            }
            if (actAsToken != null && (cachedToken = tokenStore.getToken(id = this.getIdFromToken(actAsToken))) != null && (properties = cachedToken.getProperties()) != null && properties.containsKey(key) && (issuedToken = tokenStore.getToken(associatedToken = properties.getProperty(key))) != null) {
                return issuedToken;
            }
            return null;
        }

        private String getIdFromToken(Element token) {
            if (token != null) {
                if (token.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
                    return token.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                }
                if (token.hasAttributeNS(null, "ID")) {
                    return token.getAttributeNS(null, "ID");
                }
                if (token.hasAttributeNS(null, "AssertionID")) {
                    return token.getAttributeNS(null, "AssertionID");
                }
            }
            return "";
        }

        private void storeDelegationTokens(Message message, SecurityToken issuedToken, Element onBehalfOfToken, Element actAsToken, String appliesTo, boolean enableAppliesTo) throws Exception {
            Properties properties;
            SecurityToken cachedToken;
            String id;
            if (issuedToken == null) {
                return;
            }
            TokenStore tokenStore = WSS4JUtils.getTokenStore(message);
            String key = appliesTo;
            if (!enableAppliesTo || key == null || "".equals(key)) {
                key = ASSOCIATED_TOKEN;
            }
            if (onBehalfOfToken != null) {
                id = this.getIdFromToken(onBehalfOfToken);
                cachedToken = tokenStore.getToken(id);
                if (cachedToken == null) {
                    cachedToken = new SecurityToken(id);
                    cachedToken.setToken(onBehalfOfToken);
                }
                if ((properties = cachedToken.getProperties()) == null) {
                    properties = new Properties();
                    cachedToken.setProperties(properties);
                }
                properties.put(key, issuedToken.getId());
                tokenStore.add(cachedToken);
            }
            if (actAsToken != null) {
                id = this.getIdFromToken(actAsToken);
                cachedToken = tokenStore.getToken(id);
                if (cachedToken == null) {
                    cachedToken = new SecurityToken(id);
                    cachedToken.setToken(actAsToken);
                }
                if ((properties = cachedToken.getProperties()) == null) {
                    properties = new Properties();
                    cachedToken.setProperties(properties);
                }
                properties.put(key, issuedToken.getId());
                tokenStore.add(cachedToken);
            }
        }

        private SecurityToken getTokenFromSTS(Message message, STSClient client, AssertionInfoMap aim, AddressingProperties maps, IssuedToken itok, String appliesTo) throws Exception {
            client.setTrust(this.getTrust10(aim));
            client.setTrust((Trust10)this.getTrust13(aim));
            client.setTemplate(itok.getRequestSecurityTokenTemplate());
            if (itok.getPolicy() != null && itok.getPolicy().getNamespace() != null) {
                client.setWspNamespace(itok.getPolicy().getNamespace());
            }
            if (maps != null && maps.getNamespaceURI() != null) {
                client.setAddressingNamespace(maps.getNamespaceURI());
            }
            if (itok.getClaims() != null) {
                client.setClaims(itok.getClaims());
            }
            return client.requestSecurityToken(appliesTo);
        }

        private SecurityToken renewToken(Message message, AssertionInfoMap aim, IssuedToken itok, SecurityToken tok) {
            String imminentExpiryValue = (String)message.getContextualProperty("ws-security.sts.token.imminent-expiry-value");
            long imminentExpiry = 10L;
            if (imminentExpiryValue != null) {
                imminentExpiry = Long.parseLong(imminentExpiryValue);
            }
            if (!tok.isExpired() && !tok.isAboutToExpire(imminentExpiry)) {
                return tok;
            }
            ((Endpoint)message.getExchange().get(Endpoint.class)).remove((Object)"ws-security.token");
            ((Endpoint)message.getExchange().get(Endpoint.class)).remove((Object)"ws-security.token.id");
            message.getExchange().remove((Object)"ws-security.token.id");
            message.getExchange().remove((Object)"ws-security.token");
            NegotiationUtils.getTokenStore(message).remove(tok.getId());
            STSClient client = STSUtils.getClient(message, "sts", itok);
            if (!client.isAllowRenewing()) {
                return this.issueToken(message, aim, itok);
            }
            AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
            if (maps == null) {
                maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    Map<String, Object> ctx = client.getRequestContext();
                    IssuedTokenOutInterceptor.mapSecurityProps(message, ctx);
                    client.setMessage(message);
                    if (maps != null && maps.getNamespaceURI() != null) {
                        client.setAddressingNamespace(maps.getNamespaceURI());
                    }
                    client.setTrust(this.getTrust10(aim));
                    client.setTrust((Trust10)this.getTrust13(aim));
                    client.setTemplate(itok.getRequestSecurityTokenTemplate());
                    return client.renewSecurityToken(tok);
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "Error renewing a token", ex);
                    boolean issueAfterFailedRenew = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.issue.after.failed.renew", (boolean)true);
                    if (issueAfterFailedRenew) {
                        return this.issueToken(message, aim, itok);
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Error renewing a token", ex);
                    boolean issueAfterFailedRenew = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.issue.after.failed.renew", (boolean)true);
                    if (issueAfterFailedRenew) {
                        return this.issueToken(message, aim, itok);
                    }
                    throw new Fault((Throwable)ex);
                }
            }
        }

        private SecurityToken issueToken(Message message, AssertionInfoMap aim, IssuedToken itok) {
            STSClient client = STSUtils.getClient(message, "sts", itok);
            AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
            if (maps == null) {
                maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
            }
            STSClient sTSClient = client;
            synchronized (sTSClient) {
                try {
                    Object token = message.getContextualProperty("ws-security.sts.token.act-as");
                    if (token != null) {
                        client.setActAs(token);
                    }
                    if ((token = message.getContextualProperty("ws-security.sts.token.on-behalf-of")) != null) {
                        client.setOnBehalfOf(token);
                    }
                    Map<String, Object> ctx = client.getRequestContext();
                    IssuedTokenOutInterceptor.mapSecurityProps(message, ctx);
                    Object o = message.getContextualProperty("ws-security.sts.applies-to");
                    String appliesTo = o == null ? null : o.toString();
                    appliesTo = appliesTo == null ? message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString() : appliesTo;
                    boolean enableAppliesTo = client.isEnableAppliesTo();
                    client.setMessage(message);
                    Element onBehalfOfToken = client.getOnBehalfOfToken();
                    Element actAsToken = client.getActAsToken();
                    SecurityToken secToken = this.handleDelegation(message, onBehalfOfToken, actAsToken, appliesTo, enableAppliesTo);
                    secToken = secToken != null ? this.renewToken(message, aim, itok, secToken) : this.getTokenFromSTS(message, client, aim, maps, itok, appliesTo);
                    this.storeDelegationTokens(message, secToken, onBehalfOfToken, actAsToken, appliesTo, enableAppliesTo);
                    return secToken;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
        }
    }
}

