// $ANTLR 2.7.7 (20060906): "ACIItemChecker.g" -> "AntlrACIItemChecker.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.api.ldap.aci;


import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated ACIItem checker.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrACIItemChecker extends antlr.LLkParser       implements AntlrACIItemCheckerTokenTypes
 {

    NameComponentNormalizer normalizer;
    
    /**
     * Creates a (normalizing) subordinate DnParser for parsing Names.
     * This method MUST be called for each instance while we cannot do
     * constructor overloading for this class.
     *
     * @return the DnParser to be used for parsing Names
     */
    public void init()
    {
    }

    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     */
    public void setNormalizer(NameComponentNormalizer normalizer)
    {
        this.normalizer = normalizer;
    }

protected AntlrACIItemChecker(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrACIItemChecker(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenStream lexer) {
  this(lexer,1);
}

public AntlrACIItemChecker(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final void wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop3:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop3;
			}
			
		} while (true);
		}
		theACIItem();
		{
		_loop5:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop5;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
	}
	
	public final void theACIItem() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop8:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop8;
			}
			
		} while (true);
		}
		mainACIItemComponent();
		{
		_loop10:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop10;
			}
			
		} while (true);
		}
		{
		_loop16:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop13:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop13;
					}
					
				} while (true);
				}
				mainACIItemComponent();
				{
				_loop15:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop15;
					}
					
				} while (true);
				}
			}
			else {
				break _loop16;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_identificationTag:
		{
			aci_identificationTag();
			break;
		}
		case ID_precedence:
		{
			aci_precedence();
			break;
		}
		case ID_authenticationLevel:
		{
			aci_authenticationLevel();
			break;
		}
		case ID_itemOrUserFirst:
		{
			aci_itemOrUserFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
		
		
		match(ID_identificationTag);
		{
		int _cnt20=0;
		_loop20:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt20>=1 ) { break _loop20; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt20++;
		} while (true);
		}
		match(SAFEUTF8STRING);
	}
	
	public final void aci_precedence() throws RecognitionException, TokenStreamException {
		
		
		precedence();
	}
	
	public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		match(ID_authenticationLevel);
		{
		int _cnt27=0;
		_loop27:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt27>=1 ) { break _loop27; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt27++;
		} while (true);
		}
		authenticationLevel();
	}
	
	public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemOrUserFirst);
		{
		int _cnt31=0;
		_loop31:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt31>=1 ) { break _loop31; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt31++;
		} while (true);
		}
		itemOrUserFirst();
	}
	
	public final void precedence() throws RecognitionException, TokenStreamException {
		
		
		match(ID_precedence);
		{
		int _cnt24=0;
		_loop24:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt24>=1 ) { break _loop24; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt24++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_none:
		{
			match(ID_none);
			break;
		}
		case ID_simple:
		{
			match(ID_simple);
			break;
		}
		case ID_strong:
		{
			match(ID_strong);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_itemFirst:
		{
			itemFirst();
			break;
		}
		case ID_userFirst:
		{
			userFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemFirst);
		{
		_loop35:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop35;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop37:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop37;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop39:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop39;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_protectedItems:
		{
			protectedItems();
			{
			_loop42:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop42;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop44:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop44;
				}
				
			} while (true);
			}
			itemPermissions();
			break;
		}
		case ID_itemPermissions:
		{
			itemPermissions();
			{
			_loop46:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop46;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop48:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop48;
				}
				
			} while (true);
			}
			protectedItems();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop50:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop50;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userFirst);
		{
		_loop53:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop53;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop55:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop55;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop57:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop57;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_userClasses:
		{
			userClasses();
			{
			_loop60:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop60;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop62:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop62;
				}
				
			} while (true);
			}
			userPermissions();
			break;
		}
		case ID_userPermissions:
		{
			userPermissions();
			{
			_loop64:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop64;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop66:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop66;
				}
				
			} while (true);
			}
			userClasses();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop68:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop68;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItems() throws RecognitionException, TokenStreamException {
		
		
		match(ID_protectedItems);
		{
		_loop71:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop71;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop73:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop73;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ATTRIBUTE_VALUE_CANDIDATE:
		case RANGE_OF_VALUES_CANDIDATE:
		case ID_entry:
		case ID_allUserAttributeTypes:
		case ID_attributeType:
		case ID_allAttributeValues:
		case ID_allUserAttributeTypesAndValues:
		case ID_selfValue:
		case ID_maxValueCount:
		case ID_maxImmSub:
		case ID_restrictedBy:
		case ID_classes:
		{
			protectedItem();
			{
			_loop76:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop76;
				}
				
			} while (true);
			}
			{
			_loop82:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop79:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop79;
						}
						
					} while (true);
					}
					protectedItem();
					{
					_loop81:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop81;
						}
						
					} while (true);
					}
				}
				else {
					break _loop82;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void itemPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemPermissions);
		{
		int _cnt187=0;
		_loop187:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt187>=1 ) { break _loop187; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt187++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop189:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop189;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			itemPermission();
			{
			_loop192:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop192;
				}
				
			} while (true);
			}
			{
			_loop198:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop195:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop195;
						}
						
					} while (true);
					}
					itemPermission();
					{
					_loop197:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop197;
						}
						
					} while (true);
					}
				}
				else {
					break _loop198;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userClasses() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userClasses);
		{
		int _cnt228=0;
		_loop228:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt228>=1 ) { break _loop228; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt228++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop230:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop230;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_allUsers:
		case ID_thisEntry:
		case ID_parentOfEntry:
		case ID_name:
		case ID_userGroup:
		case ID_subtree:
		{
			userClass();
			{
			_loop233:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop233;
				}
				
			} while (true);
			}
			{
			_loop239:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop236:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop236;
						}
						
					} while (true);
					}
					userClass();
					{
					_loop238:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop238;
						}
						
					} while (true);
					}
				}
				else {
					break _loop239;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userPermissions);
		{
		int _cnt285=0;
		_loop285:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt285>=1 ) { break _loop285; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt285++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop287:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop287;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			userPermission();
			{
			_loop290:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop290;
				}
				
			} while (true);
			}
			{
			_loop296:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop293:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop293;
						}
						
					} while (true);
					}
					userPermission();
					{
					_loop295:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop295;
						}
						
					} while (true);
					}
				}
				else {
					break _loop296;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItem() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			entry();
			break;
		}
		case ID_allUserAttributeTypes:
		{
			allUserAttributeTypes();
			break;
		}
		case ID_attributeType:
		{
			attributeType();
			break;
		}
		case ID_allAttributeValues:
		{
			allAttributeValues();
			break;
		}
		case ID_allUserAttributeTypesAndValues:
		{
			allUserAttributeTypesAndValues();
			break;
		}
		case ATTRIBUTE_VALUE_CANDIDATE:
		{
			attributeValue();
			break;
		}
		case ID_selfValue:
		{
			selfValue();
			break;
		}
		case RANGE_OF_VALUES_CANDIDATE:
		{
			rangeOfValues();
			break;
		}
		case ID_maxValueCount:
		{
			maxValueCount();
			break;
		}
		case ID_maxImmSub:
		{
			maxImmSub();
			break;
		}
		case ID_restrictedBy:
		{
			restrictedBy();
			break;
		}
		case ID_classes:
		{
			classes();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void entry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_entry);
	}
	
	public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypes);
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		
		match(ID_attributeType);
		{
		int _cnt88=0;
		_loop88:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt88>=1 ) { break _loop88; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt88++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allAttributeValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allAttributeValues);
		{
		int _cnt91=0;
		_loop91:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt91>=1 ) { break _loop91; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt91++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypesAndValues);
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		
		match(ATTRIBUTE_VALUE_CANDIDATE);
	}
	
	public final void selfValue() throws RecognitionException, TokenStreamException {
		
		
		match(ID_selfValue);
		{
		int _cnt96=0;
		_loop96:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt96>=1 ) { break _loop96; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt96++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void rangeOfValues() throws RecognitionException, TokenStreamException {
		
		
		match(RANGE_OF_VALUES_CANDIDATE);
	}
	
	public final void maxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxValueCount);
		{
		int _cnt100=0;
		_loop100:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt100>=1 ) { break _loop100; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt100++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop102:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop102;
			}
			
		} while (true);
		}
		aMaxValueCount();
		{
		_loop104:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop104;
			}
			
		} while (true);
		}
		{
		_loop110:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop107:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop107;
					}
					
				} while (true);
				}
				aMaxValueCount();
				{
				_loop109:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop109;
					}
					
				} while (true);
				}
			}
			else {
				break _loop110;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void maxImmSub() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxImmSub);
		{
		int _cnt135=0;
		_loop135:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt135>=1 ) { break _loop135; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt135++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void restrictedBy() throws RecognitionException, TokenStreamException {
		
		
		match(ID_restrictedBy);
		{
		int _cnt138=0;
		_loop138:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt138>=1 ) { break _loop138; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt138++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop140:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop140;
			}
			
		} while (true);
		}
		restrictedValue();
		{
		_loop142:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop142;
			}
			
		} while (true);
		}
		{
		_loop148:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop145:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop145;
					}
					
				} while (true);
				}
				restrictedValue();
				{
				_loop147:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop147;
					}
					
				} while (true);
				}
			}
			else {
				break _loop148;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void classes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_classes);
		{
		int _cnt184=0;
		_loop184:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt184>=1 ) { break _loop184; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt184++;
		} while (true);
		}
		refinement();
	}
	
	public final void attributeTypeSet() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop173:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop173;
			}
			
		} while (true);
		}
		oid();
		{
		_loop175:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop175;
			}
			
		} while (true);
		}
		{
		_loop181:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop178:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop178;
					}
					
				} while (true);
				}
				oid();
				{
				_loop180:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop180;
					}
					
				} while (true);
				}
			}
			else {
				break _loop181;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void aMaxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop113:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop113;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt116=0;
			_loop116:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt116>=1 ) { break _loop116; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt116++;
			} while (true);
			}
			oid();
			{
			_loop118:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop118;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop120:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop120;
				}
				
			} while (true);
			}
			match(ID_maxCount);
			{
			int _cnt122=0;
			_loop122:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt122>=1 ) { break _loop122; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt122++;
			} while (true);
			}
			match(INTEGER);
			break;
		}
		case ID_maxCount:
		{
			match(ID_maxCount);
			{
			int _cnt124=0;
			_loop124:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt124>=1 ) { break _loop124; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt124++;
			} while (true);
			}
			match(INTEGER);
			{
			_loop126:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop126;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop128:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop128;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt130=0;
			_loop130:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt130>=1 ) { break _loop130; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt130++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop132:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop132;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void oid() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void restrictedValue() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop151:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop151;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt154=0;
			_loop154:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt154>=1 ) { break _loop154; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt154++;
			} while (true);
			}
			oid();
			{
			_loop156:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop156;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop158:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop158;
				}
				
			} while (true);
			}
			match(ID_valuesIn);
			{
			int _cnt160=0;
			_loop160:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt160>=1 ) { break _loop160; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt160++;
			} while (true);
			}
			oid();
			break;
		}
		case ID_valuesIn:
		{
			match(ID_valuesIn);
			{
			int _cnt162=0;
			_loop162:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt162>=1 ) { break _loop162; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt162++;
			} while (true);
			}
			oid();
			{
			_loop164:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop164;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop166:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop166;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt168=0;
			_loop168:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt168>=1 ) { break _loop168; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt168++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop170:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop170;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void refinement() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			item();
			break;
		}
		case ID_and:
		{
			and();
			break;
		}
		case ID_or:
		{
			or();
			break;
		}
		case ID_not:
		{
			not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop201:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop201;
			}
			
		} while (true);
		}
		anyItemPermission();
		{
		_loop203:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop203;
			}
			
		} while (true);
		}
		{
		_loop209:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop206:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop206;
					}
					
				} while (true);
				}
				anyItemPermission();
				{
				_loop208:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop208;
					}
					
				} while (true);
				}
			}
			else {
				break _loop209;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyItemPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_userClasses:
		{
			userClasses();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
		
		
		match(ID_grantsAndDenials);
		{
		int _cnt213=0;
		_loop213:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt213>=1 ) { break _loop213; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt213++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop215:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop215;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_grantAdd:
		case ID_denyAdd:
		case ID_grantDiscloseOnError:
		case ID_denyDiscloseOnError:
		case ID_grantRead:
		case ID_denyRead:
		case ID_grantRemove:
		case ID_denyRemove:
		case ID_grantBrowse:
		case ID_denyBrowse:
		case ID_grantExport:
		case ID_denyExport:
		case ID_grantImport:
		case ID_denyImport:
		case ID_grantModify:
		case ID_denyModify:
		case ID_grantRename:
		case ID_denyRename:
		case ID_grantReturnDN:
		case ID_denyReturnDN:
		case ID_grantCompare:
		case ID_denyCompare:
		case ID_grantFilterMatch:
		case ID_denyFilterMatch:
		case ID_grantInvoke:
		case ID_denyInvoke:
		{
			grantAndDenial();
			{
			_loop218:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop218;
				}
				
			} while (true);
			}
			{
			_loop224:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop221:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop221;
						}
						
					} while (true);
					}
					grantAndDenial();
					{
					_loop223:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop223;
						}
						
					} while (true);
					}
				}
				else {
					break _loop224;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void grantAndDenial() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_grantAdd:
		{
			match(ID_grantAdd);
			break;
		}
		case ID_denyAdd:
		{
			match(ID_denyAdd);
			break;
		}
		case ID_grantDiscloseOnError:
		{
			match(ID_grantDiscloseOnError);
			break;
		}
		case ID_denyDiscloseOnError:
		{
			match(ID_denyDiscloseOnError);
			break;
		}
		case ID_grantRead:
		{
			match(ID_grantRead);
			break;
		}
		case ID_denyRead:
		{
			match(ID_denyRead);
			break;
		}
		case ID_grantRemove:
		{
			match(ID_grantRemove);
			break;
		}
		case ID_denyRemove:
		{
			match(ID_denyRemove);
			break;
		}
		case ID_grantBrowse:
		{
			match(ID_grantBrowse);
			break;
		}
		case ID_denyBrowse:
		{
			match(ID_denyBrowse);
			break;
		}
		case ID_grantExport:
		{
			match(ID_grantExport);
			break;
		}
		case ID_denyExport:
		{
			match(ID_denyExport);
			break;
		}
		case ID_grantImport:
		{
			match(ID_grantImport);
			break;
		}
		case ID_denyImport:
		{
			match(ID_denyImport);
			break;
		}
		case ID_grantModify:
		{
			match(ID_grantModify);
			break;
		}
		case ID_denyModify:
		{
			match(ID_denyModify);
			break;
		}
		case ID_grantRename:
		{
			match(ID_grantRename);
			break;
		}
		case ID_denyRename:
		{
			match(ID_denyRename);
			break;
		}
		case ID_grantReturnDN:
		{
			match(ID_grantReturnDN);
			break;
		}
		case ID_denyReturnDN:
		{
			match(ID_denyReturnDN);
			break;
		}
		case ID_grantCompare:
		{
			match(ID_grantCompare);
			break;
		}
		case ID_denyCompare:
		{
			match(ID_denyCompare);
			break;
		}
		case ID_grantFilterMatch:
		{
			match(ID_grantFilterMatch);
			break;
		}
		case ID_denyFilterMatch:
		{
			match(ID_denyFilterMatch);
			break;
		}
		case ID_grantInvoke:
		{
			match(ID_grantInvoke);
			break;
		}
		case ID_denyInvoke:
		{
			match(ID_denyInvoke);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void userClass() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_allUsers:
		{
			allUsers();
			break;
		}
		case ID_thisEntry:
		{
			thisEntry();
			break;
		}
		case ID_parentOfEntry:
		{
			parentOfEntry();
			break;
		}
		case ID_name:
		{
			name();
			break;
		}
		case ID_userGroup:
		{
			userGroup();
			break;
		}
		case ID_subtree:
		{
			subtree();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void allUsers() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUsers);
	}
	
	public final void thisEntry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_thisEntry);
	}
	
	public final void parentOfEntry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_parentOfEntry);
	}
	
	public final void name() throws RecognitionException, TokenStreamException {
		
		
		match(ID_name);
		{
		int _cnt246=0;
		_loop246:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt246>=1 ) { break _loop246; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt246++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop248:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop248;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop250:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop250;
			}
			
		} while (true);
		}
		{
		_loop256:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop253:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop253;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop255:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop255;
					}
					
				} while (true);
				}
			}
			else {
				break _loop256;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userGroup() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userGroup);
		{
		int _cnt259=0;
		_loop259:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt259>=1 ) { break _loop259; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt259++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop261:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop261;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop263:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop263;
			}
			
		} while (true);
		}
		{
		_loop269:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop266:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop266;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop268:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop268;
					}
					
				} while (true);
				}
			}
			else {
				break _loop269;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		
		match(ID_subtree);
		{
		int _cnt272=0;
		_loop272:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt272>=1 ) { break _loop272; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt272++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop274:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop274;
			}
			
		} while (true);
		}
		subtreeSpecification();
		{
		_loop276:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop276;
			}
			
		} while (true);
		}
		{
		_loop282:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop279:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop279;
					}
					
				} while (true);
				}
				subtreeSpecification();
				{
				_loop281:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop281;
					}
					
				} while (true);
				}
			}
			else {
				break _loop282;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void distinguishedName() throws RecognitionException, TokenStreamException {
		
		
		match(SAFEUTF8STRING);
	}
	
	public final void subtreeSpecification() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop311:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop311;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		{
			subtreeSpecificationComponent();
			{
			_loop314:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop314;
				}
				
			} while (true);
			}
			{
			_loop320:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop317:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop317;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop319:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop319;
						}
						
					} while (true);
					}
				}
				else {
					break _loop320;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop299:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop299;
			}
			
		} while (true);
		}
		anyUserPermission();
		{
		_loop301:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop301;
			}
			
		} while (true);
		}
		{
		_loop307:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop304:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop304;
					}
					
				} while (true);
				}
				anyUserPermission();
				{
				_loop306:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop306;
					}
					
				} while (true);
				}
			}
			else {
				break _loop307;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyUserPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_protectedItems:
		{
			protectedItems();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_base:
		{
			ss_base();
			break;
		}
		case ID_specificExclusions:
		{
			ss_specificExclusions();
			break;
		}
		case ID_minimum:
		{
			ss_minimum();
			break;
		}
		case ID_maximum:
		{
			ss_maximum();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		match(ID_base);
		{
		int _cnt324=0;
		_loop324:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt324>=1 ) { break _loop324; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt324++;
		} while (true);
		}
		distinguishedName();
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_specificExclusions);
		{
		int _cnt327=0;
		_loop327:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt327>=1 ) { break _loop327; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt327++;
		} while (true);
		}
		specificExclusions();
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_minimum);
		{
		int _cnt353=0;
		_loop353:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt353>=1 ) { break _loop353; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt353++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maximum);
		{
		int _cnt356=0;
		_loop356:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt356>=1 ) { break _loop356; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt356++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop330:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop330;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop333:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop333;
				}
				
			} while (true);
			}
			{
			_loop339:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop336:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop336;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop338:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop338;
						}
						
					} while (true);
					}
				}
				else {
					break _loop339;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopBefore);
		{
		_loop343:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop343;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop345:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop345;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopAfter);
		{
		_loop348:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop348;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop350:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop350;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void baseDistance() throws RecognitionException, TokenStreamException {
		
		
		match(INTEGER);
	}
	
	public final void item() throws RecognitionException, TokenStreamException {
		
		
		match(ID_item);
		{
		_loop364:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop364;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop366:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop366;
			}
			
		} while (true);
		}
		oid();
	}
	
	public final void and() throws RecognitionException, TokenStreamException {
		
		
		match(ID_and);
		{
		_loop369:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop369;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop371:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop371;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void or() throws RecognitionException, TokenStreamException {
		
		
		match(ID_or);
		{
		_loop374:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop374;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop376:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop376;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void not() throws RecognitionException, TokenStreamException {
		
		
		match(ID_not);
		{
		_loop379:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop379;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop381:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop381;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void refinements() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop384:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop384;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			refinement();
			{
			_loop387:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop387;
				}
				
			} while (true);
			}
			{
			_loop393:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop390:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop390;
						}
						
					} while (true);
					}
					refinement();
					{
					_loop392:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop392;
						}
						
					} while (true);
					}
				}
				else {
					break _loop393;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ATTRIBUTE_VALUE_CANDIDATE",
		"RANGE_OF_VALUES_CANDIDATE",
		"SP",
		"OPEN_CURLY",
		"SEP",
		"CLOSE_CURLY",
		"\"identificationTag\"",
		"SAFEUTF8STRING",
		"\"precedence\"",
		"INTEGER",
		"\"authenticationLevel\"",
		"\"none\"",
		"\"simple\"",
		"\"strong\"",
		"\"itemOrUserFirst\"",
		"\"itemFirst\"",
		"COLON",
		"\"userFirst\"",
		"\"protectedItems\"",
		"\"entry\"",
		"\"allUserAttributeTypes\"",
		"\"attributeType\"",
		"\"allAttributeValues\"",
		"\"allUserAttributeTypesAndValues\"",
		"\"selfValue\"",
		"\"maxValueCount\"",
		"\"type\"",
		"\"maxCount\"",
		"\"maxImmSub\"",
		"\"restrictedBy\"",
		"\"valuesIn\"",
		"\"classes\"",
		"\"itemPermissions\"",
		"\"grantsAndDenials\"",
		"\"grantAdd\"",
		"\"denyAdd\"",
		"\"grantDiscloseOnError\"",
		"\"denyDiscloseOnError\"",
		"\"grantRead\"",
		"\"denyRead\"",
		"\"grantRemove\"",
		"\"denyRemove\"",
		"\"grantBrowse\"",
		"\"denyBrowse\"",
		"\"grantExport\"",
		"\"denyExport\"",
		"\"grantImport\"",
		"\"denyImport\"",
		"\"grantModify\"",
		"\"denyModify\"",
		"\"grantRename\"",
		"\"denyRename\"",
		"\"grantReturnDN\"",
		"\"denyReturnDN\"",
		"\"grantCompare\"",
		"\"denyCompare\"",
		"\"grantFilterMatch\"",
		"\"denyFilterMatch\"",
		"\"grantInvoke\"",
		"\"denyInvoke\"",
		"\"userClasses\"",
		"\"allUsers\"",
		"\"thisEntry\"",
		"\"parentOfEntry\"",
		"\"name\"",
		"\"userGroup\"",
		"\"subtree\"",
		"\"userPermissions\"",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"\"FALSE\"",
		"\"TRUE\"",
		"\"level\"",
		"\"basicLevels\"",
		"\"localQualifier\"",
		"\"signed\"",
		"\"rangeOfValues\"",
		"\"specificationFilter\"",
		"SAFEUTF8CHAR",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"HYPHEN",
		"DOT",
		"INTEGER_OR_NUMERICOID",
		"FILTER",
		"FILTER_VALUE"
	};
	
	
	}
